/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.view;

import java.util.HashSet;
import java.util.Set;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.table.CyColumnView;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.model.table.CyTableViewManager;
import org.cytoscape.view.vizmap.TableVisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.events.VisualStyleChangedEvent;
import org.cytoscape.view.vizmap.events.VisualStyleChangedListener;
import org.cytoscape.view.vizmap.events.table.ColumnVisualStyleSetEvent;
import org.cytoscape.view.vizmap.events.table.ColumnVisualStyleSetListener;

public class TableBrowserStyleMediator
implements VisualStyleChangedListener,
ColumnVisualStyleSetListener {
    private final CyServiceRegistrar registrar;

    public TableBrowserStyleMediator(CyServiceRegistrar registrar) {
        this.registrar = registrar;
    }

    public void handleEvent(ColumnVisualStyleSetEvent e) {
        CyColumnView view = (CyColumnView)e.getColumnView();
        VisualStyle style = e.getVisualStyle();
        this.updateColumn(view, style);
    }

    public void handleEvent(VisualStyleChangedEvent e) {
        VisualStyle style = (VisualStyle)e.getSource();
        Set<CyColumnView> columns = this.findColumnsWithStyle(style);
        for (CyColumnView colView : columns) {
            this.updateColumn(colView, style);
        }
    }

    private void updateColumn(CyColumnView view, VisualStyle style) {
        if (style == null) {
            view.clearVisualProperties();
        } else {
            style.apply((View)view);
        }
    }

    private Set<CyColumnView> findColumnsWithStyle(VisualStyle style) {
        CyTableManager tableManager = (CyTableManager)this.registrar.getService(CyTableManager.class);
        TableVisualMappingManager visualMappingManager = (TableVisualMappingManager)this.registrar.getService(TableVisualMappingManager.class);
        CyTableViewManager tableViewManager = (CyTableViewManager)this.registrar.getService(CyTableViewManager.class);
        HashSet<CyColumnView> views = new HashSet<CyColumnView>();
        Set tables = tableManager.getAllTables(false);
        for (CyTable table : tables) {
            CyTableView tableView = tableViewManager.getTableView(table);
            if (tableView == null) continue;
            for (View colView : tableView.getColumnViews()) {
                VisualStyle colStyle = visualMappingManager.getVisualStyle(colView);
                if (colStyle == null || !colStyle.equals(style)) continue;
                views.add((CyColumnView)colView);
            }
        }
        return views;
    }
}

