/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;

public final class TableBrowserUtil {
    private static final int EOF = -1;

    public static Map<String, Class<?>> getAttNameToTypeMap(CyTable table, String ignore) {
        HashMap map = new HashMap();
        for (CyColumn column : table.getColumns()) {
            map.put(column.getName(), column.getType());
        }
        if (ignore != null) {
            map.remove(ignore);
        }
        return map;
    }

    public static Object parseLong(String text, StringBuilder errorMessage) {
        try {
            return Long.valueOf(text);
        }
        catch (Exception e) {
            errorMessage.append("Can't convert text to a whole number.");
            return null;
        }
    }

    public static Object parseInteger(String text, StringBuilder errorMessage) {
        try {
            return Integer.valueOf(text);
        }
        catch (Exception e) {
            errorMessage.append("Can't convert text to a whole number.");
            return null;
        }
    }

    public static Object parseDouble(String text, StringBuilder errorMessage) {
        try {
            return Double.valueOf(text);
        }
        catch (Exception e) {
            errorMessage.append("Can't convert text to a floating point number.");
            return null;
        }
    }

    public static Object parseBoolean(String text, StringBuilder errorMessage) {
        if (text.compareToIgnoreCase("true") == 0) {
            return true;
        }
        if (text.compareToIgnoreCase("false") == 0) {
            return false;
        }
        errorMessage.append("Can't convert text to a truth value.");
        return null;
    }

    public static List<Object> parseCellInput(CyTable dataTable, String columnName, Object value) {
        List<Object> parsedValue;
        String text = (String)value;
        Class columnType = dataTable.getColumn(columnName).getType();
        StringBuilder errorMessage = new StringBuilder();
        if (columnType == String.class) {
            parsedValue = text;
        } else if (columnType == Long.class) {
            parsedValue = TableBrowserUtil.parseLong(text, errorMessage);
        } else if (columnType == Integer.class) {
            parsedValue = TableBrowserUtil.parseInteger(text, errorMessage);
        } else if (columnType == Double.class) {
            parsedValue = TableBrowserUtil.parseDouble(text, errorMessage);
        } else if (columnType == Boolean.class) {
            parsedValue = TableBrowserUtil.parseBoolean(text, errorMessage);
        } else if (columnType == List.class) {
            parsedValue = TableBrowserUtil.parseList(text, dataTable.getColumn(columnName).getListElementType(), errorMessage);
        } else {
            throw new IllegalStateException("unknown column type: " + columnType.getName() + ".");
        }
        ArrayList<Object> retValue = new ArrayList<Object>();
        retValue.add(parsedValue);
        retValue.add(errorMessage);
        return retValue;
    }

    public static boolean isShowPrivateTables(CyServiceRegistrar serviceRegistrar) {
        CyProperty cyProp = (CyProperty)serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        Properties props = cyProp != null ? (Properties)cyProp.getProperties() : null;
        return props != null && "true".equalsIgnoreCase(props.getProperty("showPrivateTables"));
    }

    static List<Object> parseList(String text, Class<?> listElementType, StringBuilder errorMessage) {
        ArrayList<Object> newList = new ArrayList<Object>();
        StringReader reader = new StringReader(text);
        ListParserState state = ListParserState.OPENING_BRACE_EXPECTED;
        while (true) {
            int ch = -1;
            try {
                reader.mark(0);
                ch = reader.read();
            }
            catch (IOException e) {
                throw new IllegalStateException("We should *never* get here.");
            }
            if (ch == 10 || ch == 9 || ch == 32) continue;
            switch (state) {
                case OPENING_BRACE_EXPECTED: {
                    if (ch == 91) {
                        state = ListParserState.ITEM_OR_CLOSING_BRACE_EXPECTED;
                        break;
                    }
                    errorMessage.append("List must start with '['.");
                    return null;
                }
                case ITEM_OR_CLOSING_BRACE_EXPECTED: {
                    if (ch == 93) {
                        state = ListParserState.END_OF_INPUT_EXPECTED;
                        break;
                    }
                }
                case ITEM_EXPECTED: {
                    if (ch == -1) {
                        errorMessage.append("Premature end of list.");
                        return null;
                    }
                    try {
                        reader.reset();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("We should *never* get here.");
                    }
                    Object item = TableBrowserUtil.getListItem(reader, listElementType, errorMessage);
                    if (item == null) {
                        return null;
                    }
                    newList.add(item);
                    state = ListParserState.COMMA_OR_CLOSING_BRACE_EXPECTED;
                    break;
                }
                case COMMA_OR_CLOSING_BRACE_EXPECTED: {
                    if (ch == 93) {
                        state = ListParserState.END_OF_INPUT_EXPECTED;
                        break;
                    }
                    if (ch == 44) {
                        state = ListParserState.ITEM_EXPECTED;
                        break;
                    }
                    errorMessage.append("Unexpected character(s) in list detected.");
                    return null;
                }
                case END_OF_INPUT_EXPECTED: {
                    if (ch != -1) {
                        errorMessage.append("Unexpected garbage after end of list.");
                        return null;
                    }
                    return newList;
                }
            }
        }
    }

    private static Object getListItem(StringReader reader, Class<?> listElementType, StringBuilder errorMessage) {
        if (listElementType == Double.class) {
            return TableBrowserUtil.getDouble(reader, errorMessage);
        }
        if (listElementType == String.class) {
            return TableBrowserUtil.getString(reader, errorMessage);
        }
        if (listElementType == Integer.class || listElementType == Long.class) {
            int ch = -1;
            try {
                reader.mark(0);
                ch = reader.read();
            }
            catch (IOException e) {
                throw new IllegalStateException("We should *never* get here.");
            }
            StringBuilder builder = new StringBuilder();
            if (ch == 45) {
                builder.append((char)ch);
            } else if (ch != 43) {
                try {
                    reader.reset();
                }
                catch (IOException e) {
                    throw new IllegalStateException("We should *never* get here.");
                }
            }
            TableBrowserUtil.grabAsciiDigits(reader, builder);
            try {
                if (listElementType == Integer.class) {
                    return Integer.valueOf(builder.toString());
                }
                return Long.valueOf(builder.toString());
            }
            catch (NumberFormatException e) {
                errorMessage.append("Found invalid integer or long integer list item.");
                return null;
            }
        }
        if (listElementType == Boolean.class) {
            StringBuilder builder = new StringBuilder();
            TableBrowserUtil.grabAsciiLetters(reader, builder);
            String boolValueCandidate = builder.toString();
            if (boolValueCandidate.equalsIgnoreCase("true")) {
                return true;
            }
            if (boolValueCandidate.equalsIgnoreCase("false")) {
                return false;
            }
            errorMessage.append("\"" + boolValueCandidate + "\" is not a valid boolean list item.");
            return null;
        }
        throw new IllegalStateException("unknown list element type: " + listElementType.getName() + ".");
    }

    private static Double getDouble(StringReader reader, StringBuilder errorMessage) {
        try {
            reader.mark(0);
            int ch = reader.read();
            if (ch == -1) {
                errorMessage.append("Unexpected end of input while trying to read a floating point number.");
                return null;
            }
            StringBuilder builder = new StringBuilder();
            if (ch == 45 || ch == 43) {
                builder.append((char)ch);
            } else {
                reader.reset();
            }
            int savedLength = builder.length();
            TableBrowserUtil.grabAsciiDigits(reader, builder);
            boolean needAfterDecimalPointDigits = builder.length() == savedLength;
            reader.mark(0);
            ch = reader.read();
            if (ch != 46) {
                if (needAfterDecimalPointDigits) {
                    errorMessage.append("Bad or missing floating point list item.");
                    return null;
                }
                reader.reset();
            } else {
                builder.append('.');
                savedLength = builder.length();
                TableBrowserUtil.grabAsciiDigits(reader, builder);
                if (needAfterDecimalPointDigits && savedLength == builder.length()) {
                    errorMessage.append("Bad or missing floating point list item.");
                    return null;
                }
            }
            reader.mark(0);
            ch = reader.read();
            if (ch != 101 && ch != 69) {
                reader.reset();
            } else {
                builder.append('e');
                reader.mark(0);
                ch = reader.read();
                if (ch != 43 && ch != 45) {
                    reader.reset();
                } else {
                    builder.append((char)ch);
                }
                savedLength = builder.length();
                TableBrowserUtil.grabAsciiDigits(reader, builder);
                if (builder.length() == savedLength) {
                    errorMessage.append("Invalid exponent.");
                    return null;
                }
            }
            try {
                return Double.valueOf(builder.toString());
            }
            catch (Exception e) {
                errorMessage.append("Malformed number.");
                return null;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("This should *never* happen.");
        }
    }

    private static void grabAsciiDigits(StringReader reader, StringBuilder builder) {
        try {
            while (true) {
                reader.mark(0);
                int ch = reader.read();
                if (ch == -1 || (char)ch < '0' || (char)ch > '9') {
                    reader.reset();
                    return;
                }
                builder.append((char)ch);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("This should *never* happen.");
        }
    }

    private static String getString(StringReader reader, StringBuilder errorMessage) {
        try {
            if (reader.read() != 34) {
                errorMessage.append("Strings must start with a double quote symbol.");
                return null;
            }
            StringBuilder builder = new StringBuilder();
            int ch = reader.read();
            boolean escaped = false;
            while (escaped || ch != 34) {
                if (ch == -1) {
                    errorMessage.append("Unterminated string list item.");
                    return null;
                }
                if (escaped) {
                    switch (ch) {
                        case 110: {
                            builder.append('\n');
                            break;
                        }
                        case 116: {
                            builder.append('\t');
                            break;
                        }
                        case 114: {
                            builder.append('\r');
                            break;
                        }
                        case 102: {
                            builder.append('\f');
                            break;
                        }
                        case 98: {
                            builder.append('\b');
                            break;
                        }
                        case 34: {
                            builder.append('\"');
                            break;
                        }
                        case 92: {
                            builder.append('\\');
                            break;
                        }
                        default: {
                            builder.append((char)ch);
                        }
                    }
                    escaped = false;
                } else if (ch == 92) {
                    escaped = true;
                } else {
                    builder.append((char)ch);
                }
                ch = reader.read();
            }
            return builder.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("This should *never* happen.");
        }
    }

    private static void grabAsciiLetters(StringReader reader, StringBuilder builder) {
        try {
            while (true) {
                reader.mark(0);
                int ch = reader.read();
                if (ch == -1 || ((char)ch < 'a' || (char)ch > 'z') && ((char)ch < 'A' || (char)ch > 'Z')) {
                    reader.reset();
                    return;
                }
                builder.append((char)ch);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("This should *never* happen.");
        }
    }

    static enum ListParserState {
        OPENING_BRACE_EXPECTED,
        COMMA_OR_CLOSING_BRACE_EXPECTED,
        ITEM_OR_CLOSING_BRACE_EXPECTED,
        ITEM_EXPECTED,
        END_OF_INPUT_EXPECTED;

    }
}

