/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.task;

import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.browser.internal.format.SetColumnFormatDialog;
import org.cytoscape.browser.internal.view.AbstractTableBrowser;
import org.cytoscape.browser.internal.view.TableRenderer;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractTableColumnTask;
import org.cytoscape.work.TaskMonitor;

public class SetColumnFormatTask
extends AbstractTableColumnTask {
    private CyServiceRegistrar serviceRegistrar;

    public SetColumnFormatTask(CyColumn column, CyServiceRegistrar serviceRegistrar) {
        super(column);
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        SwingUtilities.invokeLater(() -> {
            CySwingApplication swingAppManager = (CySwingApplication)this.serviceRegistrar.getService(CySwingApplication.class);
            CyTable table = this.column.getTable();
            String name = this.column.getName();
            TableRenderer browserTable = SetColumnFormatTask.getTableRenderer(table, this.serviceRegistrar);
            JFrame frame = swingAppManager.getJFrame();
            SetColumnFormatDialog dialog = new SetColumnFormatDialog(browserTable, frame, name, this.serviceRegistrar);
            dialog.pack();
            dialog.setLocationRelativeTo(frame);
            dialog.setVisible(true);
        });
    }

    public static TableRenderer getTableRenderer(CyTable table, CyServiceRegistrar serviceRegistrar) {
        CySwingApplication swingAppManager = (CySwingApplication)serviceRegistrar.getService(CySwingApplication.class);
        CytoPanel cytoPanel = swingAppManager.getCytoPanel(CytoPanelName.SOUTH);
        if (cytoPanel != null) {
            int count = cytoPanel.getCytoPanelComponentCount();
            for (int i = 0; i < count; ++i) {
                AbstractTableBrowser tableBrowser;
                TableRenderer browserTable;
                Component c = cytoPanel.getComponentAt(i);
                if (!(c instanceof AbstractTableBrowser) || (browserTable = (tableBrowser = (AbstractTableBrowser)c).getTableRenderer(table)) == null) continue;
                return browserTable;
            }
        }
        return null;
    }
}

