/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.task;

import org.cytoscape.browser.internal.task.DeleteTableTask;
import org.cytoscape.browser.internal.view.TableBrowserMediator;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractTableTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public final class DeleteTableTaskFactoryImpl
extends AbstractTableTaskFactory {
    private final TableBrowserMediator mediator;
    private final CyServiceRegistrar serviceRegistrar;

    public DeleteTableTaskFactoryImpl(TableBrowserMediator mediator, CyServiceRegistrar serviceRegistrar) {
        this.mediator = mediator;
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator(CyTable table) {
        if (table == null) {
            throw new IllegalStateException("'table' must not be null.");
        }
        return new TaskIterator(new Task[]{new DeleteTableTask(table, this.serviceRegistrar)});
    }

    public boolean isReady(CyTable table) {
        return table != null && table.getMutability() == CyTable.Mutability.MUTABLE;
    }

    public boolean isApplicable(CyTable table) {
        if (table == null) {
            return false;
        }
        Class<? extends CyIdentifiable> type = this.mediator.getTableType(table);
        if (type == null) {
            return true;
        }
        int count = this.mediator.getTableCount(type);
        return count > 1;
    }
}

