/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CyColumnPresentationManager;
import org.cytoscape.application.swing.CyColumnSelector;
import org.cytoscape.browser.internal.view.TableBrowserMediator;
import org.cytoscape.browser.internal.view.TableRenderer;
import org.cytoscape.model.CyColumn;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;

public class ShowColumnsAction
extends AbstractCyAction {
    private static String TITLE = "Show Columns...";
    private CyColumnSelector columnSelector;
    private final TableBrowserMediator mediator;
    private final CyServiceRegistrar serviceRegistrar;

    public ShowColumnsAction(Icon icon, float toolbarGravity, TableBrowserMediator mediator, CyServiceRegistrar serviceRegistrar) {
        super(TITLE);
        this.mediator = mediator;
        this.serviceRegistrar = serviceRegistrar;
        this.putValue("ShortDescription", TITLE);
        this.putValue("SwingLargeIconKey", icon);
        this.setIsInNodeTableToolBar(true);
        this.setIsInEdgeTableToolBar(true);
        this.setIsInNetworkTableToolBar(true);
        this.setIsInUnassignedTableToolBar(true);
        this.setToolbarGravity(toolbarGravity);
        this.insertSeparatorAfter = true;
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof Component) {
            this.showColumnSelectorPopup((Component)source);
        }
    }

    private void showColumnSelectorPopup(Component invoker) {
        final TableRenderer renderer = this.mediator.getCurrentTableRenderer();
        if (renderer == null) {
            return;
        }
        CyTableView tableView = renderer.getTableView();
        Collection columnViews = tableView.getColumnViews();
        ArrayList<CyColumn> columns = new ArrayList<CyColumn>();
        ArrayList<String> visibleColumns = new ArrayList<String>();
        for (View view : columnViews) {
            columns.add((CyColumn)view.getModel());
            if (!Boolean.TRUE.equals(view.getVisualProperty(BasicTableVisualLexicon.COLUMN_VISIBLE))) continue;
            visibleColumns.add(((CyColumn)view.getModel()).getName());
        }
        this.getColumnSelector().update(columns, visibleColumns);
        final JPopupMenu popup = new JPopupMenu();
        popup.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Separator.foreground")));
        popup.add((Component)this.getColumnSelector());
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                try {
                    Set visibleAttributes = ShowColumnsAction.this.getColumnSelector().getSelectedColumnNames();
                    if (renderer != null) {
                        Collection columnViews = renderer.getTableView().getColumnViews();
                        for (View columnView : columnViews) {
                            boolean visible = visibleAttributes.contains(((CyColumn)columnView.getModel()).getName());
                            TableRenderer.setColumnVisible((View<CyColumn>)columnView, visible);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        popup.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    popup.setVisible(false);
                }
            }
        });
        popup.pack();
        popup.show(invoker, 0, invoker.getHeight());
    }

    private CyColumnSelector getColumnSelector() {
        if (this.columnSelector == null) {
            IconManager iconManager = (IconManager)this.serviceRegistrar.getService(IconManager.class);
            CyColumnPresentationManager presetationManager = (CyColumnPresentationManager)this.serviceRegistrar.getService(CyColumnPresentationManager.class);
            this.columnSelector = new CyColumnSelector(iconManager, presetationManager);
        }
        return this.columnSelector;
    }
}

