/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.opencl.cycl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Scanner;
import org.cytoscape.opencl.cycl.CyCLContext;
import org.cytoscape.opencl.cycl.CyCLDevice;
import org.cytoscape.opencl.cycl.CyCLException;
import org.cytoscape.opencl.cycl.CyCLKernel;
import org.lwjgl.BufferUtils;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLProgram;
import org.lwjgl.opencl.OpenCLException;
import org.lwjgl.opencl.Util;

public class CyCLProgram {
    private Boolean finalized = false;
    private CLProgram program;
    private Hashtable<String, CyCLKernel> kernels = new Hashtable();
    private HashMap<String, String> defines;

    public CyCLProgram(CyCLContext context, CyCLDevice device, URL resourcePath, String[] kernelNames, HashMap<String, String> defines, boolean silentCompilation) throws IOException {
        InputStream programTextStream = resourcePath.openStream();
        Scanner programTextScanner = new Scanner(programTextStream, "UTF-8");
        String programText = programTextScanner.useDelimiter("\\Z").next();
        programTextScanner.close();
        programTextStream.close();
        this.prepareAndBuildProgram(context, device, new String[]{programText}, kernelNames, defines, silentCompilation);
    }

    public CyCLProgram(CyCLContext context, CyCLDevice device, String source, String[] kernelNames, HashMap<String, String> defines, boolean silentCompilation) {
        this.prepareAndBuildProgram(context, device, new String[]{source}, kernelNames, defines, silentCompilation);
    }

    public CyCLProgram(CyCLContext context, CyCLDevice device, String[] sources, String[] kernelNames, HashMap<String, String> defines, boolean silentCompilation) {
        this.prepareAndBuildProgram(context, device, sources, kernelNames, defines, silentCompilation);
    }

    private void prepareAndBuildProgram(CyCLContext context, CyCLDevice device, String[] sources, String[] kernelNames, HashMap<String, String> defines, boolean silentCompilation) {
        try {
            this.defines = defines;
            StringBuilder buildOptions = new StringBuilder();
            if (defines != null) {
                for (Map.Entry<String, String> entry : defines.entrySet()) {
                    if (entry.getValue() == null) {
                        buildOptions.append(" -D").append(entry.getKey());
                        continue;
                    }
                    buildOptions.append(" -D").append(entry.getKey()).append("=").append(entry.getValue());
                }
            }
            IntBuffer errorBuffer = BufferUtils.createIntBuffer((int)1);
            this.program = CL10.clCreateProgramWithSource((CLContext)context.getContext(), (CharSequence[])sources, (IntBuffer)errorBuffer);
            Util.checkCLError((int)errorBuffer.get(0));
            Util.checkCLError((int)CL10.clBuildProgram((CLProgram)this.program, (CLDevice)device.getDevice(), (CharSequence)buildOptions.toString(), null));
            for (String kernelName : kernelNames) {
                this.kernels.put(kernelName, new CyCLKernel(context, this, kernelName));
            }
        }
        catch (OpenCLException exc) {
            if (!silentCompilation && this.program != null) {
                System.out.println(this.program.getBuildInfoString(device.getDevice(), 4483));
            }
            System.out.println("Could not create CL program");
            throw new CyCLException("Could not create CL program", exc);
        }
        catch (Exception exc) {
            throw new CyCLException("Could not create CL program", exc);
        }
    }

    public CLProgram getProgram() {
        return this.program;
    }

    public CyCLKernel getKernel(String name) {
        return this.kernels.get(name);
    }

    protected void finalize() {
        try {
            if (this.finalized.booleanValue()) {
                return;
            }
            for (Map.Entry<String, CyCLKernel> entry : this.kernels.entrySet()) {
                entry.getValue().finalize();
            }
            this.kernels.clear();
            Util.checkCLError((int)CL10.clReleaseProgram((CLProgram)this.program));
            this.finalized = true;
            super.finalize();
        }
        catch (Throwable exc) {
            System.out.println("Could not finalize CyCLProgram " + this.program + ": " + exc.getMessage());
            throw new CyCLException("Could not finalize CyCLProgram object.");
        }
    }
}

