/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.opencl.cycl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.cytoscape.opencl.cycl.CyCLContext;
import org.lwjgl.BufferUtils;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLMem;
import org.lwjgl.opencl.Util;

public class CyCLBuffer {
    private Boolean finalized = false;
    private CyCLContext context;
    private Class<?> type;
    private int elements;
    private CLMem memObject;
    private ByteBuffer buffer;

    public CyCLBuffer(CyCLContext context, Class<?> type, int elements) {
        this.context = context;
        this.type = type;
        this.elements = elements;
        this.buffer = BufferUtils.createByteBuffer((int)this.sizeInBytes());
        IntBuffer errorBuffer = BufferUtils.createIntBuffer((int)1);
        this.memObject = CL10.clCreateBuffer((CLContext)context.getContext(), (long)33L, (ByteBuffer)this.buffer, (IntBuffer)errorBuffer);
        Util.checkCLError((int)errorBuffer.get(0));
    }

    public CyCLBuffer(CyCLContext context, byte[] data) {
        this(context, Byte.TYPE, data.length);
        this.setFromHost(data);
    }

    public CyCLBuffer(CyCLContext context, short[] data) {
        this(context, Short.TYPE, data.length);
        this.setFromHost(data);
    }

    public CyCLBuffer(CyCLContext context, int[] data) {
        this(context, Integer.TYPE, data.length);
        this.setFromHost(data);
    }

    public CyCLBuffer(CyCLContext context, long[] data) {
        this(context, Long.TYPE, data.length);
        this.setFromHost(data);
    }

    public CyCLBuffer(CyCLContext context, float[] data) {
        this(context, Float.TYPE, data.length);
        this.setFromHost(data);
    }

    public CyCLBuffer(CyCLContext context, double[] data) {
        this(context, Double.TYPE, data.length);
        this.setFromHost(data);
    }

    public int elementSize() {
        if (this.type.equals(Character.TYPE)) {
            return 1;
        }
        if (this.type.equals(Byte.TYPE)) {
            return 1;
        }
        if (this.type.equals(Short.TYPE)) {
            return 2;
        }
        if (this.type.equals(Float.TYPE)) {
            return 4;
        }
        if (this.type.equals(Integer.TYPE)) {
            return 4;
        }
        if (this.type.equals(Double.TYPE)) {
            return 8;
        }
        if (this.type.equals(Long.TYPE)) {
            return 8;
        }
        return 1;
    }

    public int sizeInBytes() {
        return this.elementSize() * this.elements;
    }

    public void setFromHost(byte[] data, int length, int offset) {
        this.buffer.put(data);
        this.buffer.rewind();
        CL10.clEnqueueWriteBuffer((CLCommandQueue)this.context.getQueue(), (CLMem)this.memObject, (int)1, (long)offset, (ByteBuffer)this.buffer, null, null);
        CL10.clFinish((CLCommandQueue)this.context.getQueue());
    }

    public void setFromHost(short[] data, int length, int offset) {
        this.buffer.asShortBuffer().put(data);
        CL10.clEnqueueWriteBuffer((CLCommandQueue)this.context.getQueue(), (CLMem)this.memObject, (int)1, (long)offset, (ByteBuffer)this.buffer, null, null);
        CL10.clFinish((CLCommandQueue)this.context.getQueue());
    }

    public void setFromHost(int[] data, int length, int offset) {
        this.buffer.asIntBuffer().put(data);
        CL10.clEnqueueWriteBuffer((CLCommandQueue)this.context.getQueue(), (CLMem)this.memObject, (int)1, (long)offset, (ByteBuffer)this.buffer, null, null);
        CL10.clFinish((CLCommandQueue)this.context.getQueue());
    }

    public void setFromHost(long[] data, int length, int offset) {
        this.buffer.asLongBuffer().put(data);
        CL10.clEnqueueWriteBuffer((CLCommandQueue)this.context.getQueue(), (CLMem)this.memObject, (int)1, (long)offset, (ByteBuffer)this.buffer, null, null);
        CL10.clFinish((CLCommandQueue)this.context.getQueue());
    }

    public void setFromHost(float[] data, int length, int offset) {
        this.buffer.asFloatBuffer().put(data);
        CL10.clEnqueueWriteBuffer((CLCommandQueue)this.context.getQueue(), (CLMem)this.memObject, (int)1, (long)offset, (ByteBuffer)this.buffer, null, null);
        CL10.clFinish((CLCommandQueue)this.context.getQueue());
    }

    public void setFromHost(double[] data, int length, int offset) {
        this.buffer.asDoubleBuffer().put(data);
        CL10.clEnqueueWriteBuffer((CLCommandQueue)this.context.getQueue(), (CLMem)this.memObject, (int)1, (long)offset, (ByteBuffer)this.buffer, null, null);
        CL10.clFinish((CLCommandQueue)this.context.getQueue());
    }

    public void setFromHost(byte[] data) {
        this.setFromHost(data, this.sizeInBytes(), 0);
    }

    public void setFromHost(short[] data) {
        this.setFromHost(data, this.sizeInBytes(), 0);
    }

    public void setFromHost(int[] data) {
        this.setFromHost(data, this.sizeInBytes(), 0);
    }

    public void setFromHost(long[] data) {
        this.setFromHost(data, this.sizeInBytes(), 0);
    }

    public void setFromHost(float[] data) {
        this.setFromHost(data, this.sizeInBytes(), 0);
    }

    public void setFromHost(double[] data) {
        this.setFromHost(data, this.sizeInBytes(), 0);
    }

    public void setFromDevice(CyCLBuffer src, long bytes, long offsetSrc, long offsetDst) {
        CL10.clEnqueueCopyBuffer((CLCommandQueue)this.context.getQueue(), (CLMem)src.getMemObject(), (CLMem)this.memObject, (long)offsetSrc, (long)offsetDst, (long)bytes, null, null);
    }

    public void setFromDevice(CyCLBuffer src) {
        this.setFromDevice(src, this.sizeInBytes(), 0L, 0L);
    }

    public void getFromDevice(byte[] data, int length, int offset) {
        CL10.clEnqueueReadBuffer((CLCommandQueue)this.context.getQueue(), (CLMem)this.memObject, (int)1, (long)offset, (ByteBuffer)this.buffer, null, null);
        CL10.clFinish((CLCommandQueue)this.context.getQueue());
        this.buffer.get(data);
    }

    public void getFromDevice(short[] data, int length, int offset) {
        CL10.clEnqueueReadBuffer((CLCommandQueue)this.context.getQueue(), (CLMem)this.memObject, (int)1, (long)offset, (ByteBuffer)this.buffer, null, null);
        CL10.clFinish((CLCommandQueue)this.context.getQueue());
        this.buffer.asShortBuffer().get(data);
    }

    public void getFromDevice(int[] data, int length, int offset) {
        CL10.clEnqueueReadBuffer((CLCommandQueue)this.context.getQueue(), (CLMem)this.memObject, (int)1, (long)offset, (ByteBuffer)this.buffer, null, null);
        CL10.clFinish((CLCommandQueue)this.context.getQueue());
        this.buffer.asIntBuffer().get(data);
    }

    public void getFromDevice(long[] data, int length, int offset) {
        CL10.clEnqueueReadBuffer((CLCommandQueue)this.context.getQueue(), (CLMem)this.memObject, (int)1, (long)offset, (ByteBuffer)this.buffer, null, null);
        CL10.clFinish((CLCommandQueue)this.context.getQueue());
        this.buffer.asLongBuffer().get(data);
    }

    public void getFromDevice(float[] data, int length, int offset) {
        CL10.clEnqueueReadBuffer((CLCommandQueue)this.context.getQueue(), (CLMem)this.memObject, (int)1, (long)offset, (ByteBuffer)this.buffer, null, null);
        CL10.clFinish((CLCommandQueue)this.context.getQueue());
        this.buffer.asFloatBuffer().get(data);
    }

    public void getFromDevice(double[] data, int length, int offset) {
        CL10.clEnqueueReadBuffer((CLCommandQueue)this.context.getQueue(), (CLMem)this.memObject, (int)1, (long)offset, (ByteBuffer)this.buffer, null, null);
        CL10.clFinish((CLCommandQueue)this.context.getQueue());
        this.buffer.asDoubleBuffer().get(data);
    }

    public void getFromDevice(byte[] data) {
        this.getFromDevice(data, this.sizeInBytes(), 0);
    }

    public void getFromDevice(short[] data) {
        this.getFromDevice(data, this.sizeInBytes(), 0);
    }

    public void getFromDevice(int[] data) {
        this.getFromDevice(data, this.sizeInBytes(), 0);
    }

    public void getFromDevice(long[] data) {
        this.getFromDevice(data, this.sizeInBytes(), 0);
    }

    public void getFromDevice(float[] data) {
        this.getFromDevice(data, this.sizeInBytes(), 0);
    }

    public void getFromDevice(double[] data) {
        this.getFromDevice(data, this.sizeInBytes(), 0);
    }

    public CLMem getMemObject() {
        return this.memObject;
    }

    public void free() {
        this.finalize();
    }

    protected void finalize() {
        try {
            if (this.finalized.booleanValue()) {
                return;
            }
            Util.checkCLError((int)CL10.clReleaseMemObject((CLMem)this.memObject));
            this.finalized = true;
            super.finalize();
        }
        catch (Throwable exc) {
            System.out.println("Could not finalize CyCLBuffer size " + this.sizeInBytes() + ": " + exc.getMessage());
            throw new RuntimeException("Could not finalize CyCLBuffer object.");
        }
    }
}

