/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.datasource.internal.bookmarks;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.datasource.DataSource;
import org.cytoscape.io.datasource.DefaultDataSource;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.bookmark.Bookmarks;
import org.cytoscape.property.bookmark.BookmarksUtil;
import org.cytoscape.property.bookmark.Category;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookmarkDataSourceBuilder {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final Map<String, DataCategory> CONVERSION_MAP = new HashMap<String, DataCategory>();
    private final Set<DataSource> datasourceSet;
    private final CyServiceRegistrar serviceRegistrar;

    public BookmarkDataSourceBuilder(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.datasourceSet = new HashSet<DataSource>();
        this.buildDataSource();
    }

    public Set<DataSource> getDataSources() {
        return this.datasourceSet;
    }

    private void buildDataSource() {
        BookmarksUtil bookmarksUtil = (BookmarksUtil)this.serviceRegistrar.getService(BookmarksUtil.class);
        Bookmarks bookMarks = (Bookmarks)((CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=bookmarks)")).getProperties();
        List categoryList = bookMarks.getCategory();
        for (Category category : categoryList) {
            List theDataSourceList;
            DataCategory dataType = CONVERSION_MAP.get(category.getName());
            if (dataType == null || (theDataSourceList = bookmarksUtil.getDataSourceList(category.getName(), categoryList)) == null) continue;
            for (org.cytoscape.property.bookmark.DataSource ds : theDataSourceList) {
                String location = ds.getHref();
                String name = ds.getName();
                String description = "From Bookmarks";
                String provider = "Example";
                URL url = null;
                try {
                    url = new URL(location);
                }
                catch (MalformedURLException e) {
                    logger.warn("Bookmark file coniatin invalid URL: " + location);
                    continue;
                }
                DefaultDataSource dataSource = new DefaultDataSource(name, "Example", "From Bookmarks", dataType, url);
                this.datasourceSet.add((DataSource)dataSource);
            }
        }
    }

    static {
        CONVERSION_MAP.put("network", DataCategory.NETWORK);
        CONVERSION_MAP.put("table", DataCategory.TABLE);
        CONVERSION_MAP.put("ontology", DataCategory.UNSPECIFIED);
        CONVERSION_MAP.put("plugins", DataCategory.UNSPECIFIED);
    }
}

