/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.cyBrowser.internal.view;

import edu.ucsf.rbvi.cyBrowser.internal.model.Bridge;
import edu.ucsf.rbvi.cyBrowser.internal.model.CyBrowser;
import edu.ucsf.rbvi.cyBrowser.internal.model.CyBrowserManager;
import edu.ucsf.rbvi.cyBrowser.internal.model.Downloader;
import edu.ucsf.rbvi.cyBrowser.internal.view.ResultsPanelBrowser;
import edu.ucsf.rbvi.cyBrowser.internal.view.SwingBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseButton;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import netscape.javascript.JSObject;
import org.apache.log4j.Logger;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.OpenBrowser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLFrameElement;
import org.w3c.dom.html.HTMLIFrameElement;

public class SwingPanel
extends JPanel {
    protected JFXPanel jfxPanel = new JFXPanel();
    private WebEngine engine;
    private final JLabel lblStatus = new JLabel();
    public static final String EVENT_TYPE_CLICK = "click";
    public static final String EVENT_TYPE_CONTEXT_MENU = "contextmenu";
    private final JTextField txtURL = new JTextField();
    private final JProgressBar progressBar = new JProgressBar();
    private JButton btnBack = null;
    private JButton btnForward = null;
    private final CyServiceRegistrar registrar;
    private final CyBrowserManager manager;
    private final SwingBrowser parent;
    private final JPanel panel;
    private final boolean showURL;
    private final boolean showDebug;
    private String callbackMethod = null;
    private String url = null;
    private boolean suppressLink = false;
    private String title = null;
    private String lastTitle = null;
    private String lastText = null;
    private String selection;
    private Element anchor;
    private Bridge jsBridge;
    private final String id;
    final Logger logger = Logger.getLogger((String)"org.cytoscape.application.userlog");

    public SwingPanel(CyBrowserManager manager, String id, SwingBrowser parentDialog, SwingPanel reuse, boolean showURL, boolean showDebug) {
        super(new BorderLayout());
        this.manager = manager;
        this.id = id;
        this.registrar = manager.getRegistrar();
        this.showURL = showURL;
        this.showDebug = showDebug;
        this.parent = parentDialog;
        this.panel = this;
        if (this.parent == null) {
            this.setPreferredSize(new Dimension(200, 600));
        }
        this.initComponents(reuse);
        Platform.setImplicitExit((boolean)false);
    }

    public String getURL() {
        return this.engine.getLocation();
    }

    public Document getText() {
        if (this.engine == null || this.engine.getDocument() == null) {
            return null;
        }
        return this.engine.getDocument();
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String execute(final String script) {
        final String[] returnVal = new String[1];
        if (Platform.isFxApplicationThread()) {
            return ((JSObject)this.engine.executeScript(script)).toString();
        }
        final CountDownLatch doneLatch = new CountDownLatch(1);
        final WebEngine engineTemp = this.engine;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Object obj = engineTemp.executeScript(script);
                    returnVal[0] = obj.toString();
                }
                finally {
                    doneLatch.countDown();
                }
            }
        });
        try {
            doneLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return returnVal[0];
    }

    private void initComponents(SwingPanel reuse) {
        if (reuse == null) {
            this.createScene();
        } else {
            this.jfxPanel = reuse.jfxPanel;
            this.engine = reuse.engine;
        }
        if (this.showURL) {
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingPanel.this.loadURL(SwingPanel.this.txtURL.getText());
                }
            };
            ActionListener open = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingPanel.this.openNativeBrowser(SwingPanel.this.txtURL.getText());
                }
            };
            this.txtURL.addActionListener(al);
            this.progressBar.setPreferredSize(new Dimension(150, 18));
            this.progressBar.setStringPainted(true);
            JPanel topBar = new JPanel(new BorderLayout(5, 0));
            topBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            JPanel leftButtonPanel = new JPanel(new FlowLayout());
            this.btnBack = this.createHistoryButton("\uf060", -1);
            this.btnForward = this.createHistoryButton("\uf061", 1);
            leftButtonPanel.add(this.btnBack);
            leftButtonPanel.add(this.btnForward);
            topBar.add((Component)leftButtonPanel, "West");
            topBar.add((Component)this.txtURL, "Center");
            JPanel rightButtonPanel = new JPanel(new FlowLayout());
            JButton btnGo = new JButton("Go");
            btnGo.addActionListener(al);
            rightButtonPanel.add(btnGo);
            if (this.showDebug) {
                JButton btnBug = this.createBugButton();
                rightButtonPanel.add(btnBug);
            }
            JButton btnOpen = new JButton("Open");
            btnOpen.setToolTipText("Open in native browser");
            btnOpen.addActionListener(open);
            rightButtonPanel.add(btnOpen);
            topBar.add((Component)rightButtonPanel, "East");
            JPanel statusBar = new JPanel(new BorderLayout(5, 0));
            statusBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            statusBar.add((Component)this.lblStatus, "Center");
            statusBar.add((Component)this.progressBar, "East");
            this.add((Component)topBar, "North");
            this.add((Component)statusBar, "South");
        }
        this.add((Component)this.jfxPanel, "Center");
    }

    private JButton createBugButton() {
        JButton btn = new JButton("\uf188");
        btn.setFont(((IconManager)this.registrar.getService(IconManager.class)).getIconFont(14.0f));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SwingPanel.this.engine.executeScript("if (!document.getElementById('FirebugLite')){E = document['createElement' + 'NS'] && document.documentElement.namespaceURI;E = E ? document['createElement' + 'NS'](E, 'script') : document['createElement']('script');E['setAttribute']('id', 'FirebugLite');E['setAttribute']('src', 'https://cdnjs.cloudflare.com/ajax/libs/firebug-lite/1.4.0/firebug-lite.min.js' + '#startOpened');E['setAttribute']('FirebugLite', '4');(document['getElementsByTagName']('head')[0] || document['getElementsByTagName']('body')[0]).appendChild(E);E = new Image;E['setAttribute']('src', 'https://cdnjs.cloudflare.com/ajax/libs/firebug-lite/1.4.0/firebug-lite.min.js' + '#startOpened');}");
                    }
                });
            }
        });
        return btn;
    }

    private JButton createHistoryButton(String icon, final int index) {
        JButton btn = new JButton(icon);
        btn.setFont(((IconManager)this.registrar.getService(IconManager.class)).getIconFont(14.0f));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SwingPanel.this.engine.getHistory().go(index);
                        SwingPanel.this.txtURL.setText(SwingPanel.this.getUrlFromHistory());
                        SwingPanel.this.enableControls();
                    }
                });
            }
        });
        btn.setEnabled(false);
        return btn;
    }

    private String getUrlFromHistory() {
        return ((WebHistory.Entry)this.engine.getHistory().getEntries().get(this.engine.getHistory().getCurrentIndex())).getUrl();
    }

    private void createScene() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebView view = new WebView();
                SwingPanel.this.engine = view.getEngine();
                String userAgent = SwingPanel.this.engine.getUserAgent();
                SwingPanel.this.engine.setUserAgent(userAgent + " CyBrowser/" + SwingPanel.this.manager.getVersion());
                view.setContextMenuEnabled(false);
                SwingPanel.this.createContextMenu(view);
                SwingPanel.this.engine.titleProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> observable, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SwingPanel.this.title = newValue;
                                if (SwingPanel.this.parent != null) {
                                    SwingPanel.this.parent.setTitle(SwingPanel.this.id, newValue);
                                }
                            }
                        });
                    }
                });
                SwingPanel.this.engine.setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(){

                    public void handle(WebEvent<String> event) {
                        Dialog alert = new Dialog();
                        alert.setTitle("CyBrowser Alert");
                        Label txt = new Label((String)event.getData());
                        txt.setStyle("-fx-text-alignment: center;");
                        alert.getDialogPane().setContent((Node)txt);
                        alert.getDialogPane().getButtonTypes().add((Object)ButtonType.OK);
                        Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
                        stage.setAlwaysOnTop(true);
                        stage.toFront();
                        alert.showAndWait();
                    }
                });
                SwingPanel.this.engine.setConfirmHandler((Callback)new Callback<String, Boolean>(){

                    public Boolean call(String message) {
                        Dialog confirm = new Dialog();
                        confirm.setTitle("CyBrowser Confirmation");
                        confirm.getDialogPane().setContentText(message);
                        confirm.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
                        Stage stage = (Stage)confirm.getDialogPane().getScene().getWindow();
                        stage.setAlwaysOnTop(true);
                        stage.toFront();
                        Optional result = confirm.showAndWait();
                        if (result.isPresent() && result.get() == ButtonType.YES) {
                            return true;
                        }
                        return false;
                    }
                });
                SwingPanel.this.engine.setOnStatusChanged((EventHandler)new EventHandler<WebEvent<String>>(){

                    public void handle(final WebEvent<String> event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SwingPanel.this.lblStatus.setText((String)event.getData());
                            }
                        });
                    }
                });
                SwingPanel.this.engine.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> ov, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SwingPanel.this.txtURL.setText(newValue);
                            }
                        });
                    }
                });
                SwingPanel.this.engine.getLoadWorker().exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

                    public void changed(ObservableValue<? extends Throwable> ov, Throwable t, Throwable t1) {
                        System.out.println("webEngine exception: " + t1.getMessage());
                    }
                });
                SwingPanel.this.engine.getLoadWorker().workDoneProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, final Number newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SwingPanel.this.progressBar.setValue(newValue.intValue());
                            }
                        });
                    }
                });
                SwingPanel.this.engine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                    public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                        if (newState == Worker.State.SUCCEEDED) {
                            JSObject jsobj = (JSObject)SwingPanel.this.engine.executeScript("window");
                            SwingPanel.this.jsBridge = new Bridge(SwingPanel.this.engine, SwingPanel.this.registrar, SwingPanel.this.parent);
                            jsobj.setMember("cybrowser", SwingPanel.this.jsBridge);
                            EventListener listener = new EventListener(){

                                @Override
                                public void handleEvent(Event ev) {
                                    String domEventType = ev.getType();
                                    if (domEventType.equals(SwingPanel.EVENT_TYPE_CLICK)) {
                                        if (SwingPanel.this.suppressLink) {
                                            if (ev.getCancelable()) {
                                                ev.preventDefault();
                                                ev.stopPropagation();
                                            }
                                            SwingPanel.this.suppressLink = false;
                                        } else {
                                            Element aElement = (Element)((Object)ev.getTarget());
                                            String href = null;
                                            boolean haveDownload = false;
                                            String download = null;
                                            String target = null;
                                            if (aElement.getTagName().equals("A")) {
                                                href = aElement.toString();
                                                haveDownload = aElement.hasAttribute("download");
                                                download = aElement.getAttribute("download");
                                                target = aElement.getAttribute("target");
                                            } else if (aElement.getParentNode().getNodeName().equals("A")) {
                                                Element pElement = (Element)aElement.getParentNode();
                                                download = pElement.getAttribute("download");
                                                haveDownload = pElement.hasAttribute("download");
                                                target = pElement.getAttribute("target");
                                                href = pElement.toString();
                                            }
                                            if (download == null || download.length() < 1) {
                                                download = null;
                                            }
                                            if (href != null && haveDownload) {
                                                SwingPanel.this.downloadAction(href, download, false);
                                                ev.preventDefault();
                                                ev.stopPropagation();
                                            } else if (href != null && href.startsWith("cycmd:")) {
                                                String command = href.substring("cycmd:".length());
                                                SwingPanel.this.jsBridge.executeCommand(command);
                                                ev.preventDefault();
                                                ev.stopPropagation();
                                            } else if (href != null && target != null && target.equalsIgnoreCase("_blank")) {
                                                SwingPanel.this.anchor = (Element)((Object)ev.getTarget());
                                                SwingPanel.this.openNewAction(true);
                                                ev.preventDefault();
                                                ev.stopPropagation();
                                            } else {
                                                CyBrowser current = SwingPanel.this.manager.getBrowser(SwingPanel.this.id);
                                                if (current != null) {
                                                    SwingPanel.this.lastTitle = current.getTitle(SwingPanel.this.id);
                                                }
                                                if (SwingPanel.this.txtURL != null) {
                                                    SwingPanel.this.lastText = SwingPanel.this.txtURL.getText();
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            Document doc = SwingPanel.this.engine.getDocument();
                            SwingPanel.this.addListenersToAnchors(doc, listener);
                            SwingPanel.this.enableControls();
                        } else if (newState == Worker.State.FAILED) {
                            Alert alert = new Alert(Alert.AlertType.ERROR);
                            alert.setTitle("Load failed");
                            Object alertText = "";
                            String exceptionMessage = SwingPanel.this.engine.getLoadWorker().getException().getMessage();
                            alertText = SwingPanel.this.url == null ? "\n\nFailed to load HTML text: " + exceptionMessage : "\n\nFailed to load '" + SwingPanel.this.url + "': " + exceptionMessage;
                            Text text = new Text((String)alertText);
                            text.setWrappingWidth(400.0);
                            text.setFont(Font.font((String)"Verdana", (double)10.0));
                            alert.getDialogPane().setStyle("-fx-padding: 4px,4px,4px,4px;");
                            alert.getDialogPane().setContent((Node)text);
                            alert.showAndWait();
                        } else if (newState == Worker.State.CANCELLED) {
                            try {
                                List<String> contentTypeList;
                                URL targ = new URL(SwingPanel.this.txtURL.getText());
                                URLConnection conn = targ.openConnection();
                                Map<String, List<String>> map = conn.getHeaderFields();
                                String fileName = null;
                                List<String> contentDisposition = map.get("Content-Disposition");
                                if (contentDisposition != null && !contentDisposition.isEmpty()) {
                                    for (String cd : contentDisposition) {
                                        int index = cd.indexOf("filename=");
                                        if (index == -1) continue;
                                        String fn = cd.substring(index + 9);
                                        if (fn.indexOf("\"") == -1) {
                                            fileName = fn;
                                            continue;
                                        }
                                        String[] st = fn.split("\"");
                                        fileName = st[1];
                                    }
                                }
                                if ((contentTypeList = map.get("Content-Type")) != null && !contentTypeList.isEmpty()) {
                                    String contentType = contentTypeList.get(0);
                                    if (contentType.equalsIgnoreCase("text/html")) {
                                        return;
                                    }
                                    SwingPanel.this.downloadAction(SwingPanel.this.txtURL.getText(), fileName, true);
                                    CyBrowser current = SwingPanel.this.manager.getBrowser(SwingPanel.this.id);
                                    String title = current.getTitle(SwingPanel.this.id);
                                    SwingPanel.this.parent.setTitle(SwingPanel.this.id, SwingPanel.this.lastTitle);
                                    SwingPanel.this.txtURL.setText(SwingPanel.this.lastText);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                SwingPanel.this.logger.error((Object)("Failed to download '" + SwingPanel.this.txtURL.getText() + "': " + e.getMessage()));
                            }
                        }
                    }
                });
                SwingPanel.this.jfxPanel.setScene(new Scene((Parent)view));
            }
        });
    }

    private void addListenersToAnchors(Document doc, EventListener listener) {
        HTMLElement element;
        int i;
        NodeList nodeList = doc.getElementsByTagName("a");
        for (i = 0; i < nodeList.getLength(); ++i) {
            ((EventTarget)((Object)nodeList.item(i))).addEventListener(EVENT_TYPE_CLICK, listener, false);
        }
        nodeList = doc.getElementsByTagName("frame");
        for (i = 0; i < nodeList.getLength(); ++i) {
            element = (HTMLFrameElement)nodeList.item(i);
            this.addListenersToAnchors(element.getContentDocument(), listener);
        }
        nodeList = doc.getElementsByTagName("iframe");
        for (i = 0; i < nodeList.getLength(); ++i) {
            element = (HTMLIFrameElement)nodeList.item(i);
            this.addListenersToAnchors(element.getContentDocument(), listener);
        }
    }

    public void loadText(final String text) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SwingPanel.this.url = null;
                SwingPanel.this.engine.loadContent(text);
                if (SwingPanel.this.jsBridge != null) {
                    SwingPanel.this.jsBridge.clearListeners();
                }
            }
        });
    }

    public void loadURL(final String urlToLoad) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (urlToLoad == null) {
                    SwingPanel.this.engine.load(null);
                    if (SwingPanel.this.jsBridge != null) {
                        SwingPanel.this.jsBridge.clearListeners();
                    }
                    return;
                }
                String tmp = SwingPanel.toURL(urlToLoad);
                if (tmp == null) {
                    tmp = SwingPanel.toURL("http://" + urlToLoad);
                }
                SwingPanel.this.url = tmp;
                SwingPanel.this.engine.load(tmp);
                if (SwingPanel.this.jsBridge != null) {
                    SwingPanel.this.jsBridge.clearListeners();
                }
                SwingPanel.this.enableControls();
            }
        });
    }

    private void enableControls() {
        if (this.btnBack == null || this.btnForward == null) {
            return;
        }
        int index = this.engine.getHistory().getCurrentIndex();
        if (index > 0) {
            this.btnBack.setEnabled(true);
        } else {
            this.btnBack.setEnabled(false);
        }
        if (index < this.engine.getHistory().getEntries().size() - 1) {
            this.btnForward.setEnabled(true);
        } else {
            this.btnForward.setEnabled(false);
        }
    }

    private static String toURL(String str) {
        try {
            return new URL(str).toExternalForm();
        }
        catch (MalformedURLException exception) {
            return null;
        }
    }

    private void closeAction() {
        this.manager.closeBrowser(this.id);
    }

    private void copyLinkAction() {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putString(this.anchor.toString());
        clipboard.setContent((Map)content);
    }

    private void openLinkAction() {
        String url = this.anchor.toString();
        this.openNativeBrowser(url);
    }

    private void openNativeBrowser(final String url) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OpenBrowser nativeBrowser = (OpenBrowser)SwingPanel.this.registrar.getService(OpenBrowser.class);
                nativeBrowser.openURL(url, false);
            }
        });
    }

    private void downloadAction() {
        String targ = this.anchor.toString();
        this.downloadAction(targ, null, true);
    }

    private void downloadAction(String targ, String fileName, boolean prompt) {
        Downloader.download(this.registrar, this.parent, targ, fileName, prompt);
    }

    private void openNewAction(boolean openTab) {
        CyBrowser browser;
        CyBrowser current = this.manager.getBrowser(this.id);
        Object title = current.getTitle(this.id);
        if (title != null) {
            title = (String)title + " " + CyBrowserManager.browserCount;
        }
        String newId = this.id + " " + CyBrowserManager.browserCount;
        ++CyBrowserManager.browserCount;
        if (this.parent != null) {
            if (!openTab) {
                SwingBrowser sb = new SwingBrowser(this.manager, newId, (String)title, this.showDebug);
                sb.setVisible(true);
                browser = sb;
            } else {
                browser = this.parent;
                this.parent.addTab(newId, (String)title, this.showDebug);
            }
        } else {
            browser = new ResultsPanelBrowser(this.manager, newId, (String)title);
            this.manager.registerCytoPanel((ResultsPanelBrowser)browser);
        }
        this.manager.addBrowser(browser, newId);
        browser.loadURL(this.anchor.toString());
    }

    private void copyAction() {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putString(this.selection);
        clipboard.setContent((Map)content);
    }

    private void reloadAction() {
        this.engine.reload();
    }

    private void createContextMenu(WebView webView) {
        MenuItem openNew;
        MenuItem openNew2;
        ContextMenu contextMenu = new ContextMenu();
        MenuItem reload = new MenuItem("Reload");
        reload.setOnAction(e -> this.reloadAction());
        MenuItem close = new MenuItem("Close browser");
        close.setOnAction(e -> this.closeAction());
        contextMenu.getItems().addAll((Object[])new MenuItem[]{reload, close});
        ContextMenu hrefContextMenu = new ContextMenu();
        MenuItem openLink = new MenuItem("Open link in native browser");
        openLink.setOnAction(e -> this.openLinkAction());
        hrefContextMenu.getItems().add((Object)openLink);
        MenuItem copyLink = new MenuItem("Copy link location");
        copyLink.setOnAction(e -> this.copyLinkAction());
        hrefContextMenu.getItems().add((Object)copyLink);
        if (this.parent != null) {
            openNew2 = new MenuItem("Open in new window");
            openNew2.setOnAction(e -> this.openNewAction(false));
            MenuItem openNewTab = new MenuItem("Open in new tab");
            openNewTab.setOnAction(e -> this.openNewAction(true));
            hrefContextMenu.getItems().addAll((Object[])new MenuItem[]{openNew2, openNewTab});
        } else {
            openNew2 = new MenuItem("Open in new tab");
            openNew2.setOnAction(e -> this.openNewAction(true));
            hrefContextMenu.getItems().add((Object)openNew2);
        }
        MenuItem download = new MenuItem("Download to file");
        download.setOnAction(e -> this.downloadAction());
        hrefContextMenu.getItems().add((Object)download);
        ContextMenu selectionContextMenu = new ContextMenu();
        MenuItem copy = new MenuItem("Copy");
        copy.setOnAction(e -> this.copyAction());
        selectionContextMenu.getItems().addAll((Object[])new MenuItem[]{copy});
        ContextMenu selectedAnchorContextMenu = new ContextMenu();
        MenuItem openLink2 = new MenuItem("Open link in native browser");
        openLink2.setOnAction(e -> this.openLinkAction());
        hrefContextMenu.getItems().add((Object)openLink2);
        MenuItem copyLink2 = new MenuItem("Copy link location");
        copyLink2.setOnAction(e -> this.copyLinkAction());
        selectedAnchorContextMenu.getItems().add((Object)copyLink2);
        if (this.parent != null) {
            openNew = new MenuItem("Open in new window");
            openNew.setOnAction(e -> this.openNewAction(false));
            MenuItem openNewTab = new MenuItem("Open in new tab");
            openNewTab.setOnAction(e -> this.openNewAction(true));
            selectedAnchorContextMenu.getItems().addAll((Object[])new MenuItem[]{openNew, openNewTab});
        } else {
            openNew = new MenuItem("Open in new tab");
            openNew.setOnAction(e -> this.openNewAction(true));
            selectedAnchorContextMenu.getItems().add((Object)openNew);
        }
        MenuItem copy2 = new MenuItem("Copy text");
        copy2.setOnAction(e -> this.copyAction());
        selectedAnchorContextMenu.getItems().add((Object)copy2);
        webView.setOnMousePressed(e -> {
            double x = e.getX();
            double y = e.getY();
            if (e.getButton() == MouseButton.SECONDARY || e.isControlDown() && e.getButton() == MouseButton.PRIMARY) {
                Element el;
                Object anchorElement = this.engine.executeScript("function getAnchor() {\n  var elements = document.querySelectorAll(':hover');\n  lastElement = elements.item(elements.length-1);\n  if ((lastElement != null) &&      ((lastElement.tagName == 'FRAME') || (lastElement.tagName == 'IFRAME'))) {\n     elements = lastElement.contentDocument.querySelectorAll(':hover');\n     lastElement = elements.item(elements.length-1);\n  }\n  return lastElement;\n}; getAnchor();");
                this.anchor = null;
                if (anchorElement instanceof Element && (el = this.findAnchor((Element)anchorElement)) != null && el.getTagName().equalsIgnoreCase("A")) {
                    this.anchor = el;
                }
                this.selection = (String)this.engine.executeScript("window.getSelection().toString()");
                if (this.anchor != null && this.selection != null && this.selection.length() > 0) {
                    selectedAnchorContextMenu.show((Node)webView, e.getScreenX(), e.getScreenY());
                } else if (this.anchor != null) {
                    hrefContextMenu.show((Node)webView, e.getScreenX(), e.getScreenY());
                    this.suppressLink = true;
                } else if (this.selection != null && this.selection.length() > 0) {
                    selectionContextMenu.show((Node)webView, e.getScreenX(), e.getScreenY());
                } else {
                    contextMenu.show((Node)webView, e.getScreenX(), e.getScreenY());
                }
            } else {
                this.suppressLink = false;
                hrefContextMenu.hide();
                selectionContextMenu.hide();
                selectedAnchorContextMenu.hide();
                contextMenu.hide();
            }
        });
    }

    private Element findAnchor(Element e) {
        while (e != null && !e.getTagName().equalsIgnoreCase("A")) {
            org.w3c.dom.Node n;
            for (n = e.getParentNode(); n != null && !Element.class.isInstance(n); n = n.getParentNode()) {
            }
            e = (Element)n;
        }
        return e;
    }
}

