/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.cyBrowser.internal.tasks;

import edu.ucsf.rbvi.cyBrowser.internal.model.CyBrowser;
import edu.ucsf.rbvi.cyBrowser.internal.model.CyBrowserManager;
import edu.ucsf.rbvi.cyBrowser.internal.tasks.AbstractEmptyObservableTask;
import edu.ucsf.rbvi.cyBrowser.internal.view.ResultsPanelBrowser;
import edu.ucsf.rbvi.cyBrowser.internal.view.SwingBrowser;
import edu.ucsf.rbvi.cyBrowser.internal.view.SwingPanel;
import javax.swing.SwingUtilities;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class ShowBrowserTask
extends AbstractEmptyObservableTask {
    @Tunable(description="URL", longDescription="The URL the browser should load", exampleStringValue="http://www.cytoscape.org", gravity=1.0)
    public String url;
    @Tunable(description="HTML Text", longDescription="HTML text to initially load into the browser", exampleStringValue="<HTML><HEAD><TITLE>Hello</TITLE></HEAD><BODY>Hello, world!</BODY></HTML>", context="nogui")
    public String text;
    @Tunable(description="Window Title", longDescription="Text to be shown in the title bar of the browser window", exampleStringValue="Cytoscape Home Page", context="nogui")
    public String title = null;
    @Tunable(description="Window ID", longDescription="The ID for this browser window.  Use this with ``cybrowser hide`` to hide the browser", exampleStringValue="Window 1", context="nogui")
    public String id = null;
    final CyBrowserManager manager;
    final CytoPanel cytoPanel = null;

    public ShowBrowserTask(CyBrowserManager manager) {
        this.manager = manager;
    }

    @Override
    public void run(TaskMonitor monitor) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResultsPanelBrowser browser;
                CyBrowser br = ShowBrowserTask.this.manager.getBrowser(ShowBrowserTask.this.id);
                if (ShowBrowserTask.this.id == null) {
                    ShowBrowserTask.this.id = ShowBrowserTask.this.title != null ? ShowBrowserTask.this.title : ShowBrowserTask.this.manager.makeId();
                }
                if (br != null && br instanceof ResultsPanelBrowser) {
                    browser = (ResultsPanelBrowser)br;
                } else if (br != null && br instanceof SwingBrowser) {
                    SwingPanel panel = br.getPanel(ShowBrowserTask.this.id);
                    ((SwingBrowser)br).setVisible(false);
                    browser = new ResultsPanelBrowser(ShowBrowserTask.this.manager, ShowBrowserTask.this.id, panel, ShowBrowserTask.this.title);
                } else {
                    browser = new ResultsPanelBrowser(ShowBrowserTask.this.manager, ShowBrowserTask.this.id, ShowBrowserTask.this.title);
                }
                if (ShowBrowserTask.this.url != null && ShowBrowserTask.this.url.length() > 3) {
                    browser.loadURL(ShowBrowserTask.this.url);
                } else if (ShowBrowserTask.this.text != null) {
                    browser.loadText(ShowBrowserTask.this.text);
                }
                ShowBrowserTask.this.manager.registerCytoPanel(browser);
                br = browser;
                ShowBrowserTask.this.manager.addBrowser(br, ShowBrowserTask.this.id);
            }
        });
    }

    @ProvidesTitle
    public String getTitle() {
        return "Showing Results Panel Browser";
    }

    @Override
    public <R> R getResults(Class<? extends R> type) {
        return this.getIDResults(type, this.id);
    }
}

