/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.cyBrowser.internal.tasks;

import edu.ucsf.rbvi.cyBrowser.internal.model.CyBrowser;
import edu.ucsf.rbvi.cyBrowser.internal.model.CyBrowserManager;
import edu.ucsf.rbvi.cyBrowser.internal.tasks.AbstractEmptyObservableTask;
import edu.ucsf.rbvi.cyBrowser.internal.view.ResultsPanelBrowser;
import edu.ucsf.rbvi.cyBrowser.internal.view.SwingBrowser;
import edu.ucsf.rbvi.cyBrowser.internal.view.SwingPanel;
import javax.swing.SwingUtilities;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class DialogTask
extends AbstractEmptyObservableTask {
    @Tunable(description="URL", longDescription="The URL the browser should load", exampleStringValue="http://www.cytoscape.org", gravity=1.0)
    public String url;
    @Tunable(description="Open in results panel?", longDescription="If true, open the browser in the results panel", exampleStringValue="true", gravity=2.0, context="gui")
    public boolean resultsPanel = false;
    @Tunable(description="HTML Text", longDescription="HTML text to initially load into the browser", exampleStringValue="<HTML><HEAD><TITLE>Hello</TITLE></HEAD><BODY>Hello, world!</BODY></HTML>", context="nogui")
    public String text;
    @Tunable(description="Window Title", longDescription="Text to be shown in the title bar of the browser window", exampleStringValue="Cytoscape Home Page", context="nogui")
    public String title = null;
    @Tunable(description="Window ID", longDescription="The ID for this browser window.  Use this with ``cybrowser hide`` to hide the browser", exampleStringValue="Window 1", context="nogui")
    public String id = null;
    @Tunable(description="Open in new tab", longDescription="If the browser with the specified ID already exists, just add a new tab", exampleStringValue="false", context="nogui")
    public boolean newTab = false;
    @Tunable(description="Tab ID", longDescription="If ```newTab``` is ``true``, then use the tab with the specified ID", exampleStringValue="Tab 1", context="nogui")
    public String tabID = null;
    public boolean debug = false;
    final CyBrowserManager manager;
    final CytoPanel cytoPanel = null;

    public DialogTask(CyBrowserManager manager) {
        this.manager = manager;
    }

    @Override
    public void run(TaskMonitor monitor) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CyBrowser br = DialogTask.this.manager.getBrowser(DialogTask.this.id);
                SwingBrowser browser = null;
                if (DialogTask.this.id == null) {
                    DialogTask.this.id = DialogTask.this.title != null ? DialogTask.this.title : DialogTask.this.manager.makeId();
                }
                if (br != null && br instanceof SwingBrowser) {
                    browser = (SwingBrowser)br;
                } else if (br != null && br instanceof ResultsPanelBrowser) {
                    SwingPanel panel = br.getPanel(DialogTask.this.id);
                    DialogTask.this.manager.unregisterCytoPanel((ResultsPanelBrowser)br);
                    browser = new SwingBrowser(DialogTask.this.manager, DialogTask.this.id, panel, DialogTask.this.title, DialogTask.this.debug);
                } else if (br == null && DialogTask.this.resultsPanel) {
                    ResultsPanelBrowser rpbr = new ResultsPanelBrowser(DialogTask.this.manager, DialogTask.this.id, DialogTask.this.title);
                    DialogTask.this.manager.registerCytoPanel(rpbr);
                    br = rpbr;
                } else {
                    browser = new SwingBrowser(DialogTask.this.manager, DialogTask.this.id, DialogTask.this.title, DialogTask.this.debug);
                }
                if (browser != null) {
                    browser.setVisible(true);
                    br = browser;
                }
                if (DialogTask.this.url != null && DialogTask.this.url.length() > 3) {
                    br.loadURL(DialogTask.this.url, DialogTask.this.newTab, DialogTask.this.tabID);
                } else if (DialogTask.this.text != null && DialogTask.this.text.length() > 0) {
                    br.loadText(DialogTask.this.text, DialogTask.this.newTab, DialogTask.this.tabID);
                }
                DialogTask.this.manager.addBrowser(br, DialogTask.this.id);
            }
        });
    }

    @ProvidesTitle
    public String getTitle() {
        return "Starting Cytoscape Web Browser";
    }

    @Override
    public <R> R getResults(Class<? extends R> type) {
        return this.getIDResults(type, this.id);
    }
}

