/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.cyBrowser.internal.model;

import edu.ucsf.rbvi.cyBrowser.internal.model.CurrentNetworkListenerJS;
import edu.ucsf.rbvi.cyBrowser.internal.model.CurrentNetworkViewListenerJS;
import edu.ucsf.rbvi.cyBrowser.internal.model.JSListener;
import edu.ucsf.rbvi.cyBrowser.internal.model.NetworkAddedListenerJS;
import edu.ucsf.rbvi.cyBrowser.internal.model.NetworkObjectListenerJS;
import edu.ucsf.rbvi.cyBrowser.internal.model.SessionLoadedListenerJS;
import java.util.Properties;
import javafx.scene.web.WebEngine;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.events.AboutToRemoveEdgesListener;
import org.cytoscape.model.events.AboutToRemoveNodesListener;
import org.cytoscape.model.events.NetworkAddedListener;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionLoadedListener;

public class JSListenerFactory {
    public static JSListener createListener(CyServiceRegistrar registrar, WebEngine engine, String type, String callback) {
        JSListener.ListenerType listenerType = JSListener.ListenerType.getType(type);
        if (listenerType == null) {
            return null;
        }
        switch (listenerType) {
            case NETWORKLOADED: {
                NetworkAddedListenerJS listener = new NetworkAddedListenerJS(engine, callback);
                registrar.registerService((Object)listener, NetworkAddedListener.class, new Properties());
                return listener;
            }
            case SESSIONLOADED: {
                SessionLoadedListenerJS listener = new SessionLoadedListenerJS(engine, callback);
                registrar.registerService((Object)listener, SessionLoadedListener.class, new Properties());
                return listener;
            }
            case NODESELECTION: 
            case EDGESELECTION: {
                return JSListenerFactory.createListener(registrar, engine, type, null, callback);
            }
            case CURRENTNETWORK: {
                CurrentNetworkListenerJS listener = new CurrentNetworkListenerJS(engine, callback);
                registrar.registerService((Object)listener, SetCurrentNetworkListener.class, new Properties());
                return listener;
            }
            case CURRENTVIEW: {
                CurrentNetworkViewListenerJS listener = new CurrentNetworkViewListenerJS(engine, callback);
                registrar.registerService((Object)listener, SetCurrentNetworkViewListener.class, new Properties());
                return listener;
            }
        }
        return null;
    }

    public static JSListener createListener(CyServiceRegistrar registrar, WebEngine engine, String type, CyNetwork network, String callback) {
        NetworkObjectListenerJS listener;
        Class<RowsSetListener> listenerClass;
        JSListener.ListenerType listenerType = JSListener.ListenerType.getType(type);
        if (listenerType == null) {
            return null;
        }
        switch (listenerType) {
            case NODESELECTION: {
                listenerClass = RowsSetListener.class;
                listener = new NetworkObjectListenerJS(engine, network, callback, CyNode.class);
                break;
            }
            case EDGESELECTION: {
                listenerClass = RowsSetListener.class;
                listener = new NetworkObjectListenerJS(engine, network, callback, CyEdge.class);
                break;
            }
            case EDGEDELETION: {
                listenerClass = AboutToRemoveEdgesListener.class;
                listener = new NetworkObjectListenerJS(engine, network, callback, CyEdge.class);
                break;
            }
            case NODEDELETION: {
                listenerClass = AboutToRemoveNodesListener.class;
                listener = new NetworkObjectListenerJS(engine, network, callback, CyNode.class);
                break;
            }
            default: {
                return null;
            }
        }
        registrar.registerService((Object)listener, listenerClass, new Properties());
        return listener;
    }
}

