/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.cyBrowser.internal.model;

import javafx.application.Platform;
import javafx.scene.web.WebEngine;
import netscape.javascript.JSObject;

public abstract class JSListener {
    protected WebEngine engine;
    protected String callback;

    JSListener(WebEngine engine, String callback) {
        this.engine = engine;
        this.callback = callback;
    }

    protected void doCallback(final String callback, final String json) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JSObject windowObject = (JSObject)JSListener.this.engine.executeScript("window");
                if (json != null) {
                    windowObject.call(callback, json);
                } else {
                    windowObject.call(callback, new Object[0]);
                }
            }
        });
    }

    public static enum ListenerType {
        NODESELECTION("Node Selection", "nodeSelection"),
        EDGESELECTION("Edge Selection", "edgeSelection"),
        NODEDELETION("Node About to be Deleted", "nodeDeletion"),
        EDGEDELETION("Edge About to be Deleted", "edgeDeletion"),
        NETWORKLOADED("Network Loaded", "networkLoaded"),
        CURRENTNETWORK("Set Current Network", "setCurrentNetwork"),
        CURRENTVIEW("Set Current Network View", "setCurrentNetworkView"),
        SESSIONLOADED("Session Loaded", "sessionLoaded");

        String name;
        String shortName;

        private ListenerType(String name, String shortName) {
            this.name = name;
            this.shortName = shortName;
        }

        public String toString() {
            return this.shortName;
        }

        public String getName() {
            return this.name;
        }

        public static ListenerType getType(String shortName) {
            for (ListenerType lt : ListenerType.values()) {
                if (!lt.shortName.equals(shortName)) continue;
                return lt;
            }
            return null;
        }
    }
}

