/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.valueeditor;

import java.awt.Component;
import java.awt.Font;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.editor.valueeditor.DiscreteValueEditor;
import org.cytoscape.view.vizmap.gui.internal.view.util.ViewUtil;

public class FontValueEditor
extends DiscreteValueEditor<Font> {
    public FontValueEditor(ServicesUtil servicesUtil) {
        super(Font.class, ViewUtil.getAvailableFonts(), servicesUtil);
    }

    @Override
    public <S extends Font> Font showEditor(Component parent, S initialValue, VisualProperty<S> vp) {
        Font newValue;
        if (initialValue != null) {
            initialValue = new SimpleEqualsFont((Font)initialValue);
        }
        return (newValue = (Font)super.showEditor(parent, initialValue, vp)) instanceof SimpleEqualsFont ? ((SimpleEqualsFont)newValue).font : newValue;
    }

    private static class SimpleEqualsFont
    extends Font {
        private Font font;

        SimpleEqualsFont(Font font) {
            super(font);
            if (font == null) {
                throw new IllegalArgumentException("'font' must not be null.");
            }
            this.font = font;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 3;
            result = 31 * result + this.name.hashCode();
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Font)) {
                return false;
            }
            return this.name.equals(((Font)obj).getName());
        }
    }
}

