/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.cytoscape.event.DebounceTimer;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.NetworkImageFactory;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.model.VizMapperProxy;
import org.cytoscape.view.vizmap.gui.internal.task.RemoveVisualStylesTask;
import org.cytoscape.view.vizmap.gui.internal.task.RenameVisualStyleTask;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.util.SimpleToolBarToggleButton;
import org.cytoscape.view.vizmap.gui.internal.view.util.ViewUtil;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.TunableSetter;
import org.cytoscape.work.swing.DialogTaskManager;

public class VisualStyleSelector
extends JPanel {
    private static final int IMAGE_WIDTH = 120;
    private static final int IMAGE_HEIGHT = 68;
    private static final int ITEM_BORDER_WIDTH = 1;
    private static final int ITEM_MARGIN = 2;
    private static final int ITEM_PAD = 2;
    final Color BG_COLOR;
    final Color FG_COLOR;
    final Color SEL_BG_COLOR;
    final Color SEL_FG_COLOR;
    final Color FOCUS_BORDER_COLOR;
    final Color FOCUS_OVERLAY_COLOR;
    final Color BORDER_COLOR;
    private JTextField searchTxtFld;
    private StyleGrid styleGrid;
    private JScrollPane gridScrollPane;
    private JToggleButton editBtn;
    private JPanel toolBarPanel;
    private JButton selectAllBtn;
    private JButton selectNoneBtn;
    private JToggleButton filterAppliedBtn;
    private JButton removeStylesBtn;
    private int cols;
    private LinkedList<VisualStyle> allStyles;
    private LinkedList<VisualStyle> filteredStyles;
    private String titleFilter = "";
    private boolean appliedFilter;
    private final int minColumns;
    private final int maxColumns;
    private boolean editMode;
    private boolean editingTitle;
    private boolean selectionIsAdjusting;
    private int selectionHead;
    private int selectionTail;
    private final Map<String, RenderingEngine<CyNetwork>> engineMap;
    private VisualStyle selectedStyle;
    private final CyNetworkView previewNetView;
    private final Map<String, JPanel> defViewPanelsMap;
    private final ServicesUtil servicesUtil;

    public VisualStyleSelector(int minColumns, int maxColumns, ServicesUtil servicesUtil) {
        this(minColumns, maxColumns, false, servicesUtil);
    }

    public VisualStyleSelector(int minColumns, int maxColumns, boolean editMode, ServicesUtil servicesUtil) {
        super(true);
        this.minColumns = Math.max(1, minColumns);
        this.maxColumns = Math.max(0, maxColumns);
        this.editMode = editMode;
        this.servicesUtil = servicesUtil;
        this.allStyles = new LinkedList();
        this.engineMap = new HashMap<String, RenderingEngine<CyNetwork>>();
        this.defViewPanelsMap = new HashMap<String, JPanel>();
        this.BG_COLOR = UIManager.getColor("Table.background");
        this.FG_COLOR = UIManager.getColor("Table.foreground");
        this.SEL_BG_COLOR = UIManager.getColor("Table.focusCellBackground");
        this.SEL_FG_COLOR = UIManager.getColor("Table.focusCellForeground");
        this.FOCUS_BORDER_COLOR = UIManager.getColor("Table.selectionBackground");
        this.FOCUS_OVERLAY_COLOR = new Color(this.FOCUS_BORDER_COLOR.getRed(), this.FOCUS_BORDER_COLOR.getGreen(), this.FOCUS_BORDER_COLOR.getBlue(), 100);
        this.BORDER_COLOR = UIManager.getColor("Separator.foreground");
        this.previewNetView = this.createPreviewNetworkView();
        this.init();
        this.update();
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        if (editMode != this.editMode) {
            this.selectionIsAdjusting = true;
            this.editMode = editMode;
            try {
                this.update();
                if (!editMode) {
                    this.getStyleGrid().setSelectedValue(this.selectedStyle, this.getStyleGrid().isShowing());
                }
            }
            finally {
                this.selectionIsAdjusting = false;
            }
            this.firePropertyChange("editMode", !editMode, editMode);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getSearchTxtFld().setEnabled(enabled);
        this.getEditBtn().setEnabled(enabled);
        this.getSelectAllBtn().setEnabled(enabled);
        this.getSelectNoneBtn().setEnabled(enabled);
        this.getRemoveStylesBtn().setEnabled(enabled);
        this.getStyleGrid().setEnabled(enabled);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.getSearchTxtFld().requestFocusInWindow();
    }

    public void update(SortedSet<VisualStyle> styles, VisualStyle currentStyle) {
        this.allStyles.clear();
        if (styles != null) {
            this.allStyles.addAll(styles);
        }
        this.createPreviewRenderingEngines();
        this.getStyleGrid().update(this.allStyles);
        this.getStyleGrid().setSelectedValue(currentStyle, this.getStyleGrid().isShowing());
        this.update(true);
    }

    public void setSelectedStyle(VisualStyle style) {
        if (!Objects.equals(this.selectedStyle, style)) {
            VisualStyle oldValue = this.selectedStyle;
            this.selectedStyle = style;
            this.getStyleGrid().setSelectedValue(style, this.getStyleGrid().isShowing());
            if (!this.selectionIsAdjusting) {
                this.firePropertyChange("selectedStyle", oldValue, this.selectedStyle);
            }
        }
    }

    public VisualStyle getSelectedStyle() {
        return this.selectedStyle;
    }

    public List<VisualStyle> getSelectedStyleList() {
        return this.getStyleGrid().getSelectedValuesList();
    }

    public int getSelectionCount() {
        return this.getStyleGrid().getSelectionModel().getSelectedItemsCount();
    }

    public boolean isSelected(VisualStyle style) {
        int index = this.getStyleGrid().indexOf(style);
        return this.getStyleGrid().getSelectionModel().isSelectedIndex(index);
    }

    public JPanel getDefaultView(VisualStyle vs) {
        return this.defViewPanelsMap.get(vs.getTitle());
    }

    protected RenderingEngine<CyNetwork> getRenderingEngine(VisualStyle vs) {
        return vs != null ? this.engineMap.get(vs.getTitle()) : null;
    }

    public boolean isEmpty() {
        return this.allStyles == null || this.allStyles.isEmpty();
    }

    public void resetFilter() {
        this.getSearchTxtFld().setText("");
        if (this.getFilterAppliedBtn().isSelected()) {
            this.getFilterAppliedBtn().doClick();
        }
    }

    public void dispose() {
        try {
            this.allStyles.clear();
            this.filteredStyles = null;
            this.engineMap.clear();
            this.defViewPanelsMap.clear();
            this.previewNetView.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        int btnSize = this.getEditBtn().getPreferredSize().height;
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addComponent(this.getSearchTxtFld(), -1, -1, Short.MAX_VALUE).addComponent(this.getFilterAppliedBtn(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getToolBarPanel(), -2, -1, -2).addComponent(this.getEditBtn(), btnSize, btnSize, btnSize)).addComponent(this.getGridScrollPane(), -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.getSearchTxtFld(), -2, -1, -2).addComponent(this.getFilterAppliedBtn(), -2, -1, -2).addComponent(this.getToolBarPanel(), -2, -1, -2).addComponent(this.getEditBtn(), btnSize, btnSize, btnSize)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getGridScrollPane(), -1, -1, Short.MAX_VALUE));
    }

    JTextField getSearchTxtFld() {
        if (this.searchTxtFld == null) {
            this.searchTxtFld = new JTextField();
            this.searchTxtFld.putClientProperty("JTextField.variant", "search");
            this.searchTxtFld.setToolTipText("Search by style name...");
            final DebounceTimer debouncer = new DebounceTimer(250);
            this.searchTxtFld.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent evt) {
                    this.updateTitleFilter();
                }

                @Override
                public void removeUpdate(DocumentEvent evt) {
                    this.updateTitleFilter();
                }

                @Override
                public void changedUpdate(DocumentEvent evt) {
                }

                private void updateTitleFilter() {
                    debouncer.debounce(() -> VisualStyleSelector.this.setTitleFilter(VisualStyleSelector.this.searchTxtFld.getText()));
                }
            });
        }
        return this.searchTxtFld;
    }

    JToggleButton getEditBtn() {
        if (this.editBtn == null) {
            this.editBtn = this.createToolBarToggleButton("\uf044", "Edit...", 16.0f);
            this.editBtn.addActionListener(evt -> this.setEditMode(this.editBtn.isSelected()));
        }
        return this.editBtn;
    }

    JPanel getToolBarPanel() {
        if (this.toolBarPanel == null) {
            this.toolBarPanel = new JPanel();
            GroupLayout layout = new GroupLayout(this.toolBarPanel);
            this.toolBarPanel.setLayout(layout);
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            layout.setAutoCreateContainerGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.getSelectAllBtn()).addComponent(this.getSelectNoneBtn()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getRemoveStylesBtn()).addContainerGap());
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.getSelectAllBtn(), -2, -1, -2).addComponent(this.getSelectNoneBtn(), -2, -1, -2).addComponent(this.getRemoveStylesBtn(), -2, -1, -2));
        }
        return this.toolBarPanel;
    }

    JButton getSelectAllBtn() {
        if (this.selectAllBtn == null) {
            this.selectAllBtn = this.createToolBarButton("\uf046\uf046", "Select All", 14.0f);
            this.selectAllBtn.addActionListener(evt -> this.getStyleGrid().selectAll());
        }
        return this.selectAllBtn;
    }

    JButton getSelectNoneBtn() {
        if (this.selectNoneBtn == null) {
            this.selectNoneBtn = this.createToolBarButton("\uf096\uf096", "Select None", 14.0f);
            this.selectNoneBtn.addActionListener(evt -> this.getStyleGrid().deselectAll());
        }
        return this.selectNoneBtn;
    }

    JToggleButton getFilterAppliedBtn() {
        if (this.filterAppliedBtn == null) {
            this.filterAppliedBtn = this.createToolBarToggleButton("\uf1e1", "Show only Applied Styles", 16.0f);
            this.filterAppliedBtn.addActionListener(evt -> this.setAppliedFilter(this.filterAppliedBtn.isSelected()));
        }
        return this.filterAppliedBtn;
    }

    JButton getRemoveStylesBtn() {
        if (this.removeStylesBtn == null) {
            this.removeStylesBtn = this.createToolBarButton("\uf014", "Remove Selected Styles", 18.0f);
            this.removeStylesBtn.addActionListener(evt -> {
                LinkedHashSet<VisualStyle> styles = new LinkedHashSet<VisualStyle>(this.getStyleGrid().getSelectedValuesList());
                RemoveVisualStylesTask task = new RemoveVisualStylesTask(styles, this.servicesUtil);
                new Thread(() -> this.servicesUtil.get(DialogTaskManager.class).execute(new TaskIterator(new Task[]{task}), new TaskObserver(){

                    public void taskFinished(ObservableTask task) {
                    }

                    public void allFinished(FinishStatus finishStatus) {
                        VizMapperProxy vmProxy = VisualStyleSelector.this.getProxy();
                        VisualStyleSelector.this.update(vmProxy.getVisualStyles(), vmProxy.getCurrentVisualStyle());
                    }
                })).start();
            });
        }
        return this.removeStylesBtn;
    }

    StyleGrid getStyleGrid() {
        if (this.styleGrid == null) {
            this.styleGrid = new StyleGrid(this.allStyles);
            this.styleGrid.getSelectionModel().addListSelectionListener(evt -> {
                if (evt.getValueIsAdjusting()) {
                    return;
                }
                this.updateToolBarButtons();
                this.repaint();
                if (!this.isEditMode() && !this.selectionIsAdjusting) {
                    this.setSelectedStyle(this.styleGrid.getSelectedValue());
                }
            });
        }
        return this.styleGrid;
    }

    JScrollPane getGridScrollPane() {
        if (this.gridScrollPane == null) {
            this.gridScrollPane = new JScrollPane(this.getStyleGrid());
            this.gridScrollPane.setVerticalScrollBarPolicy(20);
            this.gridScrollPane.setHorizontalScrollBarPolicy(31);
            this.gridScrollPane.setBackground(this.BG_COLOR);
            this.gridScrollPane.getViewport().setBackground(this.BG_COLOR);
            final DebounceTimer debouncer = new DebounceTimer();
            this.gridScrollPane.getViewport().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent evt) {
                    debouncer.debounce(() -> ViewUtil.invokeOnEDT(() -> VisualStyleSelector.this.getStyleGrid().update()));
                }
            });
            this.gridScrollPane.getViewport().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (VisualStyleSelector.this.isEditMode() && !evt.isShiftDown()) {
                        VisualStyleSelector.this.getStyleGrid().deselectAll();
                    }
                }
            });
        }
        return this.gridScrollPane;
    }

    private void setTitleFilter(String s) {
        if (s == null) {
            s = "";
        }
        String newValue = s.trim().toLowerCase();
        ViewUtil.invokeOnEDT(() -> {
            if (!newValue.equals(this.titleFilter)) {
                this.titleFilter = newValue;
                this.filterStyles();
            }
        });
    }

    public void setAppliedFilter(boolean b) {
        ViewUtil.invokeOnEDT(() -> {
            if (b != this.appliedFilter) {
                this.appliedFilter = b;
                this.filterStyles();
            }
        });
    }

    private void createPreviewRenderingEngines() {
        this.defViewPanelsMap.clear();
        this.engineMap.clear();
        if (this.allStyles != null && this.previewNetView != null) {
            VizMapperProxy vmProxy = (VizMapperProxy)this.servicesUtil.getProxy("VisualStyleProxy");
            RenderingEngineFactory<CyNetwork> engineFactory = vmProxy.getRenderingEngineFactory(this.previewNetView);
            for (VisualStyle vs : this.allStyles) {
                JPanel p = new JPanel();
                this.defViewPanelsMap.put(vs.getTitle(), p);
                RenderingEngine engine = engineFactory.createRenderingEngine((Object)p, (View)this.previewNetView);
                this.engineMap.put(vs.getTitle(), (RenderingEngine<CyNetwork>)engine);
            }
        }
    }

    private void filterStyles() {
        ArrayList<VisualStyle> selectedStyles;
        LinkedList<Object> linkedList = this.filteredStyles = this.titleFilter == null || this.titleFilter.isBlank() ? null : new LinkedList();
        if (this.filteredStyles == null) {
            LinkedList linkedList2 = this.filteredStyles = !this.appliedFilter ? null : new LinkedList();
        }
        if (this.filteredStyles != null) {
            for (VisualStyle vs : this.allStyles) {
                if (!vs.getTitle().toLowerCase().contains(this.titleFilter) || this.appliedFilter && this.getProxy().countNetworkViewsWithStyle(vs) <= 0) continue;
                this.filteredStyles.add(vs);
            }
        }
        ArrayList<VisualStyle> arrayList = selectedStyles = this.isEditMode() ? this.getSelectedStyleList() : new ArrayList<VisualStyle>();
        if (this.selectedStyle != null && !this.isEditMode()) {
            selectedStyles.add(this.selectedStyle);
        }
        this.selectionIsAdjusting = true;
        try {
            this.getStyleGrid().setModel(new StyleGridModel(this.filteredStyles != null ? this.filteredStyles : this.allStyles));
            this.getStyleGrid().setSelectedList(selectedStyles);
        }
        finally {
            this.selectionIsAdjusting = false;
        }
        this.firePropertyChange("filterChanged", false, true);
    }

    private boolean isFilteredOut(VisualStyle vs) {
        return false;
    }

    private int calculateColumns(int itemWidth, int gridWidth) {
        int cols = itemWidth > 0 ? Math.floorDiv(gridWidth, itemWidth) : 1;
        cols = Math.max(cols, 1);
        return Math.max(cols, this.maxColumns);
    }

    private int calculateRows(int total, int cols) {
        return (int)Math.round(Math.ceil((float)total / (float)cols));
    }

    private JButton createToolBarButton(String iconText, String tooltipText, float size) {
        JButton btn = new JButton(iconText);
        btn.setToolTipText(tooltipText);
        ViewUtil.styleToolBarButton(btn, this.servicesUtil.get(IconManager.class).getIconFont(size), 2, 0);
        return btn;
    }

    private JToggleButton createToolBarToggleButton(String iconText, String tooltipText, float size) {
        SimpleToolBarToggleButton btn = new SimpleToolBarToggleButton(iconText);
        btn.setToolTipText(tooltipText);
        ViewUtil.styleToolBarButton(btn, this.servicesUtil.get(IconManager.class).getIconFont(size), 2, 0);
        return btn;
    }

    public void setDirty(VisualStyle style) {
        this.getStyleGrid().setDirty(style);
    }

    void update() {
        this.update(false);
    }

    void update(boolean updateThumbnails) {
        this.setEnabled(!this.isEmpty());
        this.getEditBtn().setSelected(this.isEditMode());
        this.getToolBarPanel().setVisible(this.isEditMode());
        if (updateThumbnails) {
            this.getStyleGrid().updateStylePanels();
        }
        this.getStyleGrid().getSelectionModel().setSelectionMode(this.isEditMode() ? 2 : 0);
        this.updateToolBarButtons();
    }

    private void updateToolBarButtons() {
        if (this.isEnabled() && this.isEditMode()) {
            List<VisualStyle> selValues = this.getStyleGrid().getSelectedValuesList();
            int selCount = selValues.size();
            int total = this.getStyleGrid().getModel().getSize();
            VisualStyle defStyle = this.getProxy().getDefaultVisualStyle();
            this.getSelectAllBtn().setEnabled(selCount < total);
            this.getSelectNoneBtn().setEnabled(selCount > 0);
            this.getRemoveStylesBtn().setEnabled(selCount > 1 || selCount == 1 && !defStyle.equals(selValues.iterator().next()));
        }
    }

    private CyNetworkView createPreviewNetworkView() {
        CyNetwork net = this.servicesUtil.get(CyNetworkFactory.class).createNetworkWithPrivateTables(SavePolicy.DO_NOT_SAVE);
        CyNode source = net.addNode();
        CyNode target = net.addNode();
        net.getRow((CyIdentifiable)source).set("name", (Object)"Source");
        net.getRow((CyIdentifiable)target).set("name", (Object)"Target");
        CyEdge edge = net.addEdge(source, target, true);
        net.getRow((CyIdentifiable)edge).set("name", (Object)"Source (interaction) Target");
        net.getRow((CyIdentifiable)net).set("name", (Object)"Default Appearance");
        CyNetworkView view = this.servicesUtil.get(CyNetworkViewFactory.class).createNetworkView(net);
        view.getNodeView(source).setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)0.0);
        view.getNodeView(source).setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)0.0);
        view.getNodeView(target).setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)150.0);
        view.getNodeView(target).setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)20.0);
        return view;
    }

    private VizMapperProxy getProxy() {
        return (VizMapperProxy)this.servicesUtil.getProxy("VisualStyleProxy");
    }

    class StylePanel
    extends JComponent {
        private JLabel imageLabel;
        private JTextField titleTextField;
        private final VisualStyle style;
        private boolean dirty = true;

        StylePanel(VisualStyle style) {
            this.style = style;
            this.init();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    StylePanel.this.requestFocusInWindow();
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    StylePanel.this.repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    StylePanel.this.repaint();
                }
            });
        }

        VisualStyle getStyle() {
            return this.style;
        }

        private void init() {
            this.setBackground(VisualStyleSelector.this.BG_COLOR);
            this.setFocusable(true);
            int gap = 4;
            this.setBorder(BorderFactory.createEmptyBorder(gap, gap, gap, gap));
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setAutoCreateGaps(false);
            layout.setAutoCreateContainerGaps(false);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.getImageLabel(), -1, -1, Short.MAX_VALUE).addComponent(this.getTitleTextField(), -1, -1, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getImageLabel(), -1, -1, Short.MAX_VALUE).addComponent(this.getTitleTextField(), -2, -1, -2));
        }

        JLabel getImageLabel() {
            if (this.imageLabel == null) {
                this.imageLabel = new JLabel();
                this.imageLabel.setHorizontalAlignment(0);
                this.imageLabel.setOpaque(true);
                int bw = 1;
                this.imageLabel.setBorder(BorderFactory.createMatteBorder(0, 0, bw, 0, VisualStyleSelector.this.BORDER_COLOR));
                this.imageLabel.setMinimumSize(new Dimension(120, 68 + bw));
            }
            return this.imageLabel;
        }

        JTextField getTitleTextField() {
            if (this.titleTextField == null) {
                this.titleTextField = new JTextField(this.style.getTitle()){

                    @Override
                    public String getToolTipText(MouseEvent evt) {
                        boolean isDefault = VisualStyleSelector.this.getProxy().isDefaultStyle(StylePanel.this.getStyle());
                        return "<html><p style='text-align: center;'><b>" + StylePanel.this.style.getTitle() + "</b>" + (VisualStyleSelector.this.isEditMode() && !isDefault ? "<br>(double-click to rename...)" : "") + "</p></html>";
                    }
                };
                this.titleTextField.setHorizontalAlignment(0);
                this.titleTextField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                this.titleTextField.setBackground(VisualStyleSelector.this.BG_COLOR);
                this.titleTextField.setEditable(false);
                this.titleTextField.setFocusable(false);
                LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.titleTextField});
            }
            return this.titleTextField;
        }

        boolean isDirty() {
            return this.dirty;
        }

        void setDirty() {
            this.dirty = true;
        }

        void update() {
            Paint bgPaint = (Paint)this.style.getDefaultValue(BasicVisualLexicon.NETWORK_BACKGROUND_PAINT);
            Color bgColor = bgPaint instanceof Color ? (Color)bgPaint : VisualStyleSelector.this.BG_COLOR;
            this.getImageLabel().setBackground(bgColor);
            if (VisualStyleSelector.this.previewNetView != null) {
                this.style.apply(VisualStyleSelector.this.previewNetView);
                NetworkImageFactory netImgFactory = VisualStyleSelector.this.servicesUtil.get(NetworkImageFactory.class);
                Image img = netImgFactory.createImage(VisualStyleSelector.this.previewNetView, 120, 68);
                ImageIcon icon = new ImageIcon(img);
                this.getImageLabel().setIcon(icon);
            }
            this.getTitleTextField().setText(this.style.getTitle());
            this.getTitleTextField().setToolTipText(this.style.getTitle());
            this.dirty = false;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int w = this.getWidth();
            int h = this.getHeight();
            int arc = 10;
            boolean selected = VisualStyleSelector.this.isSelected(this.style);
            boolean focusOwner = this.isFocusOwner();
            if (selected) {
                g2d.setColor(VisualStyleSelector.this.SEL_BG_COLOR);
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawRoundRect(2, 2, w - 4, h - 4, arc, arc);
            } else {
                g2d.setColor(VisualStyleSelector.this.BORDER_COLOR);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.drawRoundRect(2, 2, w - 4, h - 4, arc, arc);
            }
            if (focusOwner) {
                g2d.setColor(VisualStyleSelector.this.FOCUS_OVERLAY_COLOR);
                g2d.fillRect(2, 2, w - 4, h - 4);
                g2d.setColor(VisualStyleSelector.this.FOCUS_BORDER_COLOR);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.drawRoundRect(2, 2, w - 4, h - 4, arc, arc);
            }
            g2d.dispose();
        }

        @Override
        public String toString() {
            return this.style.getTitle();
        }
    }

    class StyleGridModel
    extends AbstractListModel<VisualStyle> {
        private final List<VisualStyle> data = new ArrayList<VisualStyle>();

        public StyleGridModel(List<VisualStyle> data) {
            this.data.addAll(data);
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public VisualStyle getElementAt(int index) {
            return this.data.get(index);
        }
    }

    class StyleGrid
    extends JComponent
    implements Scrollable {
        private final LinkedHashMap<VisualStyle, StylePanel> vsPanelMap = new LinkedHashMap();
        private ListModel<VisualStyle> dataModel;
        private ListSelectionModel selectionModel;
        private ListSelectionListener selectionListener;

        StyleGrid(List<VisualStyle> data) {
            this.dataModel = new StyleGridModel(data);
            this.selectionModel = this.createSelectionModel();
            this.setOpaque(true);
            this.setBackground(VisualStyleSelector.this.BG_COLOR);
            this.setKeyBindings();
            this.update();
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getModel().getSize() == 0 ? this.getMinimumSize() : this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return (orientation == 1 ? visibleRect.height : visibleRect.width) - 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return VisualStyleSelector.this.cols > 0;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.getModel().getSize() == 0;
        }

        @Override
        public void repaint() {
            for (StylePanel item : this.vsPanelMap.values()) {
                item.repaint();
            }
            super.repaint();
        }

        StylePanel getItem(VisualStyle style) {
            return this.vsPanelMap.get(style);
        }

        int indexOf(VisualStyle style) {
            ListModel<VisualStyle> dm = this.getModel();
            int c = dm.getSize();
            for (int i = 0; i < c; ++i) {
                if (!style.equals(dm.getElementAt(i))) continue;
                return i;
            }
            return -1;
        }

        void setFocus(int index) {
            VisualStyle vs;
            StylePanel item;
            ListModel<VisualStyle> dm = this.getModel();
            if (index > -1 && index < dm.getSize() && (item = this.getItem(vs = dm.getElementAt(index))) != null) {
                item.requestFocusInWindow();
            }
        }

        VisualStyle getSelectedValue() {
            int i = this.getMinSelectionIndex();
            return i == -1 || i >= this.getModel().getSize() ? null : this.getModel().getElementAt(i);
        }

        void setSelectedValue(VisualStyle style, boolean shouldScroll) {
            if (style == null) {
                this.deselectAll();
            } else if (!style.equals(this.getSelectedValue())) {
                int i = this.indexOf(style);
                this.setSelectedIndex(i);
                if (i >= 0 && shouldScroll) {
                    this.ensureIndexIsVisible(i);
                }
            }
        }

        List<VisualStyle> getSelectedValuesList() {
            int size;
            ListModel<VisualStyle> dm = this.getModel();
            ListSelectionModel sm = this.getSelectionModel();
            int[] selectedIndices = sm.getSelectedIndices();
            ArrayList<VisualStyle> selectedItems = new ArrayList<VisualStyle>();
            if (selectedIndices.length > 0 && selectedIndices[0] < (size = dm.getSize())) {
                for (int i : selectedIndices) {
                    if (i >= size) break;
                    selectedItems.add(dm.getElementAt(i));
                }
            }
            return selectedItems;
        }

        void selectAll() {
            if (this.getModel().getSize() >= 0) {
                this.getSelectionModel().setSelectionInterval(0, this.getModel().getSize() - 1);
                VisualStyleSelector.this.selectionHead = -1;
                VisualStyleSelector.this.selectionTail = -1;
            }
        }

        void deselectAll() {
            this.getSelectionModel().clearSelection();
            VisualStyleSelector.this.selectionHead = -1;
            VisualStyleSelector.this.selectionTail = -1;
        }

        void setSelectedIndex(int index) {
            if (index >= this.getModel().getSize()) {
                return;
            }
            this.getSelectionModel().setSelectionInterval(index, index);
        }

        int getMinSelectionIndex() {
            return this.getSelectionModel().getMinSelectionIndex();
        }

        int getMaxSelectionIndex() {
            return this.getSelectionModel().getMaxSelectionIndex();
        }

        boolean isSelectedIndex(int index) {
            return this.getSelectionModel().isSelectedIndex(index);
        }

        boolean isSelectionEmpty() {
            return this.getSelectionModel().isSelectionEmpty();
        }

        ListSelectionModel getSelectionModel() {
            return this.selectionModel;
        }

        void setSelectionInterval(int anchor, int lead) {
            this.getSelectionModel().setSelectionInterval(anchor, lead);
        }

        void addSelectionInterval(int anchor, int lead) {
            this.getSelectionModel().addSelectionInterval(anchor, lead);
        }

        void removeSelectionInterval(int index0, int index1) {
            this.getSelectionModel().removeSelectionInterval(index0, index1);
        }

        void setSelectedList(List<VisualStyle> styles) {
            ListSelectionModel sm = this.getSelectionModel();
            sm.clearSelection();
            for (VisualStyle vs : styles) {
                int idx = this.indexOf(vs);
                if (idx < 0) continue;
                sm.addSelectionInterval(idx, idx);
            }
            VisualStyleSelector.this.selectionHead = -1;
            VisualStyleSelector.this.selectionTail = -1;
        }

        void setSelectionModel(ListSelectionModel selectionModel) {
            if (selectionModel == null) {
                throw new IllegalArgumentException("selectionModel must be non null");
            }
            if (this.selectionListener != null) {
                this.selectionModel.removeListSelectionListener(this.selectionListener);
                selectionModel.addListSelectionListener(this.selectionListener);
            }
            ListSelectionModel oldValue = this.selectionModel;
            this.selectionModel = selectionModel;
            this.firePropertyChange("selectionModel", oldValue, selectionModel);
        }

        ListModel<VisualStyle> getModel() {
            return this.dataModel;
        }

        void setModel(ListModel<VisualStyle> model) {
            if (model == null) {
                throw new IllegalArgumentException("model must be non null");
            }
            ListModel<VisualStyle> oldValue = this.dataModel;
            this.dataModel = model;
            this.firePropertyChange("model", oldValue, this.dataModel);
            VisualStyleSelector.this.selectionIsAdjusting = true;
            try {
                this.deselectAll();
                this.update();
            }
            finally {
                VisualStyleSelector.this.selectionIsAdjusting = false;
            }
        }

        void ensureIndexIsVisible(int index) {
            Rectangle cellBounds = this.getCellBounds(index, index);
            if (cellBounds != null) {
                this.scrollRectToVisible(cellBounds);
            }
        }

        Rectangle getCellBounds(int index0, int index1) {
            return null;
        }

        void addListSelectionListener(ListSelectionListener listener) {
            if (this.selectionListener == null) {
                this.selectionListener = new ListSelectionHandler();
                this.getSelectionModel().addListSelectionListener(this.selectionListener);
            }
            this.listenerList.add(ListSelectionListener.class, listener);
        }

        void removeListSelectionListener(ListSelectionListener listener) {
            this.listenerList.remove(ListSelectionListener.class, listener);
        }

        ListSelectionListener[] getListSelectionListeners() {
            return (ListSelectionListener[])this.listenerList.getListeners(ListSelectionListener.class);
        }

        private ListSelectionModel createSelectionModel() {
            return new DefaultListSelectionModel();
        }

        protected void fireSelectionValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
            Object[] listeners = this.listenerList.getListenerList();
            ListSelectionEvent e = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ListSelectionListener.class) continue;
                if (e == null) {
                    e = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
                }
                ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
            }
        }

        void setDirty(VisualStyle style) {
            StylePanel item;
            if (style != null && (item = this.getItem(style)) != null) {
                item.setDirty();
            }
        }

        void updateStylePanels() {
            for (StylePanel item : this.vsPanelMap.values()) {
                if (!item.isDirty()) continue;
                item.update();
            }
        }

        void update() {
            this.removeAll();
            ListModel<VisualStyle> dm = this.getModel();
            if (dm.getSize() > 0) {
                Dimension size;
                Dimension dimension = size = this.getParent() != null ? this.getParent().getSize() : null;
                if (size != null) {
                    int itemWidth = 130;
                    int width = size != null ? size.width : itemWidth;
                    VisualStyleSelector.this.cols = width <= 0 ? VisualStyleSelector.this.minColumns : VisualStyleSelector.this.calculateColumns(itemWidth, width);
                } else {
                    VisualStyleSelector.this.cols = VisualStyleSelector.this.minColumns;
                }
                int rows = VisualStyleSelector.this.calculateRows(dm.getSize(), VisualStyleSelector.this.cols);
                this.setLayout(new GridLayout(rows, VisualStyleSelector.this.cols));
                for (int i = 0; i < dm.getSize(); ++i) {
                    VisualStyle vs = dm.getElementAt(i);
                    StylePanel itemPnl = this.getItem(vs);
                    if (itemPnl == null) {
                        itemPnl = this.createItem(vs);
                    }
                    if (VisualStyleSelector.this.isFilteredOut(vs)) continue;
                    this.add(itemPnl);
                }
                int diff = VisualStyleSelector.this.cols * rows - dm.getSize();
                for (int i = 0; i < diff; ++i) {
                    JPanel fillPnl = new JPanel();
                    fillPnl.setBackground(VisualStyleSelector.this.BG_COLOR);
                    fillPnl.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent evt) {
                            if (VisualStyleSelector.this.isEditMode() && !evt.isShiftDown()) {
                                StyleGrid.this.deselectAll();
                            }
                        }
                    });
                    this.add(fillPnl);
                }
            }
            this.revalidate();
            this.repaint();
        }

        void update(List<VisualStyle> data) {
            this.vsPanelMap.clear();
            VisualStyleSelector.this.filterStyles();
        }

        private StylePanel createItem(VisualStyle style) {
            final StylePanel item = new StylePanel(style);
            this.vsPanelMap.put(style, item);
            item.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (StyleGrid.this.isEnabled() && !VisualStyleSelector.this.editingTitle) {
                        item.requestFocusInWindow();
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (StyleGrid.this.isEnabled()) {
                        StyleGrid.this.onMousePressedItem(evt, item);
                    }
                }
            });
            item.getTitleTextField().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (StyleGrid.this.isEnabled()) {
                        StyleGrid.this.onMousePressedItem(evt, item);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (StyleGrid.this.isEnabled() && VisualStyleSelector.this.isEditMode() && evt.getClickCount() == 2) {
                        StyleGrid.this.editTitleStart(item);
                    }
                }
            });
            return item;
        }

        private void onMousePressedItem(MouseEvent evt, StylePanel item) {
            item.requestFocusInWindow();
            if (VisualStyleSelector.this.isEditMode()) {
                int index = this.indexOf(item.style);
                boolean selected = VisualStyleSelector.this.isSelected(item.style);
                ListSelectionModel sm = this.getSelectionModel();
                if (evt.isPopupTrigger()) {
                    VisualStyleSelector.this.selectionHead = index;
                } else {
                    boolean isMac = LookAndFeelUtil.isMac();
                    if (isMac && evt.isMetaDown() || !isMac && evt.isControlDown()) {
                        this.toggleSelection(item);
                        VisualStyleSelector.this.selectionHead = selected ? index : this.findNextSelectionHead(VisualStyleSelector.this.selectionHead);
                    } else if (evt.isShiftDown()) {
                        if (VisualStyleSelector.this.selectionHead >= 0 && VisualStyleSelector.this.selectionHead != index && sm.isSelectedIndex(VisualStyleSelector.this.selectionHead)) {
                            if (VisualStyleSelector.this.selectionTail >= 0) {
                                this.changeRangeSelection(VisualStyleSelector.this.selectionHead, VisualStyleSelector.this.selectionTail, false);
                            }
                            VisualStyleSelector.this.selectionTail = index;
                            this.changeRangeSelection(VisualStyleSelector.this.selectionHead, VisualStyleSelector.this.selectionTail, true);
                        } else if (!selected) {
                            this.addSelectionInterval(index, index);
                        }
                    } else {
                        this.setSelectedValue(item.getStyle(), false);
                    }
                    if (sm.getSelectedItemsCount() == 1) {
                        VisualStyleSelector.this.selectionHead = index;
                    }
                }
            } else {
                this.setSelectedValue(item.getStyle(), false);
            }
            item.repaint();
        }

        private void toggleSelection(StylePanel item) {
            int index = this.indexOf(item.style);
            if (this.isSelectedIndex(index)) {
                this.removeSelectionInterval(index, index);
            } else {
                this.addSelectionInterval(index, index);
            }
        }

        private void changeRangeSelection(int index0, int index1, boolean select) {
            if (select) {
                this.addSelectionInterval(index0, index1);
            } else {
                this.removeSelectionInterval(index0, index1);
            }
        }

        private int findNextSelectionHead(int fromIndex) {
            int head = -1;
            if (fromIndex >= 0) {
                VisualStyle nextItem;
                int i;
                ListModel<VisualStyle> dm = this.getModel();
                int total = dm.getSize();
                for (i = fromIndex; i < total; ++i) {
                    nextItem = dm.getElementAt(i);
                    if (!VisualStyleSelector.this.isSelected(nextItem)) continue;
                    head = i;
                    break;
                }
                if (head == -1) {
                    for (i = fromIndex; i <= 0; --i) {
                        nextItem = dm.getElementAt(i);
                        if (!VisualStyleSelector.this.isSelected(nextItem)) continue;
                        head = i;
                        break;
                    }
                }
            }
            return head;
        }

        void editTitleStart(final StylePanel item) {
            if (VisualStyleSelector.this.getProxy().isDefaultStyle(item.getStyle())) {
                return;
            }
            VisualStyleSelector.this.editingTitle = true;
            final String oldValue = item.getTitleTextField().getText().trim();
            item.getTitleTextField().setFocusable(true);
            item.getTitleTextField().setEditable(true);
            item.getTitleTextField().requestFocusInWindow();
            item.getTitleTextField().selectAll();
            item.getTitleTextField().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StyleGrid.this.editTitleCommit(item, oldValue);
                    item.getTitleTextField().removeActionListener(this);
                }
            });
            item.getTitleTextField().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent evt) {
                    StyleGrid.this.editTitleCommit(item, oldValue);
                    item.getTitleTextField().removeFocusListener(this);
                }
            });
            item.getTitleTextField().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == 27) {
                        StyleGrid.this.editTitleCancel(item, oldValue);
                        item.getTitleTextField().removeKeyListener(this);
                        evt.consume();
                    }
                }
            });
        }

        void editTitleCommit(StylePanel item, String oldValue) {
            String newValue = item.getTitleTextField().getText().trim();
            if (newValue.isEmpty() || newValue.equals(oldValue)) {
                this.editTitleCancel(item, oldValue);
                return;
            }
            this.editTitleEnd(item);
            RenameVisualStyleTask task = new RenameVisualStyleTask(item.getStyle(), VisualStyleSelector.this.servicesUtil);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("vsName", newValue);
            TaskIterator taskIterator = VisualStyleSelector.this.servicesUtil.get(TunableSetter.class).createTaskIterator(new TaskIterator(new Task[]{task}), map);
            new Thread(() -> VisualStyleSelector.this.servicesUtil.get(DialogTaskManager.class).execute(taskIterator)).start();
        }

        void editTitleCancel(StylePanel item, String oldValue) {
            item.getTitleTextField().setText(oldValue);
            this.editTitleEnd(item);
        }

        void editTitleEnd(StylePanel item) {
            item.getTitleTextField().setEditable(false);
            item.requestFocusInWindow();
            item.getTitleTextField().setFocusable(false);
            VisualStyleSelector.this.editingTitle = false;
        }

        private void setKeyBindings() {
            ActionMap actionMap = this.getActionMap();
            InputMap inputMap = this.getInputMap(1);
            int ctrl = LookAndFeelUtil.isMac() ? 256 : 128;
            inputMap.put(KeyStroke.getKeyStroke(37, 0), "VK_LEFT");
            inputMap.put(KeyStroke.getKeyStroke(39, 0), "VK_RIGHT");
            inputMap.put(KeyStroke.getKeyStroke(38, 0), "VK_UP");
            inputMap.put(KeyStroke.getKeyStroke(40, 0), "VK_DOWN");
            inputMap.put(KeyStroke.getKeyStroke(10, 0), "VK_ENTER");
            inputMap.put(KeyStroke.getKeyStroke(32, 0), "VK_SPACE");
            inputMap.put(KeyStroke.getKeyStroke(65, ctrl), "VK_CTRL_A");
            inputMap.put(KeyStroke.getKeyStroke(65, ctrl + 64), "VK_CTRL_SHIFT_A");
            actionMap.put("VK_LEFT", new KeyAction("VK_LEFT"));
            actionMap.put("VK_RIGHT", new KeyAction("VK_RIGHT"));
            actionMap.put("VK_UP", new KeyAction("VK_UP"));
            actionMap.put("VK_DOWN", new KeyAction("VK_DOWN"));
            actionMap.put("VK_ENTER", new KeyAction("VK_ENTER"));
            actionMap.put("VK_SPACE", new KeyAction("VK_SPACE"));
            actionMap.put("VK_CTRL_A", new KeyAction("VK_CTRL_A"));
            actionMap.put("VK_CTRL_SHIFT_A", new KeyAction("VK_CTRL_SHIFT_A"));
        }

        private class KeyAction
        extends AbstractAction {
            static final String VK_LEFT = "VK_LEFT";
            static final String VK_RIGHT = "VK_RIGHT";
            static final String VK_UP = "VK_UP";
            static final String VK_DOWN = "VK_DOWN";
            static final String VK_ENTER = "VK_ENTER";
            static final String VK_SPACE = "VK_SPACE";
            static final String VK_CTRL_A = "VK_CTRL_A";
            static final String VK_CTRL_SHIFT_A = "VK_CTRL_SHIFT_A";

            KeyAction(String actionCommand) {
                this.putValue("ActionCommandKey", actionCommand);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                String cmd = evt.getActionCommand();
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                StylePanel focusedItem = focusOwner instanceof StylePanel ? (StylePanel)focusOwner : null;
                ListModel<VisualStyle> dm = StyleGrid.this.getModel();
                if (cmd.equals(VK_ENTER) || cmd.equals(VK_SPACE)) {
                    if (focusedItem != null) {
                        StyleGrid.this.setSelectedValue(focusedItem.getStyle(), false);
                    }
                } else if (dm.getSize() > 0) {
                    int idx;
                    VisualStyle vs = focusedItem != null ? focusedItem.getStyle() : dm.getElementAt(0);
                    int size = dm.getSize();
                    int newIdx = idx = StyleGrid.this.indexOf(vs);
                    if (cmd.equals(VK_RIGHT)) {
                        newIdx = idx + 1;
                    } else if (cmd.equals(VK_LEFT)) {
                        newIdx = idx - 1;
                    } else if (cmd.equals(VK_UP)) {
                        newIdx = idx - VisualStyleSelector.this.cols < 0 ? idx : idx - VisualStyleSelector.this.cols;
                    } else if (cmd.equals(VK_DOWN)) {
                        boolean sameRow = Math.ceil((double)size / (double)VisualStyleSelector.this.cols) == Math.ceil((double)(idx + 1) / (double)VisualStyleSelector.this.cols);
                        newIdx = sameRow ? idx : Math.min(size - 1, idx + VisualStyleSelector.this.cols);
                    } else if (cmd.equals(VK_CTRL_A)) {
                        if (VisualStyleSelector.this.isEditMode()) {
                            StyleGrid.this.selectAll();
                        }
                    } else if (cmd.equals(VK_CTRL_SHIFT_A) && VisualStyleSelector.this.isEditMode()) {
                        StyleGrid.this.deselectAll();
                    }
                    if (newIdx != idx) {
                        StyleGrid.this.setFocus(newIdx);
                    }
                }
            }
        }

        private class ListSelectionHandler
        implements ListSelectionListener,
        Serializable {
            private ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                StyleGrid.this.fireSelectionValueChanged(e.getFirstIndex(), e.getLastIndex(), e.getValueIsAdjusting());
            }
        }
    }
}

