/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.view.AbstractVizMapperModel;

public class VisualPropertySheetModel
extends AbstractVizMapperModel {
    private final Class<? extends CyIdentifiable> targetDataType;
    private final VisualStyle style;
    private final VisualLexicon lexicon;

    public VisualPropertySheetModel(Class<? extends CyIdentifiable> targetDataType, VisualStyle style, VisualLexicon lexicon) {
        if (targetDataType != CyNode.class && targetDataType != CyEdge.class && targetDataType != CyNetwork.class && targetDataType != CyColumn.class) {
            throw new IllegalArgumentException("'targetDataType' must be CyNode.class, CyEdge.class, CyNetwork.class or CyColumn.class");
        }
        if (style == null) {
            throw new IllegalArgumentException("'style' must not be null");
        }
        this.targetDataType = targetDataType;
        this.style = style;
        this.lexicon = lexicon;
    }

    public Class<? extends CyIdentifiable> getTargetDataType() {
        return this.targetDataType;
    }

    public VisualStyle getVisualStyle() {
        return this.style;
    }

    public VisualLexicon getVisualLexicon() {
        return this.lexicon;
    }

    public VisualProperty<?> getRootVisualProperty() {
        if (this.targetDataType == CyNode.class) {
            return BasicVisualLexicon.NODE;
        }
        if (this.targetDataType == CyEdge.class) {
            return BasicVisualLexicon.EDGE;
        }
        if (this.targetDataType == CyColumn.class) {
            return BasicTableVisualLexicon.CELL;
        }
        return BasicVisualLexicon.NETWORK;
    }

    public String getTitle() {
        if (this.targetDataType == CyNode.class) {
            return "Node";
        }
        if (this.targetDataType == CyEdge.class) {
            return "Edge";
        }
        if (this.targetDataType == CyColumn.class) {
            return "Table";
        }
        return "Network";
    }
}

