/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import java.util.Objects;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.property.values.Bend;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.model.LockedValueState;
import org.cytoscape.view.vizmap.gui.internal.view.AbstractVizMapperModel;

public class VisualPropertySheetItemModel<T>
extends AbstractVizMapperModel {
    private final VisualProperty<T> visualProperty;
    private VisualPropertyDependency<T> dependency;
    private final String title;
    private final VisualStyle style;
    private RenderingEngine<?> engine;
    private final VisualLexicon lexicon;
    private String mappingColumnName;
    private T defaultValue;
    private T lockedValue;
    private VisualMappingFunction<?, T> visualMappingFunction;
    private LockedValueState lockedValueState = LockedValueState.DISABLED;

    public VisualPropertySheetItemModel(VisualProperty<T> visualProperty, VisualStyle style, RenderingEngine<?> engine, VisualLexicon lexicon) {
        this.visualProperty = Objects.requireNonNull(visualProperty, "'visualProperty' must not be null");
        this.style = Objects.requireNonNull(style, "'style' must not be null");
        this.engine = Objects.requireNonNull(engine);
        this.lexicon = Objects.requireNonNull(lexicon, "'lexicon' must not be null");
        this.defaultValue = style.getDefaultValue(visualProperty);
        this.setVisualMappingFunction(style.getVisualMappingFunction(visualProperty));
        this.title = VisualPropertySheetItemModel.createTitle(visualProperty);
    }

    public VisualPropertySheetItemModel(VisualPropertyDependency<T> dependency, VisualStyle style, RenderingEngine<?> engine, VisualLexicon lexicon) {
        this.dependency = Objects.requireNonNull(dependency, "'dependency' must not be null");
        this.visualProperty = dependency.getParentVisualProperty();
        this.style = Objects.requireNonNull(style, "'style' must not be null");
        this.engine = Objects.requireNonNull(engine);
        this.lexicon = Objects.requireNonNull(lexicon, "'lexicon' must not be null");
        this.title = dependency.getDisplayName();
    }

    public VisualProperty<T> getVisualProperty() {
        return this.visualProperty;
    }

    public VisualPropertyDependency<T> getVisualPropertyDependency() {
        return this.dependency;
    }

    public String getTitle() {
        return this.title;
    }

    public String getId() {
        return this.dependency != null ? this.dependency.getIdString() : this.visualProperty.getIdString();
    }

    public Class<? extends CyIdentifiable> getTargetDataType() {
        return this.getVisualProperty().getTargetDataType();
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(T value) {
        if (value == null && this.defaultValue != null || value != null && !value.equals(this.defaultValue)) {
            this.defaultValue = value;
            this.propChangeSupport.firePropertyChange("defaultValue", this.defaultValue, this.defaultValue);
        }
    }

    public T getLockedValue() {
        return this.lockedValue;
    }

    public void resetDefaultValue() {
        this.setDefaultValue(this.getVisualProperty().getDefault());
    }

    public void setLockedValue(T value) {
        if (value == null && this.lockedValue != null || value != null && (!value.equals(this.lockedValue) || value instanceof Bend)) {
            if (value instanceof Bend) {
                this.lockedValue = value;
                this.propChangeSupport.firePropertyChange("lockedValue", null, this.lockedValue);
            } else {
                this.lockedValue = value;
                this.propChangeSupport.firePropertyChange("lockedValue", this.lockedValue, this.lockedValue);
            }
        }
    }

    public LockedValueState getLockedValueState() {
        return this.lockedValueState;
    }

    public void setLockedValueState(LockedValueState state) {
        if (state != this.lockedValueState) {
            this.lockedValueState = state;
            this.propChangeSupport.firePropertyChange("lockedValueState", (Object)this.lockedValueState, (Object)this.lockedValueState);
        }
    }

    public VisualStyle getVisualStyle() {
        return this.style;
    }

    public RenderingEngine<?> getRenderingEngine() {
        return this.engine;
    }

    public void setRenderingEngine(RenderingEngine<?> engine) {
        if (engine != this.engine) {
            this.engine = engine;
            this.propChangeSupport.firePropertyChange("renderingEngine", engine, this.engine);
        }
    }

    public VisualLexicon getVisualLexicon() {
        return this.lexicon;
    }

    public boolean isDependencyEnabled() {
        return this.getVisualPropertyDependency() != null && this.getVisualPropertyDependency().isDependencyEnabled();
    }

    public VisualMappingFunction<?, T> getVisualMappingFunction() {
        return this.visualMappingFunction;
    }

    public void setVisualMappingFunction(VisualMappingFunction<?, T> mapping) {
        if (this.isVisualMappingAllowed() && (mapping == null || mapping.getVisualProperty() == this.visualProperty) && mapping != this.visualMappingFunction) {
            this.visualMappingFunction = mapping;
            this.propChangeSupport.firePropertyChange("visualMappingFunction", this.visualMappingFunction, this.visualMappingFunction);
        }
        this.setMappingColumnName(mapping == null ? null : mapping.getMappingColumnName(), false);
    }

    public String getMappingColumnName() {
        return this.mappingColumnName;
    }

    public void setMappingColumnName(String name) {
        this.setMappingColumnName(name, true);
    }

    public boolean isVisualMappingAllowed() {
        if (this.visualProperty.getIdString().equals("CELL_FORMAT")) {
            return false;
        }
        return this.getTargetDataType() != CyNetwork.class && this.getVisualPropertyDependency() == null;
    }

    public boolean isLockedValueAllowed() {
        return this.getTargetDataType() != CyColumn.class && this.getVisualPropertyDependency() == null;
    }

    public static String createTitle(VisualProperty<?> vp) {
        String targetName;
        String title = vp.getDisplayName();
        if (title.startsWith(targetName = vp.getTargetDataType().getSimpleName().replace("Cy", "") + " ")) {
            title = title.replaceFirst(targetName, "");
        }
        return title.trim();
    }

    private void setMappingColumnName(String name, boolean updateRelatedProperties) {
        if (name == null && this.mappingColumnName != null || name != null && !name.equals(this.mappingColumnName)) {
            this.mappingColumnName = name;
            if (updateRelatedProperties) {
                this.setVisualMappingFunction(null);
            }
            this.propChangeSupport.firePropertyChange("mappingColumnName", this.mappingColumnName, name);
        }
    }

    public void update(RenderingEngine<?> engine) {
        this.setRenderingEngine(engine);
        if (this.dependency == null) {
            this.setDefaultValue(this.style.getDefaultValue(this.visualProperty));
            this.setVisualMappingFunction(this.style.getVisualMappingFunction(this.visualProperty));
        } else {
            for (VisualPropertyDependency dep : this.style.getAllVisualPropertyDependencies()) {
                if (!dep.getIdString().equals(this.dependency.getIdString()) || !dep.getParentVisualProperty().equals(this.dependency.getParentVisualProperty())) continue;
                this.dependency = dep;
                break;
            }
        }
    }
}

