/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Collection;
import java.util.Collections;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.cytoscape.application.swing.CyColumnComboBox;
import org.cytoscape.application.swing.CyColumnPresentationManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.OptionsButton;

public class ColumnStylePanel {
    private final ServicesUtil servicesUtil;
    private OptionsButton optionsBtn;
    private JComboBox<CyTable> tableCombo;
    private CyColumnComboBox columnCombo;
    private JPanel columnPanel;

    public ColumnStylePanel(ServicesUtil servicesUtil) {
        this.servicesUtil = servicesUtil;
    }

    public JComponent getComponent() {
        return this.getColumnPanel();
    }

    public JPanel getColumnPanel() {
        if (this.columnPanel == null) {
            this.columnPanel = new JPanel();
            this.columnPanel.setOpaque(!LookAndFeelUtil.isAquaLAF());
            this.columnPanel.setBorder(LookAndFeelUtil.createTitledBorder((String)"Apply Style To:"));
            this.getColumnComboBox().setPreferredSize(new Dimension(this.getColumnComboBox().getPreferredSize().width, this.getOptionsBtn().getOptionsBtn().getPreferredSize().height));
            GroupLayout layout = new GroupLayout(this.columnPanel);
            this.columnPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            JLabel tableLbl = new JLabel("Table:");
            JLabel columnLbl = new JLabel("Column:");
            layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(tableLbl, -2, -1, -2).addComponent(this.getTableComboBox(), -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(columnLbl, -2, -1, -2).addComponent((Component)this.getColumnComboBox(), -1, -1, Short.MAX_VALUE).addComponent(this.getOptionsBtn().getOptionsBtn(), -2, 64, -2)));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(tableLbl, -2, -1, -2).addComponent(this.getTableComboBox(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(columnLbl, -2, -1, -2).addComponent((Component)this.getColumnComboBox(), -2, -1, -2).addComponent(this.getOptionsBtn().getOptionsBtn(), -2, -1, -2)));
            LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{tableLbl, columnLbl});
        }
        return this.columnPanel;
    }

    JComboBox<CyTable> getTableComboBox() {
        if (this.tableCombo == null) {
            this.tableCombo = new JComboBox();
            final CyNetworkTableManager netTableManager = this.servicesUtil.get(CyNetworkTableManager.class);
            IconManager iconManager = this.servicesUtil.get(IconManager.class);
            final TextIcon globalTableIcon = new TextIcon("\uf0ce", iconManager.getIconFont(14.0f), 16, 16);
            Font iconFont = iconManager.getIconFont("cytoscape-3", 14.0f);
            final TextIcon nodeTableIcon = new TextIcon("#", iconFont, 16, 16);
            final TextIcon edgeTableIcon = new TextIcon("!", iconFont, 16, 16);
            final TextIcon netTableIcon = new TextIcon("\"", iconFont, 16, 16);
            this.tableCombo.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel comp = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (value == null) {
                        this.setText("-- None --");
                        this.setIcon(null);
                    } else {
                        CyTable table = (CyTable)value;
                        Object text = table.getTitle();
                        TextIcon icon = globalTableIcon;
                        String namespace = netTableManager.getTableNamespace(table);
                        Class type = netTableManager.getTableType(table);
                        if (type != null && "USER".equals(namespace)) {
                            text = "Default " + type.getSimpleName().replace("Cy", "");
                        }
                        if (type == CyNode.class) {
                            icon = nodeTableIcon;
                        } else if (type == CyEdge.class) {
                            icon = edgeTableIcon;
                        } else if (type == CyNetwork.class) {
                            icon = netTableIcon;
                        }
                        comp.setText((String)text);
                        comp.setIcon((Icon)icon);
                    }
                    return comp;
                }
            });
        }
        return this.tableCombo;
    }

    CyColumnComboBox getColumnComboBox() {
        if (this.columnCombo == null) {
            CyColumnPresentationManager columnPresentationManager = this.servicesUtil.get(CyColumnPresentationManager.class);
            this.columnCombo = new CyColumnComboBox(columnPresentationManager, Collections.emptyList());
        }
        return this.columnCombo;
    }

    OptionsButton getOptionsBtn() {
        if (this.optionsBtn == null) {
            this.optionsBtn = new OptionsButton(this.servicesUtil);
        }
        return this.optionsBtn;
    }

    public void updateColumns(Collection<CyTable> tables, CyTable selTable, Collection<CyColumn> columns, CyColumn selColumn) {
        JComboBox<CyTable> tableComboBox = this.getTableComboBox();
        tableComboBox.removeAllItems();
        if (tables != null) {
            tables.forEach(tableComboBox::addItem);
        }
        if (selTable != null) {
            tableComboBox.setSelectedItem(selTable);
        }
        CyColumnComboBox columnComboBox = this.getColumnComboBox();
        columnComboBox.removeAllItems();
        if (columns != null) {
            columns.forEach(arg_0 -> columnComboBox.addItem(arg_0));
        }
        if (selColumn != null) {
            columnComboBox.setSelectedItem((Object)selColumn);
        }
        this.update();
    }

    private void update() {
        this.getTableComboBox().setEnabled(this.getTableComboBox().getItemCount() > 0);
        this.getColumnComboBox().setEnabled(this.getColumnComboBox().getItemCount() > 0);
        this.getOptionsBtn().getOptionsBtn().setEnabled(this.getColumnComboBox().getItemCount() > 0);
    }
}

