/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.util.mapgenerator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.util.mapgenerator.AbstractDiscreteMappingGenerator;

public class FitLabelMappingGenerator<V extends Number>
extends AbstractDiscreteMappingGenerator<V> {
    private final ServicesUtil servicesUtil;

    public FitLabelMappingGenerator(Class<V> type, ServicesUtil servicesUtil) {
        super(type);
        this.servicesUtil = servicesUtil;
    }

    @Override
    public <T> Map<T, V> generateMap(Set<T> tableValues) {
        CyApplicationManager appMgr = this.servicesUtil.get(CyApplicationManager.class);
        CyNetworkView networkView = appMgr.getCurrentNetworkView();
        if (networkView == null) {
            return Collections.emptyMap();
        }
        if (tableValues == null || tableValues.isEmpty()) {
            return Collections.emptyMap();
        }
        T testName = tableValues.iterator().next();
        if (!(testName instanceof String)) {
            throw new IllegalArgumentException("This generator only works with 'name' column.");
        }
        CyNetwork network = (CyNetwork)networkView.getModel();
        CyTable nodeTable = ((CyNetwork)networkView.getModel()).getDefaultNodeTable();
        VisualMappingManager vmMgr = this.servicesUtil.get(VisualMappingManager.class);
        VisualStyle style = vmMgr.getCurrentVisualStyle();
        VisualMappingFunction fontSizeMapping = style.getVisualMappingFunction(BasicVisualLexicon.NODE_LABEL_FONT_SIZE);
        Double maxLabelWidth = (Double)style.getDefaultValue(BasicVisualLexicon.NODE_LABEL_WIDTH);
        HashMap<T, Double> valueMap = new HashMap<T, Double>();
        for (T attrVal : tableValues) {
            Long suid;
            View nodeView;
            Collection rows = nodeTable.getMatchingRows("name", attrVal);
            CyRow row = null;
            if (rows.isEmpty() || (nodeView = networkView.getNodeView(network.getNode((suid = (Long)(row = (CyRow)rows.iterator().next()).get("SUID", Long.class)).longValue()))) == null) continue;
            String labelText = (String)nodeView.getVisualProperty(BasicVisualLexicon.NODE_LABEL);
            int textLen = labelText.length();
            int fontSize = fontSizeMapping == null ? ((Integer)style.getDefaultValue(BasicVisualLexicon.NODE_LABEL_FONT_SIZE)).intValue() : ((Integer)nodeView.getVisualProperty(BasicVisualLexicon.NODE_LABEL_FONT_SIZE)).intValue();
            Double width = (double)(fontSize * textLen) * 0.7;
            if (maxLabelWidth > width) {
                valueMap.put(attrVal, width);
                continue;
            }
            valueMap.put(attrVal, maxLabelWidth);
        }
        return valueMap;
    }
}

