/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.util;

import java.util.Map;
import org.cytoscape.work.ServiceProperties;

public final class ServicePropertiesUtil
implements ServiceProperties {
    public static final String SERVICE_TYPE = "service.type";
    public static final String MENU_ID = "menu";
    public static final String GRAVITY = "gravity";
    public static final String MAIN_MENU = "main";
    public static final String CONTEXT_MENU = "context";
    public static final String TABLE_MAIN_MENU = "table";

    public static String getServiceType(Map<?, ?> properties) {
        return ServicePropertiesUtil.getString(properties, SERVICE_TYPE, null);
    }

    public static String getTitle(Map<?, ?> properties) {
        return ServicePropertiesUtil.getString(properties, "title", null);
    }

    public static double getGravity(Map<?, ?> properties) {
        double gravity = -1.0;
        try {
            gravity = properties.get(GRAVITY) != null ? Double.parseDouble(properties.get(GRAVITY).toString()) : gravity;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return gravity;
    }

    public static boolean getInsertSeparatorBefore(Map<?, ?> properties) {
        return ServicePropertiesUtil.getBoolean(properties, "insertSeparatorBefore", false);
    }

    public static boolean getInsertSeparatorAfter(Map<?, ?> properties) {
        return ServicePropertiesUtil.getBoolean(properties, "insertSeparatorAfter", false);
    }

    public static boolean getBoolean(Map<?, ?> properties, String key, boolean def) {
        boolean b = def;
        try {
            b = Boolean.parseBoolean(properties.get(key) != null ? properties.get(key).toString() : "false");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b;
    }

    public static String getString(Map<?, ?> properties, String key, String def) {
        return properties.get(key) != null ? properties.get(key).toString() : def;
    }

    private ServicePropertiesUtil() {
    }
}

