/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.task;

import java.util.Set;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.task.RemoveVisualStylesTask;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class RemoveVisualStylesTaskFactory
extends AbstractTaskFactory {
    private final ServicesUtil servicesUtil;

    public RemoveVisualStylesTaskFactory(ServicesUtil servicesUtil) {
        this.servicesUtil = servicesUtil;
    }

    public TaskIterator createTaskIterator() {
        VisualStyle style = this.servicesUtil.get(VisualMappingManager.class).getCurrentVisualStyle();
        return new TaskIterator(new Task[]{new RemoveVisualStylesTask(style, this.servicesUtil)});
    }

    public TaskIterator createTaskIterator(Set<VisualStyle> styles) {
        return new TaskIterator(new Task[]{new RemoveVisualStylesTask(styles, this.servicesUtil)});
    }

    public boolean isReady() {
        VisualMappingManager vmMgr = this.servicesUtil.get(VisualMappingManager.class);
        return !this.isDefaultVisualStyle(vmMgr.getCurrentVisualStyle());
    }

    public boolean isReady(Set<VisualStyle> styles) {
        if (styles == null || styles.isEmpty()) {
            return false;
        }
        if (styles.size() == 1) {
            return !this.isDefaultVisualStyle(styles.iterator().next());
        }
        return true;
    }

    private boolean isDefaultVisualStyle(VisualStyle style) {
        VisualMappingManager vmMgr = this.servicesUtil.get(VisualMappingManager.class);
        return vmMgr.getDefaultVisualStyle().equals(style);
    }
}

