/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.task;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class RemoveVisualStylesTask
extends AbstractTask {
    public static final String TITLE = "Remove Style";
    private final Set<VisualStyle> styles = new HashSet<VisualStyle>();
    private final ServicesUtil servicesUtil;
    private final Map<CyNetworkView, VisualStyle> stylesByView = new HashMap<CyNetworkView, VisualStyle>();

    public RemoveVisualStylesTask(VisualStyle style, ServicesUtil servicesUtil) {
        this(Collections.singleton(style), servicesUtil);
    }

    public RemoveVisualStylesTask(Set<VisualStyle> styles, ServicesUtil servicesUtil) {
        if (styles != null && !styles.isEmpty()) {
            this.styles.addAll(styles);
        }
        this.servicesUtil = servicesUtil;
    }

    @ProvidesTitle
    public String getTitle() {
        return TITLE + (this.styles.size() > 1 ? "s" : "");
    }

    public void run(TaskMonitor tm) throws Exception {
        if (!this.styles.isEmpty()) {
            this.removeVisualStyles();
            UndoSupport undo = this.servicesUtil.get(UndoSupport.class);
            undo.postEdit((AbstractCyEdit)new RemoveVisualStylesEdit());
        }
    }

    private void removeVisualStyles() {
        VisualMappingManager vmMgr = this.servicesUtil.get(VisualMappingManager.class);
        VisualStyle defStyle = vmMgr.getDefaultVisualStyle();
        CyNetworkViewManager netViewMgr = this.servicesUtil.get(CyNetworkViewManager.class);
        Set viewSet = netViewMgr.getNetworkViewSet();
        for (VisualStyle vs : this.styles) {
            if (defStyle.equals(vs)) {
                if (this.styles.size() != 1) continue;
                throw new IllegalArgumentException("You cannot delete the default style.");
            }
            for (CyNetworkView view : viewSet) {
                if (!vs.equals(vmMgr.getVisualStyle(view))) continue;
                this.stylesByView.put(view, vs);
            }
            vmMgr.removeVisualStyle(vs);
        }
    }

    private class RemoveVisualStylesEdit
    extends AbstractCyEdit {
        public RemoveVisualStylesEdit() {
            super(RemoveVisualStylesTask.this.getTitle());
        }

        public void undo() {
            VisualMappingManager vmMgr = RemoveVisualStylesTask.this.servicesUtil.get(VisualMappingManager.class);
            CyNetworkViewManager netViewMgr = RemoveVisualStylesTask.this.servicesUtil.get(CyNetworkViewManager.class);
            Set viewSet = netViewMgr.getNetworkViewSet();
            for (VisualStyle visualStyle : RemoveVisualStylesTask.this.styles) {
                if (vmMgr.getAllVisualStyles().contains(visualStyle)) continue;
                vmMgr.addVisualStyle(visualStyle);
            }
            for (Map.Entry entry : RemoveVisualStylesTask.this.stylesByView.entrySet()) {
                CyNetworkView view = (CyNetworkView)entry.getKey();
                VisualStyle vs = (VisualStyle)entry.getValue();
                if (!viewSet.contains(view)) continue;
                vmMgr.setVisualStyle(vs, view);
            }
        }

        public void redo() {
            if (!RemoveVisualStylesTask.this.styles.isEmpty()) {
                RemoveVisualStylesTask.this.removeVisualStyles();
            }
        }
    }
}

