/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.task;

import java.util.HashSet;
import java.util.Set;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.VizMapGUI;
import org.cytoscape.view.vizmap.gui.internal.task.RemoveVisualMappingsTask;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheet;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItem;
import org.cytoscape.view.vizmap.gui.internal.view.VizMapperMainPanel;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class RemoveVisualMappingsTaskFactory
extends AbstractTaskFactory {
    private final ServicesUtil servicesUtil;

    public RemoveVisualMappingsTaskFactory(ServicesUtil servicesUtil) {
        this.servicesUtil = servicesUtil;
    }

    public TaskIterator createTaskIterator() {
        VisualStyle style = this.servicesUtil.get(VisualMappingManager.class).getCurrentVisualStyle();
        HashSet mappings = new HashSet();
        VizMapGUI gui = this.servicesUtil.get(VizMapGUI.class);
        if (gui instanceof VizMapperMainPanel) {
            VisualPropertySheet vpSheet = ((VizMapperMainPanel)gui).getSelectedVisualPropertySheet();
            Set<VisualPropertySheetItem<?>> selectedItems = vpSheet.getSelectedItems();
            for (VisualPropertySheetItem<?> item : selectedItems) {
                if (item.getModel().getVisualMappingFunction() == null) continue;
                mappings.add(item.getModel().getVisualMappingFunction());
            }
        }
        return new TaskIterator(new Task[]{new RemoveVisualMappingsTask(mappings, style, this.servicesUtil)});
    }

    public boolean isReady() {
        VisualPropertySheet vpSheet;
        VizMapGUI gui = this.servicesUtil.get(VizMapGUI.class);
        if (gui instanceof VizMapperMainPanel && (vpSheet = ((VizMapperMainPanel)gui).getSelectedVisualPropertySheet()).getModel().getTargetDataType() != CyNetwork.class) {
            for (VisualPropertySheetItem<?> item : vpSheet.getSelectedItems()) {
                if (item.getModel().getVisualMappingFunction() == null) continue;
                return true;
            }
        }
        return false;
    }
}

