/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Set;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.io.write.VizmapWriterFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class MakeVisualStylesDefaultTask
extends AbstractTask {
    public static final String TITLE = "Make Current Styles Default";
    @Tunable(description="<html>Do you want the current styles to be the default list<br>in all future Cytoscape sessions (this cannot be undone)?</html>", params="ForceSetDirectly=true;ForceSetTitle=Make Current Styles Default")
    public boolean confirm;
    private final ServicesUtil servicesUtil;

    public MakeVisualStylesDefaultTask(ServicesUtil servicesUtil) {
        this.servicesUtil = servicesUtil;
    }

    @ProvidesTitle
    public String getTitle() {
        return TITLE;
    }

    public void run(TaskMonitor monitor) throws Exception {
        if (!this.confirm) {
            return;
        }
        VisualMappingManager vmMgr = this.servicesUtil.get(VisualMappingManager.class);
        Set currentStyles = vmMgr.getAllVisualStyles();
        if (!currentStyles.isEmpty()) {
            VizmapWriterFactory vizmapWriterFactory = this.servicesUtil.get(VizmapWriterFactory.class);
            CyApplicationConfiguration config = this.servicesUtil.get(CyApplicationConfiguration.class);
            FileOutputStream os = new FileOutputStream(new File(config.getConfigurationDirectoryLocation(), "default_vizmap.xml"));
            CyWriter vizmapWriter = vizmapWriterFactory.createWriter((OutputStream)os, currentStyles);
            if (!this.cancelled) {
                vizmapWriter.run(monitor);
            }
        }
    }
}

