/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.task;

import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class CopyVisualStyleTask
extends AbstractTask {
    public static final String TITLE = "Copy Style";
    @Tunable(description="Name of copied Style:")
    public String vsName;
    private VisualStyle copiedStyle;
    private VisualStyle previousCurrentStyle;
    private final VisualStyle originalStyle;
    private final ServicesUtil servicesUtil;

    public CopyVisualStyleTask(VisualStyle style, ServicesUtil servicesUtil) {
        this.originalStyle = style;
        this.servicesUtil = servicesUtil;
    }

    @ProvidesTitle
    public String getTitle() {
        return TITLE;
    }

    public void run(TaskMonitor monitor) throws Exception {
        if (this.vsName != null && this.originalStyle != null) {
            this.copyVisualStyle();
            UndoSupport undo = this.servicesUtil.get(UndoSupport.class);
            undo.postEdit((AbstractCyEdit)new CopyVisualStyleEdit());
        }
    }

    private void copyVisualStyle() {
        VisualStyleFactory vsFactory = this.servicesUtil.get(VisualStyleFactory.class);
        this.copiedStyle = vsFactory.createVisualStyle(this.originalStyle);
        this.copiedStyle.setTitle(this.vsName);
        VisualMappingManager vmMgr = this.servicesUtil.get(VisualMappingManager.class);
        this.previousCurrentStyle = vmMgr.getCurrentVisualStyle();
        vmMgr.addVisualStyle(this.copiedStyle);
        vmMgr.setCurrentVisualStyle(this.copiedStyle);
    }

    private class CopyVisualStyleEdit
    extends AbstractCyEdit {
        public CopyVisualStyleEdit() {
            super(CopyVisualStyleTask.this.getTitle());
        }

        public void undo() {
            VisualMappingManager vmMgr = CopyVisualStyleTask.this.servicesUtil.get(VisualMappingManager.class);
            if (CopyVisualStyleTask.this.copiedStyle != null && vmMgr.getAllVisualStyles().contains(CopyVisualStyleTask.this.copiedStyle)) {
                vmMgr.removeVisualStyle(CopyVisualStyleTask.this.copiedStyle);
                if (CopyVisualStyleTask.this.previousCurrentStyle != null) {
                    vmMgr.setCurrentVisualStyle(CopyVisualStyleTask.this.previousCurrentStyle);
                }
            }
        }

        public void redo() {
            VisualMappingManager vmMgr = CopyVisualStyleTask.this.servicesUtil.get(VisualMappingManager.class);
            if (CopyVisualStyleTask.this.copiedStyle != null && !vmMgr.getAllVisualStyles().contains(CopyVisualStyleTask.this.copiedStyle)) {
                vmMgr.addVisualStyle(CopyVisualStyleTask.this.copiedStyle);
                vmMgr.setCurrentVisualStyle(CopyVisualStyleTask.this.copiedStyle);
            }
        }
    }
}

