/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.task;

import org.cytoscape.model.CyColumn;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.table.CyColumnView;
import org.cytoscape.view.vizmap.TableVisualMappingManager;
import org.cytoscape.view.vizmap.gui.internal.CurrentTableService;
import org.cytoscape.view.vizmap.gui.internal.model.VizMapperProxy;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class ClearColumnStyleTask
extends AbstractTask {
    public static final String TITLE = "Clear Current Style";
    private final ServicesUtil servicesUtil;

    public ClearColumnStyleTask(ServicesUtil servicesUtil) {
        this.servicesUtil = servicesUtil;
    }

    public void run(TaskMonitor tm) {
        VizMapperProxy vmProxy = (VizMapperProxy)this.servicesUtil.getProxy("VisualStyleProxy");
        CyColumn column = this.servicesUtil.get(CurrentTableService.class).getCurrentColumn();
        if (column == null) {
            return;
        }
        CyColumnView colView = vmProxy.getColumnView(column);
        if (colView == null) {
            return;
        }
        TableVisualMappingManager tvmm = this.servicesUtil.get(TableVisualMappingManager.class);
        tvmm.setVisualStyle((View)colView, null);
    }
}

