/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.model;

import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.application.events.CyStartEvent;
import org.cytoscape.application.events.CyStartListener;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.application.events.SetCurrentTableEvent;
import org.cytoscape.application.events.SetCurrentTableListener;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.session.events.SessionAboutToBeLoadedEvent;
import org.cytoscape.session.events.SessionAboutToBeLoadedListener;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.table.CyColumnView;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.model.table.CyTableViewManager;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.vizmap.TableVisualMappingManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.events.SetCurrentVisualStyleEvent;
import org.cytoscape.view.vizmap.events.SetCurrentVisualStyleListener;
import org.cytoscape.view.vizmap.events.VisualStyleAboutToBeRemovedEvent;
import org.cytoscape.view.vizmap.events.VisualStyleAboutToBeRemovedListener;
import org.cytoscape.view.vizmap.events.VisualStyleAddedEvent;
import org.cytoscape.view.vizmap.events.VisualStyleAddedListener;
import org.cytoscape.view.vizmap.events.VisualStyleChangedEvent;
import org.cytoscape.view.vizmap.events.VisualStyleChangedListener;
import org.cytoscape.view.vizmap.events.table.ColumnVisualStyleSetEvent;
import org.cytoscape.view.vizmap.events.table.ColumnVisualStyleSetListener;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.util.PropertySheetUtil;
import org.puremvc.java.multicore.patterns.proxy.Proxy;

public class VizMapperProxy
extends Proxy
implements VisualStyleAddedListener,
VisualStyleAboutToBeRemovedListener,
VisualStyleChangedListener,
SetCurrentVisualStyleListener,
SetCurrentNetworkListener,
SetCurrentNetworkViewListener,
SetCurrentTableListener,
ColumnVisualStyleSetListener,
SessionAboutToBeLoadedListener,
SessionLoadedListener,
CyStartListener {
    public static final String NAME = "VisualStyleProxy";
    public static final String PRESET_VIZMAP_FILE = "default_vizmap.xml";
    private final SortedSet<VisualStyle> visualStyles;
    private final ServicesUtil servicesUtil;
    private VisualStyle originalDefaultVisualStyle;
    private volatile boolean cytoscapeStarted;
    private volatile boolean loadingSession;
    private volatile boolean ignoreStyleEvents;
    private final Object lock = new Object();

    public VizMapperProxy(ServicesUtil servicesUtil) {
        super(NAME, new TreeSet<VisualStyle>(new Comparator<VisualStyle>(){

            @Override
            public int compare(VisualStyle vs1, VisualStyle vs2) {
                Collator collator = Collator.getInstance(Locale.getDefault());
                collator.setStrength(0);
                return collator.compare(vs1.getTitle(), vs2.getTitle());
            }
        }));
        this.visualStyles = (SortedSet)this.getData();
        this.servicesUtil = servicesUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<VisualStyle> getVisualStyles() {
        Object object = this.lock;
        synchronized (object) {
            return new TreeSet<VisualStyle>(this.visualStyles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadVisualStyles() {
        boolean changed = false;
        SortedSet<VisualStyle> updatedStyles = null;
        Object object = this.lock;
        synchronized (object) {
            Set<VisualStyle> allStyles = this.getAllVisualStyles();
            if (!allStyles.isEmpty() || !this.visualStyles.isEmpty()) {
                VisualStyle defStyle = this.servicesUtil.get(VisualMappingManager.class).getDefaultVisualStyle();
                this.originalDefaultVisualStyle = this.servicesUtil.get(VisualStyleFactory.class).createVisualStyle(defStyle);
                this.visualStyles.clear();
                this.visualStyles.addAll(allStyles);
                updatedStyles = this.getVisualStyles();
                changed = true;
            }
        }
        if (changed && this.cytoscapeStarted) {
            this.sendNotification("VISUAL_STYLE_SET_CHANGED", updatedStyles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVisualStyle(VisualStyle vs) {
        Object object = this.lock;
        synchronized (object) {
            if (vs != null) {
                this.servicesUtil.get(VisualMappingManager.class).addVisualStyle(vs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVisualStyle(VisualStyle vs) {
        Object object = this.lock;
        synchronized (object) {
            if (vs != null) {
                this.servicesUtil.get(VisualMappingManager.class).removeVisualStyle(vs);
            }
        }
    }

    public VisualStyle getOriginalDefaultVisualStyle() {
        return this.originalDefaultVisualStyle;
    }

    public boolean isDefaultStyle(VisualStyle vs) {
        return vs.equals(this.getDefaultVisualStyle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualStyle getDefaultVisualStyle() {
        Object object = this.lock;
        synchronized (object) {
            return this.servicesUtil.get(VisualMappingManager.class).getDefaultVisualStyle();
        }
    }

    public boolean isTableStyle(VisualStyle style) {
        return this.servicesUtil.get(TableVisualMappingManager.class).getAllVisualStyles().contains(style);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public VisualStyle getCurrentVisualStyle() {
        Object object = this.lock;
        synchronized (object) {
            return this.servicesUtil.get(VisualMappingManager.class).getCurrentVisualStyle();
        }
    }

    @Deprecated
    public void setCurrentVisualStyle(VisualStyle vs) {
        VisualStyle curVs = this.getCurrentVisualStyle();
        VisualMappingManager vmMgr = this.servicesUtil.get(VisualMappingManager.class);
        if (vs != null && !vs.equals(curVs)) {
            vmMgr.setCurrentVisualStyle(vs);
        }
    }

    public VisualStyle getVisualStyle(CyNetworkView view) {
        return this.servicesUtil.get(VisualMappingManager.class).getVisualStyle(view);
    }

    public CyTableView getTableView(CyColumn column) {
        CyTableViewManager tableViewManager = this.servicesUtil.get(CyTableViewManager.class);
        return tableViewManager.getTableView(column.getTable());
    }

    public CyColumnView getColumnView(CyColumn column) {
        CyTableView tableView = this.getTableView(column);
        if (tableView == null) {
            return null;
        }
        View colView = tableView.getColumnView(column);
        if (colView instanceof CyColumnView) {
            return (CyColumnView)colView;
        }
        return null;
    }

    public RenderingEngine<CyTable> getRenderingEngine(CyColumn column) {
        CyTableView tableView = this.getTableView(column);
        if (tableView == null) {
            return null;
        }
        RenderingEngineManager renderingEngineManager = this.servicesUtil.get(RenderingEngineManager.class);
        return (RenderingEngine)renderingEngineManager.getRenderingEngines((View)tableView).iterator().next();
    }

    public RenderingEngine<CyTable> getCurrentTableRenderingEngine() {
        CyTable table = this.getCurrentTable();
        CyTableViewManager tableViewManager = this.servicesUtil.get(CyTableViewManager.class);
        CyTableView tableView = tableViewManager.getTableView(table);
        RenderingEngineManager renderingEngineManager = this.servicesUtil.get(RenderingEngineManager.class);
        Collection renderingEngines = renderingEngineManager.getRenderingEngines((View)tableView);
        return renderingEngines.isEmpty() ? null : (RenderingEngine)renderingEngines.iterator().next();
    }

    public CyTable getCurrentTable() {
        CyApplicationManager appMgr = this.servicesUtil.get(CyApplicationManager.class);
        return appMgr.getCurrentTable();
    }

    public VisualStyle getVisualStyle(CyColumn column) {
        if (column == null) {
            return null;
        }
        CyColumnView colView = this.getColumnView(column);
        if (colView == null) {
            return null;
        }
        TableVisualMappingManager tableMappingManager = this.servicesUtil.get(TableVisualMappingManager.class);
        VisualStyle style = tableMappingManager.getVisualStyle((View)colView);
        if (style == null) {
            VisualStyleFactory factory = this.servicesUtil.get(VisualStyleFactory.class);
            style = factory.createVisualStyle(UUID.randomUUID().toString());
            tableMappingManager.setVisualStyle((View)colView, style);
        }
        return style;
    }

    public CyNetwork getCurrentNetwork() {
        return this.servicesUtil.get(CyApplicationManager.class).getCurrentNetwork();
    }

    public CyNetworkView getCurrentNetworkView() {
        return this.servicesUtil.get(CyApplicationManager.class).getCurrentNetworkView();
    }

    public RenderingEngine<CyNetwork> getCurrentRenderingEngine() {
        return this.servicesUtil.get(CyApplicationManager.class).getCurrentRenderingEngine();
    }

    public RenderingEngineFactory<CyNetwork> getCurrentRenderingEngineFactory() {
        NetworkViewRenderer nvRenderer = this.servicesUtil.get(CyApplicationManager.class).getCurrentNetworkViewRenderer();
        if (nvRenderer != null) {
            return nvRenderer.getRenderingEngineFactory("");
        }
        return this.servicesUtil.get(RenderingEngineFactory.class);
    }

    public NetworkViewRenderer getNetworkViewRenderer(CyNetworkView netView) {
        return this.getNetworkViewRenderer(netView.getRendererId());
    }

    public NetworkViewRenderer getNetworkViewRenderer(String rendererId) {
        return this.servicesUtil.get(CyApplicationManager.class).getNetworkViewRenderer(rendererId);
    }

    public RenderingEngineFactory<CyNetwork> getRenderingEngineFactory(CyNetworkView netView) {
        return this.getNetworkViewRenderer(netView).getRenderingEngineFactory("");
    }

    public VisualLexicon getCurrentVisualLexicon() {
        VisualLexicon lexicon = null;
        RenderingEngineFactory<CyNetwork> curRenderingEngineFactory = this.getCurrentRenderingEngineFactory();
        if (curRenderingEngineFactory != null) {
            lexicon = curRenderingEngineFactory.getVisualLexicon();
        }
        if (lexicon == null) {
            RenderingEngine<CyNetwork> engine = this.getCurrentRenderingEngine();
            lexicon = engine != null ? engine.getVisualLexicon() : this.servicesUtil.get(RenderingEngineManager.class).getDefaultVisualLexicon();
        }
        return lexicon;
    }

    public Set<View<CyNode>> getSelectedNodeViews(CyNetworkView netView) {
        HashSet<View<CyNode>> views = new HashSet<View<CyNode>>();
        if (netView != null) {
            List nodes = CyTableUtil.getNodesInState((CyNetwork)((CyNetwork)netView.getModel()), (String)"selected", (boolean)true);
            for (CyNode n : nodes) {
                View nv = netView.getNodeView(n);
                if (nv == null) continue;
                views.add((View<CyNode>)nv);
            }
        }
        return views;
    }

    public Set<View<CyEdge>> getSelectedEdgeViews(CyNetworkView netView) {
        HashSet<View<CyEdge>> views = new HashSet<View<CyEdge>>();
        if (netView != null) {
            List edges = CyTableUtil.getEdgesInState((CyNetwork)((CyNetwork)netView.getModel()), (String)"selected", (boolean)true);
            for (CyEdge e : edges) {
                View ev = netView.getEdgeView(e);
                if (ev == null) continue;
                views.add((View<CyEdge>)ev);
            }
        }
        return views;
    }

    public Set<CyNetworkView> getNetworkViewsWithStyle(VisualStyle style) {
        HashSet<CyNetworkView> views = new HashSet<CyNetworkView>();
        if (style != null) {
            VisualMappingManager vmMgr = this.servicesUtil.get(VisualMappingManager.class);
            Set allNetViews = this.servicesUtil.get(CyNetworkViewManager.class).getNetworkViewSet();
            for (CyNetworkView nv : allNetViews) {
                if (!style.equals(vmMgr.getVisualStyle(nv))) continue;
                views.add(nv);
            }
        }
        return views;
    }

    public int countNetworkViewsWithStyle(VisualStyle style) {
        int count = 0;
        if (style != null) {
            VisualMappingManager vmMgr = this.servicesUtil.get(VisualMappingManager.class);
            Set allNetViews = this.servicesUtil.get(CyNetworkViewManager.class).getNetworkViewSet();
            for (CyNetworkView nv : allNetViews) {
                if (!style.equals(vmMgr.getVisualStyle(nv))) continue;
                ++count;
            }
        }
        return count;
    }

    public static boolean isSupported(VisualLexicon lexicon, VisualProperty<?> vp) {
        return PropertySheetUtil.isCompatible(vp) != false && lexicon.isSupported(vp);
    }

    public static boolean isSupported(VisualLexicon lexicon, VisualPropertyDependency<?> dependency) {
        if (!VizMapperProxy.isSupported(lexicon, dependency.getParentVisualProperty())) {
            return false;
        }
        for (VisualProperty vp : dependency.getVisualProperties()) {
            if (VizMapperProxy.isSupported(lexicon, vp)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIgnoreStyleEvents(boolean b) {
        Object object = this.lock;
        synchronized (object) {
            this.ignoreStyleEvents = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(VisualStyleAddedEvent e) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.cytoscapeStarted || this.ignoreStyleEvents) {
                return;
            }
        }
        VisualStyle vs = e.getVisualStyleAdded();
        boolean changed = false;
        Object object2 = this.lock;
        synchronized (object2) {
            changed = this.visualStyles.add(vs);
        }
        if (changed && !this.loadingSession) {
            this.sendNotification("VISUAL_STYLE_ADDED", vs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(VisualStyleAboutToBeRemovedEvent e) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.cytoscapeStarted || this.ignoreStyleEvents) {
                return;
            }
        }
        VisualStyle vs = e.getVisualStyleToBeRemoved();
        boolean changed = false;
        Object object2 = this.lock;
        synchronized (object2) {
            changed = this.visualStyles.remove(vs);
        }
        if (changed && !this.loadingSession) {
            this.sendNotification("VISUAL_STYLE_REMOVED", vs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(VisualStyleChangedEvent e) {
        Object object = this.lock;
        synchronized (object) {
            if (this.ignoreStyleEvents) {
                return;
            }
        }
        if (this.cytoscapeStarted && !this.loadingSession) {
            this.sendNotification("VISUAL_STYLE_UPDATED", e.getSource());
        }
    }

    public void handleEvent(SetCurrentVisualStyleEvent e) {
        if (this.cytoscapeStarted && !this.loadingSession) {
            this.sendNotification("CURRENT_VISUAL_STYLE_CHANGED", e.getVisualStyle());
        }
    }

    public void handleEvent(ColumnVisualStyleSetEvent e) {
        if (this.cytoscapeStarted && !this.loadingSession) {
            this.sendNotification("CURRENT_TABLE_VISUAL_STYLE_CHANGED", ((CyColumn)e.getColumnView().getModel()).getTable());
        }
    }

    public void handleEvent(SetCurrentNetworkEvent e) {
        if (this.cytoscapeStarted && !this.loadingSession) {
            this.sendNotification("CURRENT_NETWORK_CHANGED", e.getNetwork());
        }
    }

    public void handleEvent(SetCurrentNetworkViewEvent e) {
        if (this.cytoscapeStarted && !this.loadingSession) {
            this.sendNotification("CURRENT_NETWORK_VIEW_CHANGED", e.getNetworkView());
        }
    }

    public void handleEvent(SetCurrentTableEvent e) {
        if (this.cytoscapeStarted && !this.loadingSession) {
            this.sendNotification("CURRENT_TABLE_CHANGED", e.getTable());
        }
    }

    public void handleEvent(CyStartEvent e) {
        this.cytoscapeStarted = true;
        if (this.servicesUtil.get(CySessionManager.class).getCurrentSessionFileName() == null) {
            this.sendNotification("LOAD_DEFAULT_VISUAL_STYLES");
        } else {
            this.loadVisualStyles();
        }
    }

    public void handleEvent(SessionAboutToBeLoadedEvent e) {
        this.loadingSession = true;
    }

    public void handleEvent(SessionLoadedEvent e) {
        this.loadingSession = false;
        if (e.getLoadedFileName() == null) {
            this.sendNotification("LOAD_DEFAULT_VISUAL_STYLES");
        } else {
            this.sendNotification("VISUAL_STYLE_SET_CHANGED", this.getVisualStyles());
        }
    }

    private Set<VisualStyle> getAllVisualStyles() {
        return this.servicesUtil.get(VisualMappingManager.class).getAllVisualStyles();
    }
}

