/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.action;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.task.visualize.ApplyVisualStyleTaskFactory;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.model.VizMapperProxy;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.VisualStyleSelector;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TunableSetter;
import org.cytoscape.work.swing.DialogTaskManager;
import org.cytoscape.work.util.ListSingleSelection;

public class ApplyVisualStyleAction
extends AbstractCyAction {
    public static final String NAME = "Apply Style...";
    private boolean cancelled;
    private final ServicesUtil servicesUtil;

    public ApplyVisualStyleAction(float gravity, ServicesUtil servicesUtil) {
        super(NAME);
        this.servicesUtil = servicesUtil;
        this.setMenuGravity(gravity);
    }

    public void actionPerformed(ActionEvent evt) {
        List views = this.servicesUtil.get(CyApplicationManager.class).getSelectedNetworkViews();
        if (views.isEmpty()) {
            return;
        }
        VisualStyle style = this.selectVisualStyle(views, evt);
        if (style == null) {
            return;
        }
        HashMap<String, ListSingleSelection> tunables = new HashMap<String, ListSingleSelection>();
        tunables.put("styles", new ListSingleSelection((Object[])new VisualStyle[]{style}));
        ApplyVisualStyleTaskFactory factory = this.servicesUtil.get(ApplyVisualStyleTaskFactory.class);
        TunableSetter tunableSetter = this.servicesUtil.get(TunableSetter.class);
        TaskIterator taskIterator = tunableSetter.createTaskIterator(factory.createTaskIterator((Collection)views), tunables);
        DialogTaskManager taskManager = this.servicesUtil.get(DialogTaskManager.class);
        taskManager.execute(taskIterator);
    }

    public void updateEnableState() {
        List views = this.servicesUtil.get(CyApplicationManager.class).getSelectedNetworkViews();
        ApplyVisualStyleTaskFactory factory = this.servicesUtil.get(ApplyVisualStyleTaskFactory.class);
        this.setEnabled(factory.isReady((Collection)views));
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.updateEnableState();
    }

    private VisualStyle selectVisualStyle(List<CyNetworkView> views, ActionEvent evt) {
        Component c = evt.getSource() instanceof Component ? (Component)evt.getSource() : null;
        Window owner = c != null ? SwingUtilities.getWindowAncestor(c) : this.servicesUtil.get(CySwingApplication.class).getJFrame();
        final JDialog dialog = new JDialog(owner, "Styles", Dialog.ModalityType.APPLICATION_MODAL);
        VizMapperProxy vmProxy = (VizMapperProxy)this.servicesUtil.getProxy("VisualStyleProxy");
        SortedSet<VisualStyle> styles = vmProxy.getVisualStyles();
        VisualStyle oldValue = this.getCommonVisualStyle(views);
        VisualStyleSelector styleSelector = new VisualStyleSelector(3, 0, false, this.servicesUtil);
        styleSelector.update(styles, oldValue);
        JButton cancelBtn = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplyVisualStyleAction.this.cancelled = true;
                dialog.dispose();
            }
        });
        JButton okBtn = new JButton(new AbstractAction("Apply"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplyVisualStyleAction.this.cancelled = false;
                dialog.dispose();
            }
        });
        okBtn.setEnabled(oldValue != null);
        styleSelector.addPropertyChangeListener("selectedStyle", e -> okBtn.setEnabled(styleSelector.getSelectionCount() == 1));
        JPanel okCancelPanel = LookAndFeelUtil.createOkCancelPanel((JButton)okBtn, (JButton)cancelBtn);
        GroupLayout layout = new GroupLayout(dialog.getContentPane());
        dialog.getContentPane().setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(styleSelector, 500, -1, Short.MAX_VALUE).addComponent(okCancelPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(styleSelector, -1, -1, Short.MAX_VALUE).addComponent(okCancelPanel, -2, -1, -2));
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)dialog.getRootPane(), (Action)okBtn.getAction(), (Action)cancelBtn.getAction());
        dialog.getRootPane().setDefaultButton(okBtn);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        VisualStyle selectedStyle = this.cancelled ? null : styleSelector.getSelectedStyle();
        styleSelector.dispose();
        return selectedStyle;
    }

    private VisualStyle getCommonVisualStyle(List<CyNetworkView> views) {
        HashSet<VisualStyle> set = new HashSet<VisualStyle>();
        VisualMappingManager vmManager = this.servicesUtil.get(VisualMappingManager.class);
        for (CyNetworkView v : views) {
            VisualStyle style = vmManager.getVisualStyle(v);
            if (style == null) continue;
            set.add(style);
        }
        return set.size() == 1 ? (VisualStyle)set.iterator().next() : null;
    }
}

