/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.intr;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cytoscape.util.intr.LongEnumerator;

public final class LongObjHash
implements Serializable {
    private static final long serialVersionUID = 121374594955439L;
    private static final int[] PRIMES = new int[]{11, 23, 53, 113, 251, 509, 1019, 2039, 4079, 8179, 16369, 32749, 65521, 131063, 262133, 524269, 1048571, 0x1FFFF7, 0x3FFFEF, 8388587, 0xFFFFDF, 33554393, 67108837, 134217689, 0xFFFFFC7, 0x1FFFFFDF, 0x3FFFFFDD, Integer.MAX_VALUE};
    private static final int INITIAL_SIZE = PRIMES[10];
    private static final double THRESHOLD_FACTOR = 0.77;
    private long[] m_keys;
    private Object[] m_vals;
    private int m_elements;
    private int m_thresholdSize;
    private long m_prevKey;
    private int m_prevInx;

    public static final int maxCapacity(int num) {
        int inx;
        for (inx = 0; inx < PRIMES.length && num >= PRIMES[inx]; ++inx) {
        }
        int thresholdSize = (int)(0.77 * (double)PRIMES[inx]);
        if (thresholdSize >= num) {
            return thresholdSize;
        }
        if (++inx == PRIMES.length) {
            return -1;
        }
        return (int)(0.77 * (double)PRIMES[inx]);
    }

    public LongObjHash() {
        this.m_keys = new long[INITIAL_SIZE];
        this.m_vals = new Object[INITIAL_SIZE];
        this.m_elements = 0;
        this.m_thresholdSize = (int)(0.77 * (double)this.m_keys.length);
        for (int i = 0; i < this.m_keys.length; ++i) {
            this.m_keys[i] = -1L;
        }
        this.m_prevKey = -1L;
        this.m_prevInx = -1;
    }

    public LongObjHash(LongObjHash source) {
        this.m_keys = Arrays.copyOf(source.m_keys, source.m_keys.length);
        this.m_vals = Arrays.copyOf(source.m_vals, source.m_vals.length);
        this.m_elements = source.m_elements;
        this.m_thresholdSize = source.m_thresholdSize;
        this.m_prevKey = -1L;
        this.m_prevInx = -1;
    }

    public final int size() {
        return this.m_elements;
    }

    public final Object put(long key, Object value) {
        Object returnVal;
        if (key < 0L) {
            throw new IllegalArgumentException("key is negative");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (key != this.m_prevKey) {
            int incr = 0;
            this.m_prevInx = (int)(key % (long)this.m_keys.length);
            while (this.m_keys[this.m_prevInx] >= 0L && this.m_keys[this.m_prevInx] != key) {
                if (incr == 0) {
                    incr = 1 + (int)(key % (long)(this.m_keys.length - 1));
                }
                this.m_prevInx = (int)((long)(this.m_prevInx + incr) % (long)this.m_keys.length);
            }
            this.m_prevKey = key;
        }
        if ((returnVal = this.m_vals[this.m_prevInx]) == null) {
            if (this.m_elements == this.m_thresholdSize) {
                this.incrSize();
                return this.put(key, value);
            }
            ++this.m_elements;
        }
        this.m_vals[this.m_prevInx] = value;
        this.m_keys[this.m_prevInx] = key;
        return returnVal;
    }

    public final Object get(long key) {
        if (key < 0L) {
            throw new IllegalArgumentException("key is negative");
        }
        if (key != this.m_prevKey) {
            int incr = 0;
            this.m_prevInx = (int)(key % (long)this.m_keys.length);
            while (this.m_keys[this.m_prevInx] >= 0L && this.m_keys[this.m_prevInx] != key) {
                if (incr == 0) {
                    incr = 1 + (int)(key % (long)(this.m_keys.length - 1));
                }
                this.m_prevInx = (int)((long)(this.m_prevInx + incr) % (long)this.m_keys.length);
            }
            this.m_prevKey = key;
        }
        return this.m_vals[this.m_prevInx];
    }

    public final LongEnumerator keys() {
        final int numElements = this.m_elements;
        return new LongEnumerator(){
            int elements;
            int index;
            {
                this.elements = numElements;
                this.index = -1;
            }

            @Override
            public final int numRemaining() {
                return this.elements;
            }

            @Override
            public final long nextLong() {
                while (LongObjHash.this.m_keys[++this.index] < 0L) {
                }
                --this.elements;
                return LongObjHash.this.m_keys[this.index];
            }
        };
    }

    public final Iterator values() {
        final int numElements = this.m_elements;
        return new Iterator(){
            int elements;
            int index;
            {
                this.elements = numElements;
                this.index = -1;
            }

            @Override
            public final boolean hasNext() {
                return this.elements == 0;
            }

            public final Object next() {
                try {
                    while (LongObjHash.this.m_vals[++this.index] == null) {
                    }
                    --this.elements;
                    return LongObjHash.this.m_vals[this.index];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private final void incrSize() {
        int newSize;
        try {
            int primesInx = 0;
            while (this.m_keys.length != PRIMES[primesInx++]) {
            }
            newSize = PRIMES[primesInx];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalStateException("too many elements in this hashtable");
        }
        long[] newKeys = new long[newSize];
        Object[] newVals = new Object[newSize];
        for (int i = 0; i < newKeys.length; ++i) {
            newKeys[i] = -1L;
        }
        this.m_thresholdSize = (int)(0.77 * (double)newKeys.length);
        int oldIndex = -1;
        for (int i = 0; i < this.m_elements; ++i) {
            while (this.m_keys[++oldIndex] < 0L) {
            }
            int incr = 0;
            int newIndex = (int)(this.m_keys[oldIndex] % (long)newKeys.length);
            while (newKeys[newIndex] >= 0L) {
                if (incr == 0) {
                    incr = 1 + (int)(this.m_keys[oldIndex] % (long)(newKeys.length - 1));
                }
                newIndex = (int)((long)(newIndex + incr) % (long)newKeys.length);
            }
            newKeys[newIndex] = this.m_keys[oldIndex];
            newVals[newIndex] = this.m_vals[oldIndex];
        }
        this.m_keys = newKeys;
        this.m_vals = newVals;
        this.m_prevKey = -1L;
        this.m_prevInx = -1;
    }
}

