/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.intr;

import java.io.Serializable;
import org.cytoscape.util.intr.LongEnumerator;

public final class LongHash
implements Serializable {
    private static final long serialVersionUID = 1213745949547L;
    private static final int[] PRIMES = new int[]{11, 23, 53, 113, 251, 509, 1019, 2039, 4079, 8179, 16369, 32749, 65521, 131063, 262133, 524269, 1048571, 0x1FFFF7, 0x3FFFEF, 8388587, 0xFFFFDF, 33554393, 67108837, 134217689, 0xFFFFFC7, 0x1FFFFFDF, 0x3FFFFFDD, Integer.MAX_VALUE};
    private static final int INITIAL_SIZE = PRIMES[0];
    private static final double THRESHOLD_FACTOR = 0.77;
    private long[] m_arr = new long[INITIAL_SIZE];
    private int m_elements;
    private int m_size;
    private int m_thresholdSize;
    private long[] m_dump = null;

    public LongHash() {
        this.empty();
    }

    public final void empty() {
        this.m_elements = 0;
        this.m_size = INITIAL_SIZE;
        this.m_thresholdSize = (int)(0.77 * (double)this.m_size);
        for (int i = 0; i < this.m_size; ++i) {
            this.m_arr[i] = -1L;
        }
    }

    public final int size() {
        return this.m_elements;
    }

    public final long put(long value) {
        int index;
        if (this.m_elements == this.m_thresholdSize) {
            this.incrSize();
        }
        int incr = 0;
        try {
            index = (int)(value % (((value ^ 0xFFFFFFFFFFFFFFFFL) >>> 63) * (long)this.m_size));
            while (this.m_arr[index] >= 0L && this.m_arr[index] != value) {
                if (incr == 0) {
                    incr = 1 + (int)(value % (long)(this.m_size - 1));
                }
                index = (index + incr) % this.m_size;
            }
        }
        catch (ArithmeticException exc) {
            throw new IllegalArgumentException("value is negative");
        }
        long returnVal = this.m_arr[index];
        this.m_arr[index] = value;
        this.m_elements += (int)(returnVal >>> 63);
        return returnVal;
    }

    public final long get(long value) {
        int index;
        int incr = 0;
        try {
            index = (int)(value % (((value ^ 0xFFFFFFFFFFFFFFFFL) >>> 63) * (long)this.m_size));
            while (this.m_arr[index] >= 0L && this.m_arr[index] != value) {
                if (incr == 0) {
                    incr = 1 + (int)(value % (long)(this.m_size - 1));
                }
                index = (index + incr) % this.m_size;
            }
        }
        catch (ArithmeticException exc) {
            throw new IllegalArgumentException("value is negative");
        }
        return this.m_arr[index];
    }

    public final LongEnumerator elements() {
        final long[] array = this.m_arr;
        final int numElements = this.m_elements;
        return new LongEnumerator(){
            int elements;
            int index;
            {
                this.elements = numElements;
                this.index = -1;
            }

            @Override
            public int numRemaining() {
                return this.elements;
            }

            @Override
            public long nextLong() {
                while (array[++this.index] < 0L) {
                }
                --this.elements;
                return array[this.index];
            }
        };
    }

    private final void incrSize() {
        int newSize;
        try {
            int primesInx = 0;
            while (this.m_size != PRIMES[primesInx++]) {
            }
            newSize = PRIMES[primesInx];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalStateException("too many elements in this hashtable");
        }
        if (this.m_arr.length < newSize) {
            this.m_dump = this.m_arr;
            this.m_arr = new long[newSize];
        } else {
            System.arraycopy(this.m_arr, 0, this.m_dump, 0, this.m_size);
        }
        for (int i = 0; i < newSize; ++i) {
            this.m_arr[i] = -1L;
        }
        this.m_size = newSize;
        this.m_thresholdSize = (int)(0.77 * (double)this.m_size);
        int oldIndex = -1;
        for (int i = 0; i < this.m_elements; ++i) {
            while (this.m_dump[++oldIndex] < 0L) {
            }
            int incr = 0;
            int newIndex = (int)(this.m_dump[oldIndex] % (long)this.m_size);
            while (this.m_arr[newIndex] >= 0L) {
                if (incr == 0) {
                    incr = 1 + (int)(this.m_dump[oldIndex] % (long)(this.m_size - 1));
                }
                newIndex = (newIndex + incr) % this.m_size;
            }
            this.m_arr[newIndex] = this.m_dump[oldIndex];
        }
    }
}

