/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.internal.util;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.property.values.ObjectPosition;
import org.cytoscape.view.presentation.property.values.Position;

public class CustomGraphicsPositionCalculator {
    private static final Map<Position, Float[]> DISPLACEMENT_MAP = new HashMap<Position, Float[]>();

    public static CustomGraphicLayer transform(ObjectPosition p, double width, double height, CustomGraphicLayer layer) {
        Position anc = p.getAnchor();
        Position ancN = p.getTargetAnchor();
        Rectangle2D bounds = layer.getBounds2D();
        double cgW = bounds.getWidth();
        double cgH = bounds.getHeight();
        Float[] disp1 = DISPLACEMENT_MAP.get(anc);
        Float[] disp2 = DISPLACEMENT_MAP.get(ancN);
        double dispX = (double)(-disp1[0].floatValue()) * width;
        double dispY = (double)(-disp1[1].floatValue()) * height;
        double dispNX = (double)disp2[0].floatValue() * cgW;
        double dispNY = (double)disp2[1].floatValue() * cgH;
        double totalDispX = dispX + dispNX + p.getOffsetX();
        double totalDispY = dispY + dispNY + p.getOffsetY();
        AffineTransform tf = AffineTransform.getTranslateInstance(totalDispX, totalDispY);
        return layer.transform(tf);
    }

    static {
        DISPLACEMENT_MAP.put(Position.CENTER, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f)});
        DISPLACEMENT_MAP.put(Position.NORTH, new Float[]{Float.valueOf(0.0f), Float.valueOf(-0.5f)});
        DISPLACEMENT_MAP.put(Position.NORTH_WEST, new Float[]{Float.valueOf(-0.5f), Float.valueOf(-0.5f)});
        DISPLACEMENT_MAP.put(Position.NORTH_EAST, new Float[]{Float.valueOf(0.5f), Float.valueOf(-0.5f)});
        DISPLACEMENT_MAP.put(Position.SOUTH, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.5f)});
        DISPLACEMENT_MAP.put(Position.SOUTH_WEST, new Float[]{Float.valueOf(-0.5f), Float.valueOf(0.5f)});
        DISPLACEMENT_MAP.put(Position.SOUTH_EAST, new Float[]{Float.valueOf(0.5f), Float.valueOf(0.5f)});
        DISPLACEMENT_MAP.put(Position.WEST, new Float[]{Float.valueOf(-0.5f), Float.valueOf(0.0f)});
        DISPLACEMENT_MAP.put(Position.EAST, new Float[]{Float.valueOf(0.5f), Float.valueOf(0.0f)});
    }
}

