/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.awt.Paint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.ding.impl.cyannotator.tasks.AbstractAnnotationTunables;
import org.cytoscape.ding.internal.util.ColorUtil;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class ShapeAnnotationTunables
extends AbstractAnnotationTunables {
    @Tunable(context="nogui", description="The height of this shape")
    public Double height = null;
    @Tunable(context="nogui", description="The width of this shape")
    public Double width = null;
    @Tunable(context="nogui", description="The fill color of this shape as an RGB hex string (not used for images)")
    public String fillColor = null;
    @Tunable(context="nogui", description="The opacity of this shape")
    public Double opacity = null;
    @Tunable(context="nogui", description="The border color of this shape as an RGB hex string")
    public String borderColor = null;
    @Tunable(context="nogui", description="The opacity of the shape border")
    public Double borderOpacity = null;
    @Tunable(context="nogui", description="The shape border thickness")
    public Double borderThickness = null;
    @Tunable(context="nogui", description="The type of the shape")
    public String type = null;
    @Tunable(context="nogui", description="If a custom shape, this is the text of the shape")
    public String customShape = null;

    public Map<String, String> getArgMap(TaskMonitor tm) {
        HashMap<String, String> args = new HashMap<String, String>();
        this.putIfNotNull(tm, args, "height", this.height);
        this.putIfNotNull(tm, args, "width", this.width);
        this.putIfNotNull(tm, args, "fillColor", this.getColor(this.fillColor));
        this.putIfNotNull(tm, args, "edgeColor", this.getColor(this.borderColor));
        this.putIfNotNull(tm, args, "fillOpacity", this.opacity);
        this.putIfNotNull(tm, args, "edgeOpacity", this.borderOpacity);
        this.putIfNotNull(tm, args, "edgeThickness", this.borderThickness);
        if (this.type == null) {
            this.type = "rectangle";
        }
        this.putIfNotNull(tm, args, "shapeType", this.type, this.getShapeTypes());
        if (this.type.equalsIgnoreCase(ShapeAnnotation.ShapeType.CUSTOM.toString())) {
            this.putIfNotNull(tm, args, "customShape", this.customShape);
        }
        return args;
    }

    public void update(TaskMonitor tm, Annotation ann) {
        Map argMap = ann.getArgMap();
        ShapeAnnotation sAnn = (ShapeAnnotation)ann;
        if (this.width != null || this.height != null) {
            if (this.width == null) {
                this.width = Double.valueOf((String)argMap.get("width"));
            }
            if (this.height == null) {
                this.height = Double.valueOf((String)argMap.get("height"));
            }
            sAnn.setSize(this.width.doubleValue(), this.height.doubleValue());
        }
        if (this.type != null) {
            sAnn.setShapeType(this.type);
        }
        if (this.fillColor != null) {
            sAnn.setFillColor((Paint)ColorUtil.parseColor(this.fillColor));
        }
        if (this.borderColor != null) {
            sAnn.setBorderColor((Paint)ColorUtil.parseColor(this.borderColor));
        }
        if (this.opacity != null) {
            sAnn.setFillOpacity(this.opacity.doubleValue());
        }
        if (this.borderOpacity != null) {
            sAnn.setBorderOpacity(this.borderOpacity.doubleValue());
        }
        if (this.borderThickness != null) {
            sAnn.setBorderWidth(this.borderThickness.doubleValue());
        }
        if (sAnn.getShapeType().equalsIgnoreCase("custom") && this.customShape != null) {
            sAnn.setCustomShape(this.customShape);
        }
    }

    public List<String> getShapeTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (ShapeAnnotation.ShapeType type : ShapeAnnotation.ShapeType.values()) {
            types.add(type.toString());
        }
        return types;
    }
}

