/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.util.UUID;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class RemoveAnnotationCommandTask
extends AbstractTask {
    private final AnnotationManager annotationManager;
    private final CyNetworkViewManager viewManager;
    @Tunable(context="nogui", required=true, description="The UUID or name of the annotation to be deleted")
    public String uuidOrName;

    public RemoveAnnotationCommandTask(AnnotationManager annotationManager, CyNetworkViewManager viewManager) {
        this.annotationManager = annotationManager;
        this.viewManager = viewManager;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Remove Annotation");
        UUID aUUID = null;
        String name = null;
        try {
            aUUID = UUID.fromString(this.uuidOrName);
        }
        catch (IllegalArgumentException e) {
            name = this.uuidOrName.trim();
        }
        for (CyNetworkView view : this.viewManager.getNetworkViewSet()) {
            for (Annotation annotation : this.annotationManager.getAnnotations(view)) {
                if ((aUUID == null || !annotation.getUUID().equals(aUUID)) && (name == null || !annotation.getName().equals(name))) continue;
                this.annotationManager.removeAnnotation(annotation);
                return;
            }
        }
    }
}

