/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.util.Collections;
import java.util.List;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingRenderer;
import org.cytoscape.ding.impl.cyannotator.AnnotationClipboard;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.tasks.PasteAnnotationStyleTask;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class PasteAnnotationStyleTaskFactory
implements NetworkViewTaskFactory {
    private final DingRenderer dingRenderer;
    private final AnnotationClipboard clipboard;

    public PasteAnnotationStyleTaskFactory(DingRenderer dingRenderer, AnnotationClipboard clipboard) {
        this.dingRenderer = dingRenderer;
        this.clipboard = clipboard;
    }

    public TaskIterator createTaskIterator(CyNetworkView view) {
        DRenderingEngine re = this.dingRenderer.getRenderingEngine(view);
        if (re == null) {
            return null;
        }
        CyAnnotator cyAnnotator = re.getCyAnnotator();
        List<DingAnnotation> annotations = cyAnnotator != null ? cyAnnotator.getAnnotationSelection().getSelectedAnnotations() : Collections.EMPTY_LIST;
        return new TaskIterator(new Task[]{new PasteAnnotationStyleTask(annotations, this.clipboard)});
    }

    public boolean isReady(CyNetworkView view) {
        if (this.clipboard.isEmpty()) {
            return false;
        }
        DRenderingEngine re = this.dingRenderer.getRenderingEngine(view);
        if (re == null) {
            return false;
        }
        CyAnnotator cyAnnotator = re.getCyAnnotator();
        List<DingAnnotation> annotations = cyAnnotator != null ? cyAnnotator.getAnnotationSelection().getSelectedAnnotations() : null;
        return annotations != null && !annotations.isEmpty();
    }
}

