/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.awt.Point;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.ui.AnnotationMediator;
import org.cytoscape.view.presentation.annotations.GroupAnnotation;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class EditAnnotationTask
extends AbstractTask {
    private final DingAnnotation annotation;
    private final AnnotationMediator mediator;
    private final Point location;

    public EditAnnotationTask(DingAnnotation a, AnnotationMediator mediator) {
        this(a, mediator, null);
    }

    public EditAnnotationTask(DingAnnotation a, AnnotationMediator mediator, Point location) {
        this.annotation = a;
        this.mediator = mediator;
        this.location = location;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Edit Annotation");
        if (this.annotation != null) {
            if (this.annotation instanceof GroupAnnotation) {
                tm.setStatusMessage("No annotation selected (group selected instead)!");
            } else {
                tm.setStatusMessage("Annotation: " + this.annotation.getName());
                this.mediator.editAnnotation(this.annotation, this.location);
            }
        } else {
            tm.setStatusMessage("No annotation selected!");
        }
    }
}

