/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.util.Collections;
import java.util.List;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingRenderer;
import org.cytoscape.ding.impl.cyannotator.AnnotationFactoryManager;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.tasks.DuplicateAnnotationsTask;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.ArrowAnnotation;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class DuplicateAnnotationsTaskFactory
implements NetworkViewTaskFactory {
    private final DingRenderer dingRenderer;
    private final AnnotationFactoryManager annotationFactoryManager;

    public DuplicateAnnotationsTaskFactory(DingRenderer dingRenderer, AnnotationFactoryManager annotationFactoryManager) {
        this.dingRenderer = dingRenderer;
        this.annotationFactoryManager = annotationFactoryManager;
    }

    public TaskIterator createTaskIterator(CyNetworkView view) {
        DRenderingEngine re = this.dingRenderer.getRenderingEngine(view);
        if (re == null) {
            return null;
        }
        CyAnnotator cyAnnotator = re.getCyAnnotator();
        List<DingAnnotation> annotations = cyAnnotator != null ? cyAnnotator.getAnnotationSelection().getSelectedAnnotations() : Collections.EMPTY_LIST;
        return new TaskIterator(new Task[]{new DuplicateAnnotationsTask(re, annotations, this.annotationFactoryManager)});
    }

    public boolean isReady(CyNetworkView view) {
        DRenderingEngine re = this.dingRenderer.getRenderingEngine(view);
        if (re == null) {
            return false;
        }
        CyAnnotator cyAnnotator = re.getCyAnnotator();
        List<DingAnnotation> annotations = cyAnnotator.getAnnotationSelection().getSelectedAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            for (DingAnnotation a : annotations) {
                if (a instanceof ArrowAnnotation) {
                    Annotation src = ((ArrowAnnotation)a).getSource();
                    if (src == null || annotations.contains(src)) continue;
                    continue;
                }
                return true;
            }
        }
        return false;
    }
}

