/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Shape;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import org.cytoscape.ding.impl.cyannotator.annotations.GraphicsUtilities;
import org.cytoscape.ding.impl.cyannotator.annotations.ShapeAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.dialogs.AbstractAnnotationEditor;
import org.cytoscape.ding.impl.cyannotator.utils.ShapeIcon;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.ColorButton;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;

public class ShapeAnnotationEditor
extends AbstractAnnotationEditor<ShapeAnnotation> {
    private JLabel borderWidthLabel;
    private JLabel shapeLabel;
    private JLabel fillColorLabel;
    private JLabel fillOpacityLabel;
    private JLabel borderColorLabel;
    private JLabel borderOpacityLabel;
    private JLabel rotationLabel;
    private JList<String> shapeList;
    private JCheckBox fillColorCheck;
    private ColorButton fillColorButton;
    private ColorButton borderColorButton;
    private JSlider fillOpacitySlider;
    private JSlider borderOpacitySlider;
    private JComboBox<Integer> borderWidthCombo;
    private JSlider rotationSlider;
    private Shape customShape;

    public ShapeAnnotationEditor(AnnotationFactory<ShapeAnnotation> factory, CyServiceRegistrar serviceRegistrar) {
        super(factory, serviceRegistrar);
    }

    @Override
    public void setAnnotation(ShapeAnnotation annotation) {
        super.setAnnotation(annotation);
        if (annotation instanceof ShapeAnnotationImpl && ((ShapeAnnotationImpl)annotation).getShapeTypeEnum() == ShapeAnnotation.ShapeType.CUSTOM) {
            this.customShape = ((ShapeAnnotationImpl)annotation).getShape();
        }
    }

    @Override
    public void doUpdate() {
        if (this.annotation != null) {
            this.getShapeList().setSelectedValue(((ShapeAnnotation)this.annotation).getShapeType(), true);
            Color fillColor = ((ShapeAnnotation)this.annotation).getFillColor() instanceof Color ? (Color)((ShapeAnnotation)this.annotation).getFillColor() : null;
            int fillOpacity = (int)((ShapeAnnotation)this.annotation).getFillOpacity();
            this.getFillColorCheck().setSelected(((ShapeAnnotation)this.annotation).getFillColor() != null);
            this.getFillColorButton().setColor(fillColor != null ? fillColor : Color.BLACK);
            this.getFillOpacitySlider().setValue(fillOpacity);
            int borderWidth = (int)((ShapeAnnotation)this.annotation).getBorderWidth();
            Color borderColor = ((ShapeAnnotation)this.annotation).getBorderColor() instanceof Color ? (Color)((ShapeAnnotation)this.annotation).getBorderColor() : null;
            int borderOpacity = (int)((ShapeAnnotation)this.annotation).getBorderOpacity();
            this.getBorderColorButton().setColor(borderColor != null ? borderColor : Color.BLACK);
            this.getBorderOpacitySlider().setValue(borderOpacity);
            ComboBoxModel<Integer> model = this.getBorderWidthCombo().getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                if (borderWidth != (Integer)model.getElementAt(i)) continue;
                this.getBorderWidthCombo().setSelectedIndex(i);
                break;
            }
            double rotation = ((ShapeAnnotation)this.annotation).getRotation();
            this.getRotationSlider().setValue((int)rotation);
        }
        this.updateEnabled();
    }

    @Override
    public void apply(ShapeAnnotation annotation) {
        if (annotation != null) {
            String shapeType = this.getShapeList().getSelectedValue();
            if (ShapeAnnotation.ShapeType.CUSTOM.shapeName().equals(shapeType)) {
                annotation.setCustomShape(this.customShape);
            } else {
                annotation.setShapeType(shapeType);
            }
            annotation.setBorderWidth((double)((Integer)this.getBorderWidthCombo().getModel().getSelectedItem()).intValue());
            annotation.setFillColor(this.getFillColorCheck().isSelected() ? this.getFillColorButton().getColor() : null);
            annotation.setFillOpacity((double)this.getFillOpacitySlider().getValue());
            annotation.setBorderColor((Paint)this.getBorderColorButton().getColor());
            annotation.setBorderOpacity((double)this.getBorderOpacitySlider().getValue());
            annotation.setRotation((double)this.getRotationSlider().getValue());
        }
    }

    @Override
    protected void init() {
        this.borderWidthLabel = new JLabel("Border Width:");
        this.shapeLabel = new JLabel("Shape:");
        this.fillColorLabel = new JLabel("Fill Color:");
        this.fillOpacityLabel = new JLabel("Fill Opacity:");
        this.borderColorLabel = new JLabel("Border Color:");
        this.borderOpacityLabel = new JLabel("Border Opacity:");
        this.rotationLabel = ShapeAnnotationEditor.createRotationLabel();
        JScrollPane scrollPane = new JScrollPane(this.getShapeList(), 20, 31);
        JSeparator sep1 = new JSeparator();
        JSeparator sep2 = new JSeparator();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setHorizontalGroup(layout.createSequentialGroup().addGap(0, 20, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.shapeLabel).addComponent(scrollPane)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addComponent(this.fillColorLabel).addComponent(this.fillOpacityLabel).addComponent(this.borderWidthLabel).addComponent(this.borderColorLabel).addComponent(this.borderOpacityLabel).addComponent(this.rotationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.getFillColorCheck()).addComponent((Component)this.getFillColorButton())).addComponent(this.getFillOpacitySlider(), 100, 140, 140).addComponent(sep1, -1, -1, Short.MAX_VALUE).addComponent(this.getBorderWidthCombo(), -2, -1, -2).addComponent((Component)this.getBorderColorButton()).addComponent(this.getBorderOpacitySlider(), 100, 140, 140).addComponent(sep2, -1, -1, Short.MAX_VALUE).addComponent(this.getRotationSlider(), 100, 140, 140))).addGap(0, 20, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.shapeLabel).addComponent(scrollPane, -1, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.fillColorLabel).addComponent(this.getFillColorCheck()).addComponent((Component)this.getFillColorButton(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.fillOpacityLabel).addComponent(this.getFillOpacitySlider(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(sep1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.borderWidthLabel).addComponent(this.getBorderWidthCombo(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.borderColorLabel).addComponent((Component)this.getBorderColorButton(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.borderOpacityLabel).addComponent(this.getBorderOpacitySlider(), -2, -1, -2)).addComponent(sep2, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.rotationLabel).addComponent(this.getRotationSlider(), -2, -1, -2)))));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.shapeLabel, this.fillColorLabel, this.fillOpacityLabel, this.borderColorLabel, this.borderOpacityLabel, this.borderWidthLabel, this.rotationLabel});
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.getFillColorCheck(), this.getFillColorButton(), this.getFillOpacitySlider(), this.getBorderColorButton(), this.getBorderOpacitySlider(), this.getBorderWidthCombo(), this.getRotationSlider()});
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{scrollPane});
    }

    private JList<String> getShapeList() {
        if (this.shapeList == null) {
            List<String> typeList = GraphicsUtilities.getSupportedShapes();
            typeList.remove(ShapeAnnotation.ShapeType.CUSTOM.shapeName());
            this.shapeList = new JList<String>(new Vector<String>(typeList));
            this.shapeList.setSelectionMode(0);
            this.shapeList.setCellRenderer(new DefaultListCellRenderer(){
                final Map<String, ShapeIcon> icons = new HashMap<String, ShapeIcon>();
                final int ICON_SIZE = 12;
                {
                    this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                }

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Shape shape;
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    String shapeName = "" + value;
                    ShapeIcon shapeIcon = this.icons.get(shapeName);
                    if (shapeIcon == null && (shape = GraphicsUtilities.getShape(shapeName, 0.0, 0.0, 12.0, 12.0)) != null) {
                        shapeIcon = new ShapeIcon(shape, 12, 12);
                        this.icons.put(shapeName, shapeIcon);
                    }
                    this.setIcon(shapeIcon);
                    return this;
                }
            });
            this.shapeList.setFont(this.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            if (this.shapeList.getModel().getSize() > 0) {
                this.shapeList.setSelectedIndex(0);
            }
            this.shapeList.addListSelectionListener(evt -> this.apply());
        }
        return this.shapeList;
    }

    private JCheckBox getFillColorCheck() {
        if (this.fillColorCheck == null) {
            this.fillColorCheck = new JCheckBox();
            this.fillColorCheck.addActionListener(evt -> {
                this.updateEnabled();
                this.apply();
            });
        }
        return this.fillColorCheck;
    }

    private ColorButton getFillColorButton() {
        if (this.fillColorButton == null) {
            this.fillColorButton = new ColorButton(this.serviceRegistrar, null, (PaletteType)BrewerType.ANY, Color.GRAY, false);
            this.fillColorButton.setToolTipText("Select fill color...");
            this.fillColorButton.addPropertyChangeListener("color", evt -> this.apply());
        }
        return this.fillColorButton;
    }

    private ColorButton getBorderColorButton() {
        if (this.borderColorButton == null) {
            this.borderColorButton = new ColorButton(this.serviceRegistrar, null, (PaletteType)BrewerType.ANY, Color.GRAY, false);
            this.borderColorButton.setToolTipText("Select border color...");
            this.borderColorButton.addPropertyChangeListener("color", evt -> this.apply());
        }
        return this.borderColorButton;
    }

    private JSlider getFillOpacitySlider() {
        if (this.fillOpacitySlider == null) {
            this.fillOpacitySlider = new JSlider(0, 100, 100);
            this.fillOpacitySlider.setMajorTickSpacing(100);
            this.fillOpacitySlider.setMinorTickSpacing(25);
            this.fillOpacitySlider.setPaintTicks(true);
            this.fillOpacitySlider.setPaintLabels(true);
            this.fillOpacitySlider.addChangeListener(evt -> this.apply());
        }
        return this.fillOpacitySlider;
    }

    private JSlider getBorderOpacitySlider() {
        if (this.borderOpacitySlider == null) {
            this.borderOpacitySlider = new JSlider(0, 100, 100);
            this.borderOpacitySlider.setMajorTickSpacing(100);
            this.borderOpacitySlider.setMinorTickSpacing(25);
            this.borderOpacitySlider.setPaintTicks(true);
            this.borderOpacitySlider.setPaintLabels(true);
            this.borderOpacitySlider.addChangeListener(evt -> this.apply());
        }
        return this.borderOpacitySlider;
    }

    private JComboBox<Integer> getBorderWidthCombo() {
        if (this.borderWidthCombo == null) {
            this.borderWidthCombo = new JComboBox<Integer>(new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13});
            this.borderWidthCombo.setSelectedIndex(1);
            this.borderWidthCombo.addActionListener(evt -> {
                this.updateEnabled();
                this.apply();
            });
        }
        return this.borderWidthCombo;
    }

    private JSlider getRotationSlider() {
        if (this.rotationSlider == null) {
            this.rotationSlider = this.createRotationSlider();
        }
        return this.rotationSlider;
    }

    private void updateEnabled() {
        boolean enabled = this.getFillColorCheck().isSelected();
        this.getFillColorButton().setEnabled(enabled);
        this.getFillOpacitySlider().setEnabled(enabled);
        this.fillOpacityLabel.setEnabled(enabled);
        int borderWidth = (Integer)this.borderWidthCombo.getSelectedItem();
        boolean enabled2 = borderWidth > 0;
        this.borderColorLabel.setEnabled(enabled2);
        this.getBorderColorButton().setEnabled(enabled2);
        this.borderOpacityLabel.setEnabled(enabled2);
        this.getBorderOpacitySlider().setEnabled(enabled2);
    }
}

