/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.dialogs;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.cytoscape.cg.model.AbstractURLImageCustomGraphics;
import org.cytoscape.cg.model.BitmapCustomGraphics;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.model.SVGCustomGraphics;
import org.cytoscape.cg.util.CustomGraphicsBrowser;
import org.cytoscape.cg.util.ImageCustomGraphicsSelector;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.annotations.ImageAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.dialogs.AbstractAnnotationDialog;
import org.cytoscape.ding.impl.cyannotator.utils.ViewUtils;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadImageDialog
extends AbstractAnnotationDialog<ImageAnnotationImpl> {
    private static final String NAME = "Image";
    private static final String UNDO_LABEL = "Create Image Annotation";
    private JTabbedPane tabbedPane;
    private JFileChooser fileChooser;
    private ImageCustomGraphicsSelector imageSelector;
    private final CyServiceRegistrar serviceRegistrar;
    private static File lastDirectory;
    private static final Logger logger;

    public LoadImageDialog(DRenderingEngine re, Point2D start, Window owner, CyServiceRegistrar serviceRegistrar) {
        super(NAME, re, start, owner);
        this.serviceRegistrar = serviceRegistrar;
        this.setTitle("Select an Image");
        this.setResizable(true);
        this.getTabbedPane().addTab("From File", this.getFileChooser());
        this.getTabbedPane().addTab("From Image Browser", (Component)this.getImageSelector());
        this.pack();
    }

    @Override
    protected JTabbedPane createControlPanel() {
        return this.getTabbedPane();
    }

    @Override
    protected ImageAnnotationImpl getPreviewAnnotation() {
        return null;
    }

    @Override
    protected int getPreviewWidth() {
        return 0;
    }

    @Override
    protected int getPreviewHeight() {
        return 0;
    }

    @Override
    protected void apply() {
        Component selectedComp = this.getTabbedPane().getSelectedComponent();
        try {
            if (selectedComp == this.getFileChooser()) {
                File file = this.fileChooser.getSelectedFile();
                this.annotation = this.createAnnotation(file);
                if (file.getParentFile().isDirectory()) {
                    lastDirectory = file.getParentFile();
                }
            } else {
                CyCustomGraphics cg = this.getImageSelector().getSelectedValue();
                this.annotation = this.createAnnotation(cg);
            }
            if (this.annotation != null) {
                Point2D nodePoint = this.re.getTransform().getNodeCoordinates(this.startingLocation);
                double w = ((ImageAnnotationImpl)this.annotation).getWidth();
                double h = ((ImageAnnotationImpl)this.annotation).getHeight();
                ((ImageAnnotationImpl)this.annotation).setLocation(nodePoint.getX() - w / 2.0, nodePoint.getY() - h / 2.0);
                ((ImageAnnotationImpl)this.annotation).update();
                this.cyAnnotator.clearSelectedAnnotations();
                ViewUtils.selectAnnotation(this.re, this.annotation);
            }
        }
        catch (Exception ex) {
            logger.warn("Unable to load the selected image", (Throwable)ex);
        }
    }

    @Override
    protected JButton getApplyButton() {
        if (this.applyButton == null) {
            this.applyButton = new JButton(new AbstractAction("Insert"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LoadImageDialog.this.apply();
                    LoadImageDialog.this.dispose();
                }
            });
        }
        return this.applyButton;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane(1);
        }
        return this.tabbedPane;
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(lastDirectory);
            this.fileChooser.setControlButtonsAreShown(false);
            this.fileChooser.setCurrentDirectory(null);
            this.fileChooser.setDialogTitle("");
            this.fileChooser.setAcceptAllFileFilterUsed(false);
            this.fileChooser.addChoosableFileFilter(new ImageFilter());
        }
        return this.fileChooser;
    }

    private ImageCustomGraphicsSelector getImageSelector() {
        if (this.imageSelector == null) {
            CustomGraphicsBrowser cgBrowser = new CustomGraphicsBrowser(this.serviceRegistrar);
            this.imageSelector = new ImageCustomGraphicsSelector(cgBrowser, this.serviceRegistrar);
            this.imageSelector.addActionListener(evt -> this.getApplyButton().doClick());
        }
        return this.imageSelector;
    }

    private ImageAnnotationImpl createAnnotation(File file) throws IOException {
        ImageAnnotationImpl annotation;
        CustomGraphicsManager cgManager = (CustomGraphicsManager)this.serviceRegistrar.getService(CustomGraphicsManager.class);
        String ext = FilenameUtils.getExtension((String)file.getName());
        URL url = file.toURI().toURL();
        if (ext.equalsIgnoreCase("svg")) {
            StringBuilder sb = new StringBuilder();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));){
                String line = null;
                while ((line = in.readLine()) != null) {
                    sb.append(line + "\n");
                }
            }
            String svg = sb.toString();
            if (svg.isBlank()) {
                return null;
            }
            this.cyAnnotator.markUndoEdit(UNDO_LABEL);
            annotation = new ImageAnnotationImpl(this.re, (double)((int)this.startingLocation.getX()), (double)((int)this.startingLocation.getY()), 0.0, url, svg, this.re.getZoom(), cgManager);
        } else {
            BufferedImage image = ImageIO.read(file);
            this.cyAnnotator.markUndoEdit(UNDO_LABEL);
            annotation = new ImageAnnotationImpl(this.re, (double)((int)this.startingLocation.getX()), (double)((int)this.startingLocation.getY()), 0.0, url, image, this.re.getZoom(), cgManager);
        }
        return annotation;
    }

    private ImageAnnotationImpl createAnnotation(CyCustomGraphics<?> cg) {
        ImageAnnotationImpl annotation = null;
        CustomGraphicsManager cgManager = (CustomGraphicsManager)this.serviceRegistrar.getService(CustomGraphicsManager.class);
        if (cg instanceof SVGCustomGraphics) {
            this.cyAnnotator.markUndoEdit(UNDO_LABEL);
            annotation = new ImageAnnotationImpl(this.re, (AbstractURLImageCustomGraphics<?>)((SVGCustomGraphics)cg), (int)this.startingLocation.getX(), (int)this.startingLocation.getY(), 0.0, this.re.getZoom(), cgManager);
        } else if (cg instanceof BitmapCustomGraphics) {
            this.cyAnnotator.markUndoEdit(UNDO_LABEL);
            annotation = new ImageAnnotationImpl(this.re, (AbstractURLImageCustomGraphics<?>)((BitmapCustomGraphics)cg), (int)this.startingLocation.getX(), (int)this.startingLocation.getY(), 0.0, this.re.getZoom(), cgManager);
        }
        return annotation;
    }

    static {
        logger = LoggerFactory.getLogger(LoadImageDialog.class);
    }

    private class ImageFilter
    extends FileFilter {
        private ImageFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String ext = FilenameUtils.getExtension((String)f.getName()).toLowerCase();
            if (!ext.isEmpty()) {
                return ext.equals("tiff") || ext.equals("tif") || ext.equals("jpeg") || ext.equals("jpg") || ext.equals("png") || ext.equals("gif") || ext.equals("svg");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Just Images";
        }
    }
}

