/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.dialogs;

import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JSeparator;
import org.cytoscape.ding.impl.cyannotator.dialogs.AbstractAnnotationEditor;
import org.cytoscape.ding.impl.cyannotator.dialogs.ShapeAnnotationEditor;
import org.cytoscape.ding.impl.cyannotator.dialogs.TextAnnotationEditor;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.annotations.BoundedTextAnnotation;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;
import org.cytoscape.view.presentation.annotations.TextAnnotation;

public class BoundedTextAnnotationEditor
extends AbstractAnnotationEditor<BoundedTextAnnotation> {
    private TextAnnotationEditor textAnnotationEditor;
    private ShapeAnnotationEditor shapeAnnotationEditor;

    public BoundedTextAnnotationEditor(AnnotationFactory<BoundedTextAnnotation> factory, CyServiceRegistrar serviceRegistrar) {
        super(factory, serviceRegistrar);
    }

    @Override
    public void setAnnotation(BoundedTextAnnotation annotation) {
        if (!Objects.equals(this.annotation, annotation)) {
            this.annotation = annotation;
            if (annotation instanceof TextAnnotation) {
                this.getTextAnnotationEditor().setAnnotation((TextAnnotation)annotation);
            }
            if (annotation instanceof ShapeAnnotation) {
                this.getShapeAnnotationEditor().setAnnotation((ShapeAnnotation)annotation);
            }
        }
    }

    @Override
    protected void update() {
        this.getTextAnnotationEditor().update();
        this.getShapeAnnotationEditor().update();
    }

    @Override
    protected void doUpdate() {
    }

    @Override
    protected void apply() {
        this.getTextAnnotationEditor().apply();
        this.getShapeAnnotationEditor().apply();
    }

    @Override
    public void apply(BoundedTextAnnotation annotation) {
        if (annotation instanceof TextAnnotation) {
            this.getTextAnnotationEditor().apply((TextAnnotation)annotation);
        }
        this.getShapeAnnotationEditor().apply((ShapeAnnotation)annotation);
    }

    @Override
    protected void init() {
        JSeparator sep = new JSeparator();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGap(0, 20, Short.MAX_VALUE).addComponent(this.getTextAnnotationEditor(), -1, -1, Short.MAX_VALUE).addComponent(sep, -1, -1, Short.MAX_VALUE).addComponent(this.getShapeAnnotationEditor(), -1, -1, Short.MAX_VALUE).addGap(0, 20, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getTextAnnotationEditor(), -2, -1, -2).addComponent(sep, -2, -1, -2).addComponent(this.getShapeAnnotationEditor(), -2, -1, -2));
    }

    protected TextAnnotationEditor getTextAnnotationEditor() {
        if (this.textAnnotationEditor == null) {
            this.textAnnotationEditor = new TextAnnotationEditor(null, false, this.serviceRegistrar);
            this.textAnnotationEditor.init();
        }
        return this.textAnnotationEditor;
    }

    protected ShapeAnnotationEditor getShapeAnnotationEditor() {
        if (this.shapeAnnotationEditor == null) {
            this.shapeAnnotationEditor = new ShapeAnnotationEditor(null, this.serviceRegistrar);
            this.shapeAnnotationEditor.init();
        }
        return this.shapeAnnotationEditor;
    }
}

