/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.annotations;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Shape;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.annotations.AbstractAnnotation;
import org.cytoscape.ding.impl.cyannotator.annotations.GraphicsUtilities;
import org.cytoscape.ding.impl.cyannotator.utils.ViewUtils;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;

public class ShapeAnnotationImpl
extends AbstractAnnotation
implements ShapeAnnotation {
    private ShapeAnnotation.ShapeType shapeType;
    private double borderWidth = 1.0;
    private Paint borderColor = Color.BLACK;
    private Paint fillColor;
    private double borderOpacity = 100.0;
    private double fillOpacity = 100.0;
    private Shape shape;
    protected double factor = 1.0;

    public ShapeAnnotationImpl(DRenderingEngine re, double width, double height, boolean usedForPreviews) {
        super(re, usedForPreviews);
        this.setSize(width, height);
        this.shapeType = ShapeAnnotation.ShapeType.RECTANGLE;
        this.borderWidth = 1.0;
    }

    public ShapeAnnotationImpl(ShapeAnnotationImpl c, double width, double height, boolean usedForPreviews) {
        super(c, usedForPreviews);
        this.setSize(width, height);
        this.width = width;
        this.height = height;
        this.shapeType = GraphicsUtilities.getShapeType(c.getShapeType());
        this.borderColor = c.getBorderColor();
        this.borderWidth = c.getBorderWidth();
        this.fillColor = c.getFillColor();
        this.name = c.getName() != null ? c.getName() : this.getDefaultName();
        this.shape = this.shapeType == ShapeAnnotation.ShapeType.CUSTOM ? GraphicsUtilities.copyCustomShape(c.getShape(), width, height) : GraphicsUtilities.getShape(this.shapeType.shapeName(), 0.0, 0.0, width, height);
    }

    public ShapeAnnotationImpl(DRenderingEngine re, double x, double y, double rotation, ShapeAnnotation.ShapeType shapeType, double width, double height, Paint fillColor, Paint edgeColor, float edgeThickness) {
        super(re, x, y, rotation);
        this.shapeType = shapeType;
        this.fillColor = fillColor;
        this.borderColor = edgeColor;
        this.borderWidth = edgeThickness;
        this.width = width;
        this.height = height;
        this.shape = GraphicsUtilities.getShape(shapeType.shapeName(), 0.0, 0.0, width, height);
    }

    public ShapeAnnotationImpl(DRenderingEngine re, Map<String, String> argMap) {
        super(re, argMap);
        double zoom = ShapeAnnotationImpl.getLegacyZoom(argMap);
        this.width = ViewUtils.getDouble(argMap, "width", 100.0) / zoom;
        this.height = ViewUtils.getDouble(argMap, "height", 100.0) / zoom;
        this.fillColor = ViewUtils.getColor(argMap, "fillColor", null);
        this.fillOpacity = ViewUtils.getDouble(argMap, "fillOpacity", 100.0);
        this.borderWidth = ViewUtils.getDouble(argMap, "edgeThickness", 1.0) / zoom;
        this.borderColor = ViewUtils.getColor(argMap, "edgeColor", Color.BLACK);
        this.borderOpacity = ViewUtils.getDouble(argMap, "edgeOpacity", 100.0);
        this.shapeType = GraphicsUtilities.getShapeType(argMap, "shapeType", ShapeAnnotation.ShapeType.RECTANGLE);
        if (this.shapeType != ShapeAnnotation.ShapeType.CUSTOM) {
            this.shape = GraphicsUtilities.getShape(this.shapeType.shapeName(), 0.0, 0.0, this.width, this.height);
        } else if (argMap.containsKey("customShape")) {
            this.shape = GraphicsUtilities.deserializeShape(argMap.get("customShape"));
        }
    }

    @Override
    public Class<? extends Annotation> getType() {
        return ShapeAnnotation.class;
    }

    @Override
    public Map<String, String> getArgMap() {
        Map<String, String> argMap = super.getArgMap();
        argMap.put("type", ShapeAnnotation.class.getName());
        if (this.fillColor != null) {
            argMap.put("fillColor", ViewUtils.convertColor(this.fillColor));
        }
        argMap.put("fillOpacity", Double.toString(this.fillOpacity));
        if (this.borderColor != null) {
            argMap.put("edgeColor", ViewUtils.convertColor(this.borderColor));
        }
        argMap.put("edgeThickness", Double.toString(this.borderWidth));
        argMap.put("edgeOpacity", Double.toString(this.borderOpacity));
        if (this.shapeType != null) {
            argMap.put("shapeType", this.shapeType.name());
            if (this.shapeType.equals((Object)ShapeAnnotation.ShapeType.CUSTOM) && this.shape != null) {
                argMap.put("customShape", GraphicsUtilities.serializeShape(this.shape));
            }
        }
        argMap.put("width", Double.toString(this.width));
        argMap.put("height", Double.toString(this.height));
        return argMap;
    }

    @Override
    public void setStyle(Map<String, String> argMap) {
        if (argMap != null) {
            double zoom = ShapeAnnotationImpl.getLegacyZoom(argMap);
            this.setFillColor(ViewUtils.getColor(argMap, "fillColor", null));
            this.setFillOpacity(ViewUtils.getDouble(argMap, "fillOpacity", 100.0));
            this.setBorderWidth(ViewUtils.getDouble(argMap, "edgeThickness", 1.0) / zoom);
            this.setBorderColor(ViewUtils.getColor(argMap, "edgeColor", Color.BLACK));
            this.setBorderOpacity(ViewUtils.getDouble(argMap, "edgeOpacity", 100.0));
            this.setShapeType(GraphicsUtilities.getShapeType(argMap, "shapeType", ShapeAnnotation.ShapeType.RECTANGLE));
        }
    }

    public List<String> getSupportedShapes() {
        return GraphicsUtilities.getSupportedShapes();
    }

    public Shape getShape() {
        return this.shape;
    }

    public String getShapeType() {
        return this.shapeType.shapeName();
    }

    public ShapeAnnotation.ShapeType getShapeTypeEnum() {
        return this.shapeType;
    }

    public void setShapeType(ShapeAnnotation.ShapeType type) {
        if (this.shapeType != type) {
            ShapeAnnotation.ShapeType oldValue = this.shapeType;
            this.shapeType = type;
            if (this.shapeType != ShapeAnnotation.ShapeType.CUSTOM) {
                this.shape = GraphicsUtilities.getShape(this.shapeType.shapeName(), 0.0, 0.0, this.width, this.height);
            }
            this.update();
            this.firePropertyChange("shapeType", oldValue, type);
        }
    }

    public void setShapeType(String type) {
        ShapeAnnotation.ShapeType shapeType = this.getShapeFromString(type);
        if (!Objects.equals(this.shapeType, shapeType)) {
            this.setShapeType(shapeType);
        }
    }

    public double getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(double width) {
        if (this.borderWidth != width) {
            double oldValue = this.borderWidth;
            this.borderWidth = width;
            this.update();
            this.firePropertyChange("borderWidth", oldValue, width);
        }
    }

    public Paint getBorderColor() {
        return this.borderColor;
    }

    public double getBorderOpacity() {
        return this.borderOpacity;
    }

    public Paint getFillColor() {
        return this.fillColor;
    }

    public double getFillOpacity() {
        return this.fillOpacity;
    }

    public void setBorderColor(Paint color) {
        if (!Objects.equals(this.borderColor, color)) {
            Paint oldValue = this.borderColor;
            this.borderColor = color;
            this.update();
            this.firePropertyChange("borderColor", oldValue, color);
        }
    }

    public void setBorderOpacity(double opacity) {
        if (this.borderOpacity != opacity) {
            double oldValue = this.borderOpacity;
            this.borderOpacity = opacity;
            this.update();
            this.firePropertyChange("borderOpacity", oldValue, opacity);
        }
    }

    public void setFillColor(Paint color) {
        if (!Objects.equals(this.fillColor, color)) {
            Paint oldValue = this.fillColor;
            this.fillColor = color;
            this.update();
            this.firePropertyChange("fillColor", oldValue, color);
        }
    }

    public void setFillOpacity(double opacity) {
        if (this.fillOpacity != opacity) {
            double oldValue = this.fillOpacity;
            this.fillOpacity = opacity;
            this.update();
            this.firePropertyChange("fillOpacity", oldValue, opacity);
        }
    }

    public void setCustomShape(String stringShape) {
        Shape shape = GraphicsUtilities.deserializeShape(stringShape);
        this.setCustomShape(shape);
    }

    public void setCustomShape(Shape shape) {
        if (!Objects.equals(this.shape, shape)) {
            Shape oldValue = this.shape;
            this.shapeType = ShapeAnnotation.ShapeType.CUSTOM;
            this.shape = shape;
            this.update();
            this.firePropertyChange("shape", oldValue, shape);
        }
    }

    @Override
    public void paint(Graphics g, boolean showSelection) {
        super.paint(g, showSelection);
        if (this.borderOpacity == 0.0 && this.fillOpacity == 0.0) {
            return;
        }
        GraphicsUtilities.drawShape(g, this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getRotation(), this, false);
    }

    private ShapeAnnotation.ShapeType getShapeFromString(String shapeName) {
        for (ShapeAnnotation.ShapeType type : ShapeAnnotation.ShapeType.values()) {
            if (!type.shapeName().equals(shapeName)) continue;
            return type;
        }
        return ShapeAnnotation.ShapeType.RECTANGLE;
    }
}

