/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cytoscape.ding.impl.cyannotator.AnnotationNode;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.GroupAnnotation;

public class AnnotationTree {
    private AnnotationNode foregroundTree;
    private AnnotationNode backgroundTree;
    private Map<Annotation, AnnotationNode> foregroundLookup;
    private Map<Annotation, AnnotationNode> backgroundLookup;
    private CyAnnotator cyAnnotator;

    private AnnotationTree(AnnotationNode foregroundTree, AnnotationNode backgroundTree) {
        this.foregroundTree = foregroundTree;
        this.backgroundTree = backgroundTree;
    }

    public AnnotationNode getForegroundRoot() {
        return this.foregroundTree;
    }

    public AnnotationNode getBackgroundRoot() {
        return this.backgroundTree;
    }

    public AnnotationNode getRoot(String canvas) {
        switch (canvas) {
            case "foreground": {
                return this.foregroundTree;
            }
            case "background": {
                return this.backgroundTree;
            }
        }
        return null;
    }

    public AnnotationNode get(String canvas, Annotation a) {
        switch (canvas) {
            case "foreground": {
                return this.foregroundLookup.get(a);
            }
            case "background": {
                return this.backgroundLookup.get(a);
            }
        }
        return null;
    }

    public void shift(Shift shift, String canvas, Collection<? extends Annotation> annotations) {
        this.groupByParent(canvas, annotations).forEach((parent, childrenToShift) -> parent.shift(shift, (List<AnnotationNode>)childrenToShift));
    }

    public boolean shiftAllowed(Shift shift, String canvas, Collection<? extends Annotation> annotations) {
        if (annotations.isEmpty()) {
            return false;
        }
        for (Map.Entry<AnnotationNode, List<AnnotationNode>> entry : this.groupByParent(canvas, annotations).entrySet()) {
            List<AnnotationNode> childrenToShift;
            AnnotationNode parent = entry.getKey();
            if (parent.shiftAllowed(shift, childrenToShift = entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private Map<AnnotationNode, List<AnnotationNode>> groupByParent(String canvas, Collection<? extends Annotation> annotations) {
        return annotations.stream().map(a -> this.get(canvas, (Annotation)a)).filter(a -> a != null).collect(Collectors.groupingBy(AnnotationNode::getParent));
    }

    public void resetZOrder() {
        if (this.cyAnnotator == null) {
            return;
        }
        int[] zf = new int[]{0};
        this.foregroundTree.depthFirstTraversal(node -> {
            DingAnnotation da = (DingAnnotation)node.getAnnotation();
            int n = zf[0];
            zf[0] = n + 1;
            da.setZOrder(n);
        });
        int[] zb = new int[]{0};
        this.backgroundTree.depthFirstTraversal(node -> {
            DingAnnotation da = (DingAnnotation)node.getAnnotation();
            if (!(da instanceof GroupAnnotation)) {
                int n = zb[0];
                zb[0] = n + 1;
                da.setZOrder(n);
            }
        });
    }

    public static AnnotationTree buildTree(Collection<? extends Annotation> annotations, CyAnnotator cyAnnotator) {
        Map<String, List<Annotation>> layers = AnnotationTree.separateByLayers(annotations, true);
        AnnotationNode foregroundTree = new AnnotationNode(null);
        AnnotationNode backgroundTree = new AnnotationNode(null);
        HashMap<Annotation, AnnotationNode> foregroundNodes = new HashMap<Annotation, AnnotationNode>();
        HashMap<Annotation, AnnotationNode> backgroundNodes = new HashMap<Annotation, AnnotationNode>();
        for (Annotation a : layers.get("foreground")) {
            AnnotationTree.addNode(a, foregroundTree, foregroundNodes, cyAnnotator);
        }
        for (Annotation a : layers.get("background")) {
            AnnotationTree.addNode(a, backgroundTree, backgroundNodes, cyAnnotator);
        }
        foregroundTree.removeEmptyGroups();
        backgroundTree.removeEmptyGroups();
        AnnotationTree head = new AnnotationTree(foregroundTree, backgroundTree);
        head.foregroundLookup = foregroundNodes;
        head.backgroundLookup = backgroundNodes;
        head.cyAnnotator = cyAnnotator;
        return head;
    }

    private static void addNode(Annotation a, AnnotationNode root, Map<Annotation, AnnotationNode> all, CyAnnotator cyAnnotator) {
        if (!(a instanceof DingAnnotation)) {
            return;
        }
        AnnotationNode n = all.computeIfAbsent(a, AnnotationNode::new);
        DingAnnotation groupParent = (DingAnnotation)((DingAnnotation)a).getGroupParent();
        if (groupParent != null && cyAnnotator.contains(groupParent)) {
            AnnotationNode pn = all.get(groupParent);
            if (pn == null) {
                pn = new AnnotationNode(groupParent);
                all.put(groupParent, pn);
                AnnotationTree.addNode(groupParent, root, all, cyAnnotator);
            }
            if (pn.getIndex(n) < 0) {
                pn.add(n);
            }
        } else if (root.getIndex(n) < 0) {
            root.add(n);
        }
    }

    private static Map<String, List<Annotation>> separateByLayers(Collection<? extends Annotation> list, boolean includeGroups) {
        HashMap<String, List<Annotation>> map = new HashMap<String, List<Annotation>>();
        map.put("foreground", new ArrayList());
        map.put("background", new ArrayList());
        if (list != null) {
            for (Annotation annotation : list) {
                if (annotation instanceof GroupAnnotation) {
                    ((List)map.get("foreground")).add(annotation);
                    ((List)map.get("background")).add(annotation);
                    continue;
                }
                List set = (List)map.get(annotation.getCanvasName());
                if (set == null) continue;
                set.add(annotation);
            }
        }
        AnnotationTree.sortAnnotations((List)map.get("foreground"));
        AnnotationTree.sortAnnotations((List)map.get("background"));
        return map;
    }

    public static boolean containsCycle(Collection<DingAnnotation> annotations, Collection<DingAnnotation> moreAnnotations) {
        HashSet<DingAnnotation> annotationsRemaining = new HashSet<DingAnnotation>(annotations);
        if (moreAnnotations != null) {
            annotationsRemaining.addAll(moreAnnotations);
        }
        while (!annotationsRemaining.isEmpty()) {
            DingAnnotation start = (DingAnnotation)annotationsRemaining.iterator().next();
            if (!AnnotationTree.containsCycle(start, annotationsRemaining, new HashSet<Annotation>())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsCycle(Collection<DingAnnotation> annotations, DingAnnotation extraAnnotation) {
        return AnnotationTree.containsCycle(annotations, Collections.singleton(extraAnnotation));
    }

    public static boolean containsCycle(Collection<DingAnnotation> annotations) {
        return AnnotationTree.containsCycle(annotations, (Collection<DingAnnotation>)null);
    }

    private static boolean containsCycle(DingAnnotation a, Collection<DingAnnotation> annotations, Set<Annotation> marked) {
        if (!marked.add(a)) {
            return true;
        }
        if (!annotations.remove(a)) {
            return false;
        }
        if (a instanceof GroupAnnotation) {
            GroupAnnotation ga = (GroupAnnotation)a;
            for (Annotation member : ga.getMembers()) {
                if (!AnnotationTree.containsCycle((DingAnnotation)member, annotations, marked)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasSameParent(Collection<? extends Annotation> annotations) {
        DingAnnotation a;
        if (annotations.isEmpty()) {
            return false;
        }
        Iterator<? extends Annotation> iter = annotations.iterator();
        GroupAnnotation parent = null;
        if (iter.hasNext()) {
            a = (DingAnnotation)iter.next();
            parent = a.getGroupParent();
        }
        while (iter.hasNext()) {
            a = (DingAnnotation)iter.next();
            if (parent == a.getGroupParent()) continue;
            return false;
        }
        return true;
    }

    public static List<DingAnnotation> getAncestors(DingAnnotation a) {
        ArrayList<DingAnnotation> ancestors = new ArrayList<DingAnnotation>();
        for (DingAnnotation ancestor = (DingAnnotation)a.getGroupParent(); ancestor != null; ancestor = (DingAnnotation)ancestor.getGroupParent()) {
            ancestors.add(ancestor);
        }
        return ancestors;
    }

    private static void sortAnnotations(List<Annotation> annotations) {
        Comparator comparator = (a1, a2) -> {
            if (a1 instanceof DingAnnotation && a2 instanceof DingAnnotation) {
                DingAnnotation da1 = (DingAnnotation)a1;
                DingAnnotation da2 = (DingAnnotation)a2;
                int z1 = da1.getZOrder();
                int z2 = da2.getZOrder();
                if (z1 >= 0 && z2 >= 0) {
                    return Integer.compare(z1, z2);
                }
                return a1.getName().compareToIgnoreCase(a2.getName());
            }
            return 0;
        };
        Collections.sort(annotations, comparator);
    }

    public static enum Shift {
        UP_ONE,
        DOWN_ONE,
        TO_FRONT,
        TO_BACK;

    }
}

