/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingRenderer;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.internal.util.ViewUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.view.presentation.annotations.GroupAnnotation;

public class AnnotationManagerImpl
implements AnnotationManager {
    private final CyServiceRegistrar serviceRegistrar;

    public AnnotationManagerImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void addAnnotation(Annotation annotation) {
        this.addAnnotations(Arrays.asList(annotation));
    }

    public void addAnnotations(Collection<? extends Annotation> annotations) {
        Map<CyNetworkView, Map<DingAnnotation.CanvasID, List<DingAnnotation>>> annotationsByView = this.groupByViewAndCanvasAndFlatten(annotations, false);
        if (annotationsByView.isEmpty()) {
            return;
        }
        DingRenderer dingRenderer = (DingRenderer)this.serviceRegistrar.getService(DingRenderer.class);
        annotationsByView.forEach((view, annotationsByCanvas) -> annotationsByCanvas.forEach((canvas, canvasAnnotations) -> {
            DRenderingEngine re = dingRenderer.getRenderingEngine((CyNetworkView)view);
            re.getCyAnnotator().checkCycle((Collection<DingAnnotation>)canvasAnnotations);
        }));
        ViewUtil.invokeOnEDTAndWait(() -> annotationsByView.forEach((view, annotationsByCanvas) -> {
            DRenderingEngine re = dingRenderer.getRenderingEngine((CyNetworkView)view);
            ArrayList all = new ArrayList();
            if (annotationsByCanvas.containsKey((Object)DingAnnotation.CanvasID.FOREGROUND)) {
                List foregroundAnnotations = (List)annotationsByCanvas.get((Object)DingAnnotation.CanvasID.FOREGROUND);
                all.addAll(foregroundAnnotations);
            }
            if (annotationsByCanvas.containsKey((Object)DingAnnotation.CanvasID.BACKGROUND)) {
                List backgroundAnnotations = (List)annotationsByCanvas.get((Object)DingAnnotation.CanvasID.BACKGROUND);
                all.addAll(backgroundAnnotations);
            }
            re.getCyAnnotator().addAnnotations(all);
        }));
    }

    public void removeAnnotation(Annotation annotation) {
        this.removeAnnotations(Arrays.asList(annotation));
    }

    public void removeAnnotations(Collection<? extends Annotation> annotations) {
        if (annotations == null | annotations.isEmpty()) {
            return;
        }
        Map<CyNetworkView, Map<DingAnnotation.CanvasID, List<DingAnnotation>>> annotationsByView = this.groupByViewAndCanvasAndFlatten(annotations, true);
        if (annotationsByView.isEmpty()) {
            return;
        }
        DingRenderer dingRenderer = (DingRenderer)this.serviceRegistrar.getService(DingRenderer.class);
        annotationsByView.forEach((view, annotationsByCanvas) -> {
            DRenderingEngine re = dingRenderer.getRenderingEngine((CyNetworkView)view);
            annotationsByCanvas.forEach((canvasId, dingAnnotations) -> {
                for (DingAnnotation a : dingAnnotations) {
                    GroupAnnotation parent = a.getGroupParent();
                    if (parent == null) continue;
                    parent.removeMember((Annotation)a);
                }
                List<DingAnnotation> arrows = AnnotationManagerImpl.getArrows(dingAnnotations);
                re.getCyAnnotator().removeAnnotations(arrows);
                re.getCyAnnotator().removeAnnotations((Collection<? extends Annotation>)dingAnnotations);
            });
        });
    }

    public List<Annotation> getAnnotations(CyNetworkView networkView) {
        DRenderingEngine re = ((DingRenderer)this.serviceRegistrar.getService(DingRenderer.class)).getRenderingEngine(networkView);
        if (re != null) {
            return new ArrayList<Annotation>(re.getCyAnnotator().getAnnotations());
        }
        return Collections.emptyList();
    }

    public List<Annotation> getSelectedAnnotations(CyNetworkView networkView) {
        CyAnnotator cyAnnotator;
        DRenderingEngine re = ((DingRenderer)this.serviceRegistrar.getService(DingRenderer.class)).getRenderingEngine(networkView);
        CyAnnotator cyAnnotator2 = cyAnnotator = re != null ? re.getCyAnnotator() : null;
        if (cyAnnotator != null) {
            return new ArrayList<Annotation>(cyAnnotator.getAnnotationSelection().getSelectedAnnotations());
        }
        return Collections.emptyList();
    }

    private Map<CyNetworkView, Map<DingAnnotation.CanvasID, List<DingAnnotation>>> groupByViewAndCanvasAndFlatten(Collection<? extends Annotation> annotations, boolean incudeExisting) {
        HashMap<CyNetworkView, Map<DingAnnotation.CanvasID, List<DingAnnotation>>> map = new HashMap<CyNetworkView, Map<DingAnnotation.CanvasID, List<DingAnnotation>>>();
        this.groupByView(annotations).forEach((view, as) -> {
            Set<DingAnnotation> flattened = this.flattenAnnotations((CyNetworkView)view, (List<DingAnnotation>)as, incudeExisting);
            map.put((CyNetworkView)view, this.groupByCanvas((CyNetworkView)view, (Collection<DingAnnotation>)flattened));
        });
        return map;
    }

    private Map<CyNetworkView, List<DingAnnotation>> groupByView(Collection<? extends Annotation> annotations) {
        return annotations.stream().filter(a -> a instanceof DingAnnotation).map(a -> (DingAnnotation)a).collect(Collectors.groupingBy(da -> da.getNetworkView()));
    }

    private Map<DingAnnotation.CanvasID, List<DingAnnotation>> groupByCanvas(CyNetworkView view, Collection<DingAnnotation> dingAnnotations) {
        return dingAnnotations.stream().collect(Collectors.groupingBy(da -> AnnotationManagerImpl.getCanvas(view, da)));
    }

    private Set<DingAnnotation> flattenAnnotations(CyNetworkView view, List<DingAnnotation> annotaitons, boolean incudeExisting) {
        HashSet<DingAnnotation> collector = new HashSet<DingAnnotation>();
        for (DingAnnotation a : annotaitons) {
            this.flattenAnnotations(view, a, collector, incudeExisting);
        }
        return collector;
    }

    private void flattenAnnotations(CyNetworkView view, DingAnnotation a, Set<DingAnnotation> collector, boolean includeExisting) {
        DRenderingEngine re = ((DingRenderer)this.serviceRegistrar.getService(DingRenderer.class)).getRenderingEngine(view);
        if (!includeExisting && re.getCyAnnotator().contains(a)) {
            return;
        }
        if (!collector.add(a)) {
            return;
        }
        collector.add(a);
        if (a instanceof GroupAnnotation) {
            for (Annotation member : ((GroupAnnotation)a).getMembers()) {
                this.flattenAnnotations(view, (DingAnnotation)member, collector, includeExisting);
            }
        }
    }

    private static DingAnnotation.CanvasID getCanvas(CyNetworkView view, DingAnnotation annotation) {
        return annotation.getCanvas() == null ? DingAnnotation.CanvasID.FOREGROUND : annotation.getCanvas();
    }

    private static List<DingAnnotation> getArrows(Collection<DingAnnotation> annotations) {
        return annotations.stream().flatMap(a -> a.getArrows().stream()).map(a -> (DingAnnotation)a).collect(Collectors.toList());
    }
}

