/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.canvas;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.cytoscape.ding.PrintLOD;
import org.cytoscape.ding.impl.canvas.CompositeGraphicsCanvas;
import org.cytoscape.ding.impl.canvas.NetworkTransform;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.presentation.NetworkImageFactory;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class NetworkImageFactoryImpl
implements NetworkImageFactory {
    public Image createImage(CyNetworkView networkView, Collection<Annotation> annotations, Map<String, Object> properties) {
        String rendererId = networkView.getRendererId();
        if (!rendererId.equals("org.cytoscape.ding")) {
            throw new IllegalArgumentException("networkView was not created by the ding network view factory, got: " + rendererId);
        }
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        int width = (Integer)properties.getOrDefault("width", 100);
        int height = (Integer)properties.getOrDefault("height", 100);
        boolean fitContent = (Boolean)properties.getOrDefault("fitContent", true);
        CyNetworkViewSnapshot snapshot = networkView.createSnapshot();
        NetworkTransform transform = fitContent ? NetworkImageFactoryImpl.createTransformFitContent(snapshot, width, height) : NetworkImageFactoryImpl.createTransformFromVPs(snapshot, width, height);
        Color bgColor = (Color)networkView.getVisualProperty(BasicVisualLexicon.NETWORK_BACKGROUND_PAINT);
        PrintLOD lod = new PrintLOD();
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        CompositeGraphicsCanvas.paintThumbnail(g, bgColor, lod, transform, snapshot, annotations);
        return image;
    }

    private static NetworkTransform createTransformFromVPs(CyNetworkViewSnapshot snapshot, int width, int height) {
        Double scaleFactor = (Double)snapshot.getVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR);
        Double centerX = (Double)snapshot.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION);
        Double centerY = (Double)snapshot.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION);
        if (scaleFactor == null) {
            scaleFactor = 1.0;
        }
        if (centerX == null) {
            centerX = 0.0;
        }
        if (centerY == null) {
            centerY = 0.0;
        }
        NetworkTransform transform = new NetworkTransform(width, height);
        transform.setScaleFactor(scaleFactor);
        transform.setCenter(centerX, centerY);
        return transform;
    }

    private static NetworkTransform createTransformFitContent(CyNetworkViewSnapshot snapshot, int width, int height) {
        NetworkTransform transform = new NetworkTransform(width, height);
        double[] extents = new double[4];
        snapshot.getSpacialIndex2D().getMBR(extents);
        double centerX = (extents[0] + extents[2]) / 2.0;
        double centerY = (extents[1] + extents[3]) / 2.0;
        double scaleFactor = Math.min((double)transform.getPixelWidth() / (extents[2] - extents[0]), (double)transform.getPixelHeight() / (extents[3] - extents[1])) * 0.98;
        transform.setCenter(centerX, centerY);
        transform.setScaleFactor(scaleFactor);
        return transform;
    }
}

