/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.canvas;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.cytoscape.ding.debug.DebugRootProgressMonitor;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.canvas.AnnotationCanvas;
import org.cytoscape.ding.impl.canvas.EdgeCanvas;
import org.cytoscape.ding.impl.canvas.ImageFuture;
import org.cytoscape.ding.impl.canvas.ImageGraphicsProvider;
import org.cytoscape.ding.impl.canvas.NetworkImageBuffer;
import org.cytoscape.ding.impl.canvas.NetworkTransform;
import org.cytoscape.ding.impl.canvas.NodeCanvas;
import org.cytoscape.ding.impl.canvas.NullGraphicsProvider;
import org.cytoscape.ding.impl.canvas.SelectionCanvas;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.work.ProgressMonitor;
import org.cytoscape.graph.render.stateful.GraphLOD;
import org.cytoscape.graph.render.stateful.RenderDetailFlags;
import org.cytoscape.view.model.CyNetworkViewSnapshot;

public class CompositeImageCanvas {
    private final DRenderingEngine re;
    private final SelectionCanvas<ImageGraphicsProvider> selectionCanvas;
    private final AnnotationCanvas<ImageGraphicsProvider> fgAnnotationCanvas;
    private final NodeCanvas<ImageGraphicsProvider> nodeCanvas;
    private final EdgeCanvas<ImageGraphicsProvider> edgeCanvas;
    private final AnnotationCanvas<ImageGraphicsProvider> bgAnnotationCanvas;
    private Color bgColor = Color.WHITE;
    private GraphLOD lod;
    private final ImageGraphicsProvider image;
    private final NetworkTransform transform;
    private final double[] weights;
    private final Executor executor;

    public CompositeImageCanvas(DRenderingEngine re, GraphLOD lod, int w, int h) {
        this.re = re;
        this.lod = lod;
        this.transform = new NetworkTransform(w, h);
        this.image = CompositeImageCanvas.newBuffer(this.transform);
        this.selectionCanvas = new SelectionCanvas<NullGraphicsProvider>(NullGraphicsProvider.INSTANCE, re);
        this.fgAnnotationCanvas = new AnnotationCanvas<NullGraphicsProvider>(NullGraphicsProvider.INSTANCE, re, DingAnnotation.CanvasID.FOREGROUND);
        this.nodeCanvas = new NodeCanvas<ImageGraphicsProvider>(CompositeImageCanvas.newBuffer(this.transform), re);
        this.edgeCanvas = new EdgeCanvas<ImageGraphicsProvider>(CompositeImageCanvas.newBuffer(this.transform), re);
        this.bgAnnotationCanvas = new AnnotationCanvas<NullGraphicsProvider>(NullGraphicsProvider.INSTANCE, re, DingAnnotation.CanvasID.BACKGROUND);
        this.weights = new double[]{1.0, 20.0, 3.0, 1.0, 0.0};
        re.getCyAnnotator().addPropertyChangeListener(e -> this.updateAnnotationAndSelectionCanvasBuffers());
        re.getLabelSelectionManager().addPropertyChangeListener(e -> this.updateAnnotationAndSelectionCanvasBuffers());
        this.updateAnnotationAndSelectionCanvasBuffers();
        this.executor = re.getSingleThreadExecutorService();
    }

    private static ImageGraphicsProvider newBuffer(NetworkTransform transform) {
        return new NetworkImageBuffer(transform);
    }

    public EdgeCanvas<ImageGraphicsProvider> getEdgeCanvas() {
        return this.edgeCanvas;
    }

    public void showAnnotationSelection(boolean show) {
        this.selectionCanvas.show(show);
        this.fgAnnotationCanvas.setShowSelection(show);
        this.bgAnnotationCanvas.setShowSelection(show);
    }

    private void updateAnnotationAndSelectionCanvasBuffers() {
        boolean hasSel;
        CyAnnotator cyAnnotator = this.re.getCyAnnotator();
        boolean hasFG = cyAnnotator.hasAnnotations(DingAnnotation.CanvasID.FOREGROUND);
        boolean hasBG = cyAnnotator.hasAnnotations(DingAnnotation.CanvasID.BACKGROUND);
        boolean hasLabelSel = !this.re.getLabelSelectionManager().isEmpty();
        boolean bl = hasSel = hasFG || hasBG || hasLabelSel;
        if (hasFG && this.fgAnnotationCanvas.getGraphicsProvier() instanceof NullGraphicsProvider) {
            this.fgAnnotationCanvas.setGraphicsProvider(CompositeImageCanvas.newBuffer(this.transform));
        }
        if (!hasFG && !(this.fgAnnotationCanvas.getGraphicsProvier() instanceof NullGraphicsProvider)) {
            this.fgAnnotationCanvas.setGraphicsProvider(NullGraphicsProvider.INSTANCE);
        }
        if (hasBG && this.bgAnnotationCanvas.getGraphicsProvier() instanceof NullGraphicsProvider) {
            this.bgAnnotationCanvas.setGraphicsProvider(CompositeImageCanvas.newBuffer(this.transform));
        }
        if (!hasBG && !(this.bgAnnotationCanvas.getGraphicsProvier() instanceof NullGraphicsProvider)) {
            this.bgAnnotationCanvas.setGraphicsProvider(NullGraphicsProvider.INSTANCE);
        }
        if (hasSel && this.selectionCanvas.getGraphicsProvier() instanceof NullGraphicsProvider) {
            this.selectionCanvas.setGraphicsProvider(CompositeImageCanvas.newBuffer(this.transform));
        }
        if (!hasSel && !(this.selectionCanvas.getGraphicsProvier() instanceof NullGraphicsProvider)) {
            this.selectionCanvas.setGraphicsProvider(NullGraphicsProvider.INSTANCE);
        }
    }

    public void dispose() {
        this.selectionCanvas.dispose();
        this.fgAnnotationCanvas.dispose();
        this.nodeCanvas.dispose();
        this.edgeCanvas.dispose();
        this.bgAnnotationCanvas.dispose();
    }

    public void setLOD(GraphLOD lod) {
        this.lod = lod;
    }

    public NetworkTransform getTransform() {
        return this.transform;
    }

    public void setBackgroundPaint(Paint paint) {
        this.bgColor = paint instanceof Color ? (Color)paint : Color.WHITE;
    }

    public Color getBackgroundPaint() {
        return this.bgColor;
    }

    protected RenderDetailFlags getRenderDetailFlags(DRenderingEngine.UpdateType updateType) {
        CyNetworkViewSnapshot snapshot = this.re.getViewModelSnapshot();
        return RenderDetailFlags.create(snapshot, this.transform, this.lod, updateType);
    }

    private Image overlayImage(Image composite, Image image) {
        return this.overlayImage(composite, image, 0, 0);
    }

    private Image overlayImage(Image composite, Image image, int dx, int dy) {
        if (image != null) {
            Graphics g = composite.getGraphics();
            g.drawImage(image, dx, dy, null);
        }
        return composite;
    }

    public ImageFuture paint(ProgressMonitor pm, PaintParameters params) {
        ProgressMonitor pm2 = ProgressMonitor.notNull(pm);
        RenderDetailFlags flags = this.getRenderDetailFlags(params.update);
        CompletableFuture<Image> future = CompletableFuture.supplyAsync(() -> this.paintImpl(pm2, flags, params), this.executor);
        return new ImageFuture(future, flags, pm2);
    }

    public ImageFuture paint(ProgressMonitor pm) {
        return this.paint(pm, PaintParameters.updateType(DRenderingEngine.UpdateType.ALL_FULL));
    }

    private static boolean renderAllCanvases(DRenderingEngine.UpdateType ut) {
        return ut == DRenderingEngine.UpdateType.ALL_FAST || ut == DRenderingEngine.UpdateType.ALL_FULL;
    }

    private static boolean renderNodeCanvas(DRenderingEngine.UpdateType ut) {
        return CompositeImageCanvas.renderAllCanvases(ut);
    }

    private static boolean renderEdgeCanvas(DRenderingEngine.UpdateType ut) {
        return CompositeImageCanvas.renderAllCanvases(ut) || ut == DRenderingEngine.UpdateType.JUST_EDGES;
    }

    private static boolean renderAnnotationCanvas(DRenderingEngine.UpdateType ut) {
        return CompositeImageCanvas.renderAllCanvases(ut) || ut == DRenderingEngine.UpdateType.JUST_ANNOTATIONS;
    }

    private Image paintImpl(ProgressMonitor pm, RenderDetailFlags flags, PaintParameters params) {
        Image image;
        ProgressMonitor[] pms = pm.split(this.weights);
        pm.start("Frame");
        Image composite = this.image.getImage();
        this.fill(composite, this.bgColor);
        if (CompositeImageCanvas.renderAnnotationCanvas(params.update)) {
            image = ((ImageGraphicsProvider)this.bgAnnotationCanvas.paintAndGet(pms[0], flags)).getImage();
            this.overlayImage(composite, image);
        } else {
            image = ((ImageGraphicsProvider)this.bgAnnotationCanvas.getCurrent(pms[0])).getImage();
            this.overlayImage(composite, image);
        }
        if (CompositeImageCanvas.renderEdgeCanvas(params.update)) {
            if (params.isPan) {
                image = ((ImageGraphicsProvider)params.slowCanvas.getEdgeCanvas().getGraphicsProvier()).getImage();
                this.overlayImage(composite, image, params.panDx, params.panDy);
                pms[1].addProgress(1.0);
            } else {
                image = ((ImageGraphicsProvider)this.edgeCanvas.paintAndGet(pms[1], flags)).getImage();
                this.overlayImage(composite, image);
            }
        } else {
            image = ((ImageGraphicsProvider)this.edgeCanvas.getCurrent(pms[1])).getImage();
            this.overlayImage(composite, image);
        }
        if (CompositeImageCanvas.renderNodeCanvas(params.update)) {
            image = ((ImageGraphicsProvider)this.nodeCanvas.paintAndGet(pms[2], flags)).getImage();
            this.overlayImage(composite, image);
        } else {
            image = ((ImageGraphicsProvider)this.nodeCanvas.getCurrent(pms[2])).getImage();
            this.overlayImage(composite, image);
        }
        if (CompositeImageCanvas.renderAnnotationCanvas(params.update)) {
            image = ((ImageGraphicsProvider)this.fgAnnotationCanvas.paintAndGet(pms[3], flags)).getImage();
            this.overlayImage(composite, image);
        } else {
            image = ((ImageGraphicsProvider)this.fgAnnotationCanvas.getCurrent(pms[3])).getImage();
            this.overlayImage(composite, image);
        }
        if (CompositeImageCanvas.renderAnnotationCanvas(params.update)) {
            image = ((ImageGraphicsProvider)this.selectionCanvas.paintAndGet(pms[4], flags)).getImage();
            this.overlayImage(composite, image);
        } else {
            image = ((ImageGraphicsProvider)this.selectionCanvas.getCurrent(pms[4])).getImage();
            this.overlayImage(composite, image);
        }
        params.done();
        if (pm instanceof DebugRootProgressMonitor) {
            ((DebugRootProgressMonitor)pm).done(flags, params);
        } else {
            pm.done();
        }
        return composite;
    }

    private void fill(Image image, Color color) {
        NetworkTransform t = this.getTransform();
        Graphics2D g = (Graphics2D)image.getGraphics();
        if (g != null) {
            if (color == null) {
                color = new Color(0, 0, 0, 0);
            }
            g.setColor(color);
            g.fillRect(0, 0, t.getPixelWidth(), t.getPixelHeight());
        }
    }

    public static class PaintParameters {
        private final boolean isPan;
        private final DRenderingEngine.UpdateType update;
        private final int panDx;
        private final int panDy;
        private CompositeImageCanvas slowCanvas;
        private final String panCanvasName;

        private PaintParameters(DRenderingEngine.UpdateType updateType, boolean isPan, int panDx, int panDy, CompositeImageCanvas slowCanvas, String panCanvasName) {
            this.update = updateType;
            this.isPan = isPan;
            this.panDx = panDx;
            this.panDy = panDy;
            this.slowCanvas = slowCanvas;
            this.panCanvasName = panCanvasName;
        }

        public static PaintParameters updateType(DRenderingEngine.UpdateType updateType) {
            return new PaintParameters(updateType, false, 0, 0, null, null);
        }

        public static PaintParameters pan(int panDx, int panDy, CompositeImageCanvas slowCanvas, String panCanvasName) {
            return new PaintParameters(DRenderingEngine.UpdateType.ALL_FAST, true, panDx, panDy, slowCanvas, panCanvasName);
        }

        public boolean isPan() {
            return this.isPan;
        }

        public DRenderingEngine.UpdateType getUpdate() {
            return this.update;
        }

        public int getPanDx() {
            return this.panDx;
        }

        public int getPanDy() {
            return this.panDy;
        }

        public String getPanCanvasName() {
            return this.panCanvasName;
        }

        public void done() {
            this.slowCanvas = null;
        }
    }
}

