/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.canvas;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.cytoscape.ding.impl.canvas.DingCanvas;
import org.cytoscape.ding.impl.canvas.GraphicsProvider;
import org.cytoscape.ding.impl.canvas.NetworkTransform;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.work.ProgressMonitor;
import org.cytoscape.graph.render.stateful.RenderDetailFlags;
import org.cytoscape.view.presentation.annotations.Annotation;

public class AnnotationThumbnailCanvas<GP extends GraphicsProvider>
extends DingCanvas<GP> {
    private Collection<Annotation> annotations;

    public AnnotationThumbnailCanvas(GP graphics, Collection<Annotation> annotations) {
        super(graphics);
        this.annotations = annotations;
    }

    @Override
    public String getCanvasDebugName() {
        return "Annotations";
    }

    @Override
    public void paint(ProgressMonitor pm, RenderDetailFlags flags) {
        Graphics2D g = this.graphicsProvider.getGraphics(true);
        if (g == null) {
            return;
        }
        NetworkTransform transform = this.graphicsProvider.getTransform();
        g.transform(transform.getPaintAffineTransform());
        Rectangle2D.Float visibleArea = transform.getNetworkVisibleAreaNodeCoords();
        for (Annotation ann : this.annotations) {
            DingAnnotation a = (DingAnnotation)ann;
            if (!visibleArea.intersects(a.getBounds()) || a.getGroupParent() != null) continue;
            a.paint(g, false);
        }
        g.dispose();
    }
}

