/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.ding.DVisualLexicon;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingNavigationRenderingEngineFactory;
import org.cytoscape.ding.impl.DingNetworkViewFactory;
import org.cytoscape.ding.impl.DingRenderingEngineFactory;
import org.cytoscape.ding.impl.DingThumbnailRenderingEngineFactory;
import org.cytoscape.ding.impl.DingVisualStyleRenderingEngineFactory;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.presentation.RenderingEngineFactory;

public class DingRenderer
implements NetworkViewRenderer {
    public static final String ID = "org.cytoscape.ding";
    public static final String DISPLAY_NAME = "Cytoscape 2D";
    private final DingNetworkViewFactory viewFactory;
    private final DingRenderingEngineFactory defaultEngineFactory;
    private final DingNavigationRenderingEngineFactory navigationEngineFactory;
    private final DingRenderingEngineFactory vsRenderingFactory;
    private final DingThumbnailRenderingEngineFactory thumbnailEngineFactory;

    public DingRenderer(DingNetworkViewFactory viewFactory, DVisualLexicon dVisualLexicon, CyServiceRegistrar serviceRegistrar) {
        this.viewFactory = viewFactory;
        this.defaultEngineFactory = new DingRenderingEngineFactory(viewFactory, (VisualLexicon)dVisualLexicon);
        this.navigationEngineFactory = new DingNavigationRenderingEngineFactory(viewFactory, serviceRegistrar, (VisualLexicon)dVisualLexicon);
        this.vsRenderingFactory = new DingVisualStyleRenderingEngineFactory(viewFactory, (VisualLexicon)dVisualLexicon);
        this.thumbnailEngineFactory = new DingThumbnailRenderingEngineFactory(viewFactory, (VisualLexicon)dVisualLexicon, serviceRegistrar);
    }

    public DRenderingEngine getRenderingEngine(CyNetworkView view) {
        return this.viewFactory.getRenderingEngine(view);
    }

    public RenderingEngineFactory<CyNetwork> getRenderingEngineFactory(String contextId) {
        switch (contextId) {
            case "": {
                return this.defaultEngineFactory;
            }
            case "birdsEye": {
                return this.navigationEngineFactory;
            }
            case "visualStylePreview": {
                return this.vsRenderingFactory;
            }
            case "thumbnail": {
                return this.thumbnailEngineFactory;
            }
        }
        return null;
    }

    public CyNetworkViewFactory getNetworkViewFactory() {
        return this.viewFactory;
    }

    public String getId() {
        return ID;
    }

    public String toString() {
        return DISPLAY_NAME;
    }
}

