/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import org.cytoscape.ding.DNodeShape;
import org.cytoscape.ding.DVisualLexicon;
import org.cytoscape.ding.impl.DLineType;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingRenderer;
import org.cytoscape.graph.render.stateful.CustomGraphicsInfo;
import org.cytoscape.graph.render.stateful.NodeDetails;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.model.SnapshotNodeInfo;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.values.Justification;
import org.cytoscape.view.presentation.property.values.LineType;
import org.cytoscape.view.presentation.property.values.NodeShape;
import org.cytoscape.view.presentation.property.values.ObjectPosition;
import org.cytoscape.view.presentation.property.values.Position;

public class DNodeDetails
implements NodeDetails {
    private static final float NESTED_IMAGE_SCALE_FACTOR = 0.6f;
    private final DVisualLexicon lexicon;
    private final CyServiceRegistrar registrar;
    private static BufferedImage DEFAULT_NESTED_NETWORK_IMAGE;
    private static BufferedImage RECURSIVE_NESTED_NETWORK_IMAGE;
    private static int nestedNetworkPaintingDepth;

    public DNodeDetails(DVisualLexicon lexicon, CyServiceRegistrar registrar) {
        this.lexicon = lexicon;
        this.registrar = registrar;
    }

    private static int clamp(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    @Override
    public boolean isSelected(View<CyNode> nodeView) {
        return Boolean.TRUE.equals(nodeView.getVisualProperty(BasicVisualLexicon.NODE_SELECTED));
    }

    static Paint getTransparentColor(Paint p, Integer trans) {
        if (trans == null) {
            return p;
        }
        int alpha = DNodeDetails.clamp(trans, 0, 255);
        if (p instanceof Color && ((Color)p).getAlpha() != alpha) {
            Color c = (Color)p;
            return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        }
        return p;
    }

    @Override
    public Color getColorLowDetail(CyNetworkViewSnapshot netView, View<CyNode> nodeView) {
        if (this.isSelected(nodeView)) {
            return this.getSelectedColorLowDetail(netView, nodeView);
        }
        return this.getUnselectedColorLowDetail(netView, nodeView);
    }

    private Color getUnselectedColorLowDetail(CyNetworkViewSnapshot netView, View<CyNode> nodeView) {
        Paint paint = (Paint)nodeView.getVisualProperty(BasicVisualLexicon.NODE_FILL_COLOR);
        if (paint instanceof Color) {
            return (Color)paint;
        }
        paint = (Paint)netView.getViewDefault(BasicVisualLexicon.NODE_FILL_COLOR);
        if (paint instanceof Color) {
            return (Color)paint;
        }
        return (Color)BasicVisualLexicon.NODE_FILL_COLOR.getDefault();
    }

    private Color getSelectedColorLowDetail(CyNetworkViewSnapshot netView, View<CyNode> nodeView) {
        Paint paint = (Paint)nodeView.getVisualProperty(BasicVisualLexicon.NODE_SELECTED_PAINT);
        if (paint instanceof Color) {
            return (Color)paint;
        }
        paint = (Paint)netView.getViewDefault(BasicVisualLexicon.NODE_SELECTED_PAINT);
        if (paint instanceof Color) {
            return (Color)paint;
        }
        return (Color)BasicVisualLexicon.NODE_SELECTED_PAINT.getDefault();
    }

    @Override
    public Paint getFillPaint(View<CyNode> nodeView) {
        if (this.isSelected(nodeView)) {
            return this.getSelectedPaint(nodeView);
        }
        return this.getUnselectedPaint(nodeView);
    }

    private Paint getSelectedPaint(View<CyNode> nodeView) {
        return (Paint)nodeView.getVisualProperty(BasicVisualLexicon.NODE_SELECTED_PAINT);
    }

    public Paint getUnselectedPaint(View<CyNode> nodeView) {
        Paint paint = (Paint)nodeView.getVisualProperty(BasicVisualLexicon.NODE_FILL_COLOR);
        Integer trans = (Integer)nodeView.getVisualProperty(BasicVisualLexicon.NODE_TRANSPARENCY);
        return DNodeDetails.getTransparentColor(paint, trans);
    }

    @Override
    public byte getShape(View<CyNode> nodeView) {
        return DNodeShape.getDShape((NodeShape)nodeView.getVisualProperty(BasicVisualLexicon.NODE_SHAPE)).getNativeShape();
    }

    @Override
    public double getWidth(View<CyNode> nodeView) {
        return (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_WIDTH);
    }

    @Override
    public double getHeight(View<CyNode> nodeView) {
        return (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_HEIGHT);
    }

    @Override
    public float getBorderWidth(View<CyNode> nodeView) {
        return ((Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_BORDER_WIDTH)).floatValue();
    }

    @Override
    public Stroke getBorderStroke(View<CyNode> nodeView) {
        float borderWidth = this.getBorderWidth(nodeView);
        LineType lineType = (LineType)nodeView.getVisualProperty(BasicVisualLexicon.NODE_BORDER_LINE_TYPE);
        return DLineType.getDLineType(lineType).getStroke(borderWidth);
    }

    @Override
    public Paint getBorderPaint(View<CyNode> nodeView) {
        Paint paint = (Paint)nodeView.getVisualProperty(BasicVisualLexicon.NODE_BORDER_PAINT);
        Integer trans = (Integer)nodeView.getVisualProperty(BasicVisualLexicon.NODE_BORDER_TRANSPARENCY);
        return DNodeDetails.getTransparentColor(paint, trans);
    }

    @Override
    public String getLabelText(View<CyNode> nodeView) {
        return (String)nodeView.getVisualProperty(BasicVisualLexicon.NODE_LABEL);
    }

    @Override
    public String getTooltipText(View<CyNode> nodeView) {
        return (String)nodeView.getVisualProperty(BasicVisualLexicon.NODE_TOOLTIP);
    }

    @Override
    public Font getLabelFont(View<CyNode> nodeView) {
        Number size = (Number)nodeView.getVisualProperty(BasicVisualLexicon.NODE_LABEL_FONT_SIZE);
        Font font = (Font)nodeView.getVisualProperty(BasicVisualLexicon.NODE_LABEL_FONT_FACE);
        if (size != null && font != null) {
            font = font.deriveFont(size.floatValue());
        }
        return font;
    }

    @Override
    public Paint getLabelPaint(View<CyNode> nodeView) {
        Paint paint = (Paint)nodeView.getVisualProperty(BasicVisualLexicon.NODE_LABEL_COLOR);
        Integer trans = (Integer)nodeView.getVisualProperty(BasicVisualLexicon.NODE_LABEL_TRANSPARENCY);
        return DNodeDetails.getTransparentColor(paint, trans);
    }

    @Override
    public double getLabelRotation(View<CyNode> nodeView) {
        Double dAngle = (Double)nodeView.getVisualProperty(DVisualLexicon.NODE_LABEL_ROTATION);
        return dAngle == null ? 0.0 : dAngle;
    }

    private CustomGraphicsInfo getCustomGraphicsInfo(VisualProperty<CyCustomGraphics> cgVP, View<CyNode> node) {
        CyCustomGraphics cg = (CyCustomGraphics)node.getVisualProperty(cgVP);
        if (cg == null) {
            return null;
        }
        VisualProperty<Double> sizeVP = DVisualLexicon.getAssociatedCustomGraphicsSizeVP(cgVP);
        Double size = (Double)node.getVisualProperty(sizeVP);
        VisualProperty<ObjectPosition> positionVP = DVisualLexicon.getAssociatedCustomGraphicsPositionVP(cgVP);
        ObjectPosition position = (ObjectPosition)node.getVisualProperty(positionVP);
        CustomGraphicsInfo info = new CustomGraphicsInfo(cgVP);
        info.setCustomGraphics((CyCustomGraphics<? extends CustomGraphicLayer>)cg);
        info.setSize(size);
        info.setPosition(position);
        return info;
    }

    @Override
    public Map<VisualProperty<CyCustomGraphics>, CustomGraphicsInfo> getCustomGraphics(View<CyNode> nodeView) {
        TreeMap<VisualProperty<CyCustomGraphics>, CustomGraphicsInfo> cgInfoMap = new TreeMap<VisualProperty<CyCustomGraphics>, CustomGraphicsInfo>(Comparator.comparing(VisualProperty::getIdString));
        DNodeDetails dNodeDetails = this;
        for (VisualProperty<CyCustomGraphics> cgVP : dNodeDetails.lexicon.getCustomGraphicsVisualProperties()) {
            CustomGraphicsInfo info = this.getCustomGraphicsInfo(cgVP, nodeView);
            if (info == null) continue;
            cgInfoMap.put(cgVP, info);
        }
        return cgInfoMap;
    }

    @Override
    public Position getLabelTextAnchor(View<CyNode> nodeView) {
        ObjectPosition pos = (ObjectPosition)nodeView.getVisualProperty(DVisualLexicon.NODE_LABEL_POSITION);
        return pos == null ? null : pos.getAnchor();
    }

    @Override
    public Position getLabelNodeAnchor(View<CyNode> nodeView) {
        ObjectPosition pos = (ObjectPosition)nodeView.getVisualProperty(DVisualLexicon.NODE_LABEL_POSITION);
        return pos == null ? null : pos.getTargetAnchor();
    }

    @Override
    public float getLabelOffsetVectorX(View<CyNode> nodeView) {
        ObjectPosition pos = (ObjectPosition)nodeView.getVisualProperty(DVisualLexicon.NODE_LABEL_POSITION);
        return pos == null ? 0.0f : (float)pos.getOffsetX();
    }

    @Override
    public float getLabelOffsetVectorY(View<CyNode> nodeView) {
        ObjectPosition pos = (ObjectPosition)nodeView.getVisualProperty(DVisualLexicon.NODE_LABEL_POSITION);
        return pos == null ? 0.0f : (float)pos.getOffsetY();
    }

    @Override
    public Justification getLabelJustify(View<CyNode> nodeView) {
        ObjectPosition pos = (ObjectPosition)nodeView.getVisualProperty(DVisualLexicon.NODE_LABEL_POSITION);
        return pos == null ? null : pos.getJustify();
    }

    @Override
    public double getLabelWidth(View<CyNode> nodeView) {
        return (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_LABEL_WIDTH);
    }

    public Integer getTransparency(View<CyNode> nodeView) {
        return (Integer)nodeView.getVisualProperty(BasicVisualLexicon.NODE_TRANSPARENCY);
    }

    public Integer getLabelTransparency(View<CyNode> nodeView) {
        return (Integer)nodeView.getVisualProperty(BasicVisualLexicon.NODE_LABEL_TRANSPARENCY);
    }

    @Override
    public Integer getBorderTransparency(View<CyNode> nodeView) {
        return (Integer)nodeView.getVisualProperty(BasicVisualLexicon.NODE_BORDER_TRANSPARENCY);
    }

    public Boolean getNestedNetworkImgVisible(View<CyNode> nodeView) {
        return (Boolean)nodeView.getVisualProperty(BasicVisualLexicon.NODE_NESTED_NETWORK_IMAGE_VISIBLE);
    }

    public Double getNodeDepth(View<CyNode> nodeView) {
        return (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_DEPTH);
    }

    @Override
    public double getXPosition(View<CyNode> nodeView) {
        return (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
    }

    @Override
    public double getYPosition(View<CyNode> nodeView) {
        return (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
    }

    @Override
    public double getZPosition(View<CyNode> nodeView) {
        return (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Z_LOCATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TexturePaint getNestedNetworkTexturePaint(CyNetworkViewSnapshot netView, View<CyNode> nodeView) {
        if (this.registrar == null) {
            return null;
        }
        ++nestedNetworkPaintingDepth;
        try {
            boolean nestedNetworkVisible = this.getNestedNetworkImgVisible(nodeView);
            if (!Boolean.TRUE.equals(nestedNetworkVisible)) {
                TexturePaint texturePaint = null;
                return texturePaint;
            }
            SnapshotNodeInfo nodeInfo = netView.getNodeInfo(nodeView);
            CyNode modelNode = ((CyNetwork)netView.getMutableNetworkView().getModel()).getNode(nodeInfo.getModelSUID().longValue());
            if (modelNode == null || nestedNetworkPaintingDepth > 1 || modelNode.getNetworkPointer() == null) {
                TexturePaint texturePaint = null;
                return texturePaint;
            }
            double IMAGE_WIDTH = this.getWidth(nodeView) * (double)0.6f;
            double IMAGE_HEIGHT = this.getHeight(nodeView) * (double)0.6f;
            CyNetworkView nestedNetworkView = this.getNestedNetworkView(netView, nodeView);
            if (netView.getMutableNetworkView() == nestedNetworkView) {
                if (RECURSIVE_NESTED_NETWORK_IMAGE == null) {
                    TexturePaint texturePaint = null;
                    return texturePaint;
                }
                Rectangle2D.Double rect = new Rectangle2D.Double(-IMAGE_WIDTH / 2.0, -IMAGE_HEIGHT / 2.0, IMAGE_WIDTH, IMAGE_HEIGHT);
                TexturePaint texturePaint = new TexturePaint(RECURSIVE_NESTED_NETWORK_IMAGE, rect);
                return texturePaint;
            }
            if (nestedNetworkView != null) {
                DingRenderer dingRenderer = (DingRenderer)this.registrar.getService(DingRenderer.class);
                DRenderingEngine re = dingRenderer.getRenderingEngine(netView.getMutableNetworkView());
                double scaleFactor = re.getGraphLOD().getNestedNetworkImageScaleFactor();
                DRenderingEngine nestedRe = dingRenderer.getRenderingEngine(nestedNetworkView);
                if (nestedRe == null) {
                    TexturePaint texturePaint = null;
                    return texturePaint;
                }
                TexturePaint texturePaint = nestedRe.getSnapshot(IMAGE_WIDTH * scaleFactor, IMAGE_HEIGHT * scaleFactor);
                return texturePaint;
            }
            if (DEFAULT_NESTED_NETWORK_IMAGE == null || this.getWidth(nodeView) == -1.0 || this.getHeight(nodeView) == -1.0) {
                TexturePaint dingRenderer = null;
                return dingRenderer;
            }
            Rectangle2D.Double rect = new Rectangle2D.Double(-IMAGE_WIDTH / 2.0, -IMAGE_HEIGHT / 2.0, IMAGE_WIDTH, IMAGE_HEIGHT);
            TexturePaint texturePaint = new TexturePaint(DEFAULT_NESTED_NETWORK_IMAGE, rect);
            return texturePaint;
        }
        finally {
            --nestedNetworkPaintingDepth;
        }
    }

    public CyNetworkView getNestedNetworkView(CyNetworkViewSnapshot netView, View<CyNode> nodeView) {
        if (this.registrar == null) {
            return null;
        }
        SnapshotNodeInfo nodeInfo = netView.getNodeInfo(nodeView);
        CyNode modelNode = ((CyNetwork)netView.getMutableNetworkView().getModel()).getNode(nodeInfo.getModelSUID().longValue());
        if (modelNode.getNetworkPointer() == null) {
            return null;
        }
        CyNetworkViewManager netViewMgr = (CyNetworkViewManager)this.registrar.getService(CyNetworkViewManager.class);
        Iterator viewIterator = netViewMgr.getNetworkViews(modelNode.getNetworkPointer()).iterator();
        if (viewIterator.hasNext()) {
            return (CyNetworkView)viewIterator.next();
        }
        return null;
    }

    static {
        nestedNetworkPaintingDepth = 0;
        try {
            DEFAULT_NESTED_NETWORK_IMAGE = ImageIO.read(DNodeDetails.class.getClassLoader().getResource("images/default_network.png"));
            RECURSIVE_NESTED_NETWORK_IMAGE = ImageIO.read(DNodeDetails.class.getClassLoader().getResource("images/recursive_network.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
            DEFAULT_NESTED_NETWORK_IMAGE = null;
            RECURSIVE_NESTED_NETWORK_IMAGE = null;
        }
    }
}

