/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.ding.impl.BendImpl;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.HandleInfo;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.model.SnapshotEdgeInfo;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.events.ViewChangeRecord;
import org.cytoscape.view.model.events.ViewChangedEvent;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.values.Bend;
import org.cytoscape.view.presentation.property.values.Handle;
import org.cytoscape.view.presentation.property.values.HandleFactory;

public class BendStore {
    private final DRenderingEngine re;
    private final HandleFactory handleFactory;
    private final CyEventHelper eventHelper;
    private Map<Long, Set<HandleInfo>> selectedHandles = new HashMap<Long, Set<HandleInfo>>();

    public BendStore(DRenderingEngine re, CyEventHelper eventHelper, HandleFactory handleFactory) {
        this.re = re;
        this.eventHelper = eventHelper;
        this.handleFactory = handleFactory;
    }

    public boolean isHandleSelected(HandleInfo key) {
        Set<HandleInfo> handles = this.selectedHandles.get(key.getSUID());
        if (handles == null) {
            return false;
        }
        return handles.contains(key);
    }

    public void selectHandle(HandleInfo key) {
        if (key == null) {
            return;
        }
        this.selectedHandles.computeIfAbsent(key.getSUID(), k -> new HashSet()).add(key);
    }

    public void unselectHandle(HandleInfo key) {
        Set<HandleInfo> handles = this.selectedHandles.get(key.getSUID());
        if (handles == null) {
            return;
        }
        handles.remove(key);
        if (handles.isEmpty()) {
            this.selectedHandles.remove(key.getSUID());
        }
    }

    public void unselectAllHandles() {
        this.selectedHandles.clear();
    }

    public boolean areHandlesSelected() {
        return !this.selectedHandles.isEmpty();
    }

    public void moveSelectedHandles(float dx, float dy) {
        this.bypassAllSelectedBends();
        for (Map.Entry<Long, Set<HandleInfo>> entry : this.selectedHandles.entrySet()) {
            View mutableEdgeView = this.re.getViewModelSnapshot().getMutableEdgeView(entry.getKey().longValue());
            for (HandleInfo handleInfo : entry.getValue()) {
                Handle handle = handleInfo.getHandle();
                Point2D newPoint = handle.calculateHandleLocation(this.re.getViewModel(), mutableEdgeView);
                handle.defineHandle(this.re.getViewModel(), mutableEdgeView, newPoint.getX() + (double)dx, newPoint.getY() + (double)dy);
            }
        }
    }

    private void bypassAllSelectedBends() {
        for (long suid : new HashSet<Long>(this.selectedHandles.keySet())) {
            Bend lockedBend;
            View mutableEdgeView = this.re.getViewModelSnapshot().getMutableEdgeView(suid);
            if (mutableEdgeView == null || (lockedBend = this.createLockedBend((View<CyEdge>)mutableEdgeView)) == null) continue;
            HashSet<HandleInfo> newHandleKeys = new HashSet<HandleInfo>();
            for (HandleInfo key : this.selectedHandles.get(suid)) {
                List allHandles = lockedBend.getAllHandles();
                int index = key.getHandleIndex();
                if (index < 0 || index >= allHandles.size()) continue;
                Handle newHandle = (Handle)allHandles.get(key.getHandleIndex());
                HandleInfo newKey = new HandleInfo(suid, lockedBend, newHandle);
                newHandleKeys.add(newKey);
            }
            this.selectedHandles.put(suid, newHandleKeys);
        }
    }

    private Bend createLockedBend(View<CyEdge> mutableEdgeView) {
        if (mutableEdgeView == null) {
            return null;
        }
        if (mutableEdgeView.isValueLocked((VisualProperty)BasicVisualLexicon.EDGE_BEND)) {
            return null;
        }
        Bend bend = (Bend)mutableEdgeView.getVisualProperty((VisualProperty)BasicVisualLexicon.EDGE_BEND);
        BendImpl lockedBend = bend == BasicVisualLexicon.EDGE_BEND.getDefault() ? new BendImpl() : new BendImpl((BendImpl)bend);
        mutableEdgeView.setLockedValue((VisualProperty)BasicVisualLexicon.EDGE_BEND, (Object)lockedBend);
        return lockedBend;
    }

    private Bend getOrCreateLockedBend(View<CyEdge> mutableEdgeView) {
        if (mutableEdgeView == null) {
            return null;
        }
        if (mutableEdgeView.isValueLocked((VisualProperty)BasicVisualLexicon.EDGE_BEND)) {
            return (Bend)mutableEdgeView.getVisualProperty((VisualProperty)BasicVisualLexicon.EDGE_BEND);
        }
        return this.createLockedBend(mutableEdgeView);
    }

    public HandleInfo addHandle(View<CyEdge> edge, Point2D pt) {
        View mutableEdgeView = this.re.getViewModelSnapshot().getMutableEdgeView(edge.getSUID().longValue());
        Bend bend = this.getOrCreateLockedBend((View<CyEdge>)mutableEdgeView);
        if (mutableEdgeView != null && bend != null) {
            int index = this.getBestHandleIndex(bend, edge, pt);
            if (index < 0) {
                index = 0;
            }
            Handle handle = this.handleFactory.createHandle(this.re.getViewModel(), mutableEdgeView, pt.getX(), pt.getY());
            bend.insertHandleAt(index, handle);
            this.fireViewChangeEvent((View<CyEdge>)mutableEdgeView, bend);
            this.re.updateView(DRenderingEngine.UpdateType.ALL_FULL, true);
            return new HandleInfo(edge, bend, handle);
        }
        return null;
    }

    private Point2D getNodeOffset(long nodeViewSuid) {
        CyNetworkViewSnapshot snapshot = this.re.getViewModelSnapshot();
        double[] extentsBuff = new double[4];
        boolean exists = snapshot.getSpacialIndex2D().get((Object)nodeViewSuid, extentsBuff);
        if (!exists) {
            return null;
        }
        double xCenter = (extentsBuff[0] + extentsBuff[2]) / 2.0;
        double yCenter = (extentsBuff[1] + extentsBuff[3]) / 2.0;
        return new Point2D.Double(xCenter, yCenter);
    }

    private int getBestHandleIndex(Bend bend, View<CyEdge> edge, Point2D pt) {
        List handles = bend.getAllHandles();
        if (handles.isEmpty()) {
            return -1;
        }
        CyNetworkViewSnapshot snapshot = this.re.getViewModelSnapshot();
        SnapshotEdgeInfo edgeInfo = snapshot.getEdgeInfo(edge);
        Point2D sourcePt = this.getNodeOffset(edgeInfo.getSourceViewSUID());
        Point2D targetPt = this.getNodeOffset(edgeInfo.getTargetViewSUID());
        Handle firstHandle = (Handle)handles.get(0);
        Point2D point = firstHandle.calculateHandleLocation((CyNetworkView)snapshot, edge);
        double bestDist = pt.distance(sourcePt) + pt.distance(point) - sourcePt.distance(point);
        int bestInx = 0;
        for (int i = 1; i < handles.size(); ++i) {
            Handle handle1 = (Handle)handles.get(i);
            Handle handle2 = (Handle)handles.get(i - 1);
            Point2D point1 = handle1.calculateHandleLocation((CyNetworkView)snapshot, edge);
            Point2D point2 = handle2.calculateHandleLocation((CyNetworkView)snapshot, edge);
            double distCand = pt.distance(point2) + pt.distance(point1) - point1.distance(point2);
            if (!(distCand < bestDist)) continue;
            bestDist = distCand;
            bestInx = i;
        }
        int lastIndex = handles.size() - 1;
        Handle lastHandle = (Handle)handles.get(lastIndex);
        Point2D lastPoint = lastHandle.calculateHandleLocation((CyNetworkView)snapshot, edge);
        double lastCand = pt.distance(targetPt) + pt.distance(lastPoint) - targetPt.distance(lastPoint);
        if (lastCand < bestDist) {
            bestDist = lastCand;
            bestInx = handles.size();
        }
        return bestInx;
    }

    public void removeHandle(HandleInfo key) {
        Bend bend;
        this.unselectHandle(key);
        View mutableEdgeView = this.re.getViewModelSnapshot().getMutableEdgeView(key.getSUID());
        if (mutableEdgeView != null && (bend = this.getOrCreateLockedBend((View<CyEdge>)mutableEdgeView)) != null) {
            int index = key.getHandleIndex();
            bend.removeHandleAt(index);
            this.fireViewChangeEvent((View<CyEdge>)mutableEdgeView, bend);
        }
    }

    private void fireViewChangeEvent(View<CyEdge> mutableEdgeView, Bend bend) {
        ViewChangeRecord record = new ViewChangeRecord(mutableEdgeView, (VisualProperty)BasicVisualLexicon.EDGE_BEND, (Object)bend, true);
        this.eventHelper.addEventPayload((Object)this.re.getViewModel(), (Object)record, ViewChangedEvent.class);
    }
}

