/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import org.cytoscape.ding.impl.undo.AddEdgeEdit;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.model.View;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;

public class AddEdgeTask
extends AbstractTask
implements ObservableTask {
    private final CyServiceRegistrar registrar;
    private final CyNetworkViewSnapshot netView;
    private final View<CyNode> sourceNodeView;
    private final View<CyNode> targetNodeView;
    private boolean postUndo = true;
    private CyEdge edge;

    public AddEdgeTask(CyServiceRegistrar registrar, CyNetworkViewSnapshot netView, View<CyNode> sourceNodeView, View<CyNode> targetNodeView) {
        this.registrar = registrar;
        this.netView = netView;
        this.sourceNodeView = sourceNodeView;
        this.targetNodeView = targetNodeView;
    }

    public void setPostUndo(boolean postUndo) {
        this.postUndo = postUndo;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Add Edge");
        CyNetworkView mutableNetView = this.netView.getMutableNetworkView();
        View mutableSourceNodeView = this.netView.getMutableNodeView(this.sourceNodeView.getSUID().longValue());
        View mutableTargetNodeView = this.netView.getMutableNodeView(this.targetNodeView.getSUID().longValue());
        if (mutableSourceNodeView == null || mutableTargetNodeView == null) {
            return;
        }
        this.createEdge(mutableNetView, (View<CyNode>)mutableSourceNodeView, (View<CyNode>)mutableTargetNodeView, tm);
    }

    private void createEdge(CyNetworkView netView, View<CyNode> sourceView, View<CyNode> targetView, TaskMonitor tm) {
        CyNetwork net = (CyNetwork)netView.getModel();
        CyNode sourceNode = (CyNode)sourceView.getModel();
        CyNode targetNode = (CyNode)targetView.getModel();
        String sourceName = (String)net.getRow((CyIdentifiable)sourceNode).get("shared name", String.class);
        String targetName = (String)net.getRow((CyIdentifiable)targetNode).get("shared name", String.class);
        String interaction = "interacts with";
        String edgeName = sourceName + " (" + interaction + ") " + targetName;
        tm.setStatusMessage("Adding edge '" + edgeName + "'...");
        this.edge = net.addEdge(sourceNode, targetNode, true);
        CyRow edgeRow = net.getRow((CyIdentifiable)this.edge, "USER");
        edgeRow.set("name", (Object)edgeName);
        edgeRow.set("interaction", (Object)interaction);
        ((CyEventHelper)this.registrar.getService(CyEventHelper.class)).flushPayloadEvents((Object)net);
        VisualStyle vs = ((VisualMappingManager)this.registrar.getService(VisualMappingManager.class)).getVisualStyle(netView);
        View edgeView = netView.getEdgeView(this.edge);
        if (edgeView != null) {
            vs.apply(edgeRow, edgeView);
            if (this.postUndo) {
                AddEdgeEdit addEdgeEdit = new AddEdgeEdit(this.registrar, this.netView, this.sourceNodeView, this.targetNodeView, (View<CyEdge>)edgeView);
                addEdgeEdit.post();
            }
        }
    }

    public <R> R getResults(Class<? extends R> type) {
        if (CyEdge.class.equals(type)) {
            return type.cast(this.edge);
        }
        return null;
    }
}

