/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.cytoscape.ding.debug.DebugFrameType;
import org.cytoscape.ding.debug.DebugRootFrameInfo;
import org.cytoscape.ding.impl.canvas.CompositeImageCanvas;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class FrameListTablePanel
extends JPanel {
    private static final int MAX_ITEMS = 300;
    private final JTable table;
    private final FramePanelTableModel model = new FramePanelTableModel(300);

    public FrameListTablePanel(String title) {
        this.table = new JTable(this.model);
        JLabel label = new JLabel(title);
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{label});
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)label, "North");
        this.add((Component)scrollPane, "Center");
    }

    public void addFrame(DebugRootFrameInfo frame) {
        this.model.add(frame);
        int lastRow = this.model.getRowCount() - 1;
        Rectangle cellRect = this.table.getCellRect(lastRow, 0, true);
        this.table.scrollRectToVisible(cellRect);
    }

    public void clear() {
        this.model.clear();
    }

    private class FramePanelTableModel
    extends AbstractTableModel {
        private static final int NODE_COL = 0;
        private static final int EDGE_COL = 1;
        private static final int TIME_COL = 2;
        private static final int OPT_COL = 3;
        private final int maxSize;
        private LinkedList<DebugRootFrameInfo> list = new LinkedList();

        public FramePanelTableModel(int maxSize) {
            this.maxSize = maxSize;
        }

        public void add(DebugRootFrameInfo entry) {
            if (this.list.size() == this.maxSize) {
                this.list.removeFirst();
                this.fireTableRowsDeleted(0, 0);
            }
            this.list.addLast(entry);
            int last = this.list.size() - 1;
            this.fireTableRowsInserted(last, last);
        }

        public void clear() {
            if (this.list.isEmpty()) {
                return;
            }
            int last = this.list.size() - 1;
            this.list.clear();
            this.fireTableRowsDeleted(0, last);
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 2: {
                    return "Time (MS)";
                }
                case 0: {
                    return "Nodes";
                }
                case 1: {
                    return "Edges";
                }
                case 3: {
                    return "Opt";
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int col) {
            DebugRootFrameInfo entry = this.list.get(row);
            switch (col) {
                case 2: {
                    return this.getTimeMessage(entry);
                }
                case 0: {
                    return entry.getRenderDetailFlags().getVisibleNodeCount();
                }
                case 1: {
                    return entry.getRenderDetailFlags().getEstimatedEdgeCount();
                }
                case 3: {
                    return this.getOptimizationMessage(entry);
                }
            }
            return null;
        }

        public String getTimeMessage(DebugRootFrameInfo entry) {
            long time = entry.getTime();
            DebugFrameType type = entry.getType();
            boolean cancelled = entry.isCancelled();
            if (type == DebugFrameType.MAIN_ANNOTAITONS || type == DebugFrameType.BEV_ANNOTAITONS) {
                return time + " (annotations)";
            }
            if (type == DebugFrameType.MAIN_EDGES) {
                return time + " (edges)";
            }
            if (type == DebugFrameType.MAIN_SELECTED) {
                return time + " (selected)";
            }
            if (cancelled) {
                return time + " (cancelled)";
            }
            return "" + time;
        }

        public String getOptimizationMessage(DebugRootFrameInfo entry) {
            CompositeImageCanvas.PaintParameters params = entry.getPaintParameters();
            if (params.isPan()) {
                return "bpan " + params.getPanCanvasName();
            }
            return "";
        }
    }
}

